/* Nessus Attack Scripting Language
 *
 * Copyright (C) 1999 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include <includes.h>
#include <nessus/pcap.h>
#include "init.h"
#include "pkt_utils.h"
#include "parser.h"
#include "function_call.h"
#define VERSION "0.99.x"
#ifndef MAP_FAILED
#define MAP_FAILED ((void*)-1)
#endif
#include "execute.h"
struct arglist * Globals;
extern int execute_instruction(struct arglist *, char *);
void exit_nasl(struct arglist *, int);

void
sighandler()
{
 nasl_exit(Globals);
}



void
usage()
{
 printf("\nnasl -- Copyright (C) 1999 Renaud Deraison <deraison@cvs.nessus.org>\n\n");
 printf("Usage : nasl [-vhq] [-e expr] [-i interface] [script_file]\n");
 printf("\t-h : shows this help screen\n");
 printf("\t-q : quiet. Only show the script output\n");
 printf("\t-e [expr] : execute [expr] before the script\n");
 printf("\t-v : shows the version number\n");
}


int main(int argc, char ** argv)
{
 struct arglist * globals;
 int i;
 char * command = NULL;
 int q=0;
 while((i = getopt(argc, argv, "qhve:i:"))!=EOF)
  switch(i)
  {
   case 'q':q++;break;
   case 'e' :
   	if(optarg)command = strdup(optarg);
	else {
		usage();
		exit(0);
	 }
	 break;	
   case 'h' :
   	usage();
	exit(0);
	break;
 case 'v' :
 	printf("nasl %s for %s\n\n", VERSION, NESS_OS_NAME);
	printf("Copyright (C) 1999 Renaud Deraison <deraison@cvs.nessus.org>\n");
	printf("See the license for details\n\n\n");
	exit(0);
	break;

 }
 
 if(!q)
 {
 printf("\nnasl -- Copyright (C) 1999 Renaud Deraison <deraison@cvs.nessus.org>\n\n");
#ifdef NESSUS_EXTENSIONS
 printf("ERROR. You are running standalone nasl, but it was compiled with\n");
 printf("-DNESSUS_EXTENSIONS. Hence it can not work. Edit the makefile,\n\
remove this define, make clean and make and try again\n\n");
#endif 
 }
 Globals = globals = init_nasl();
 setuid(getuid());
 signal(SIGINT, sighandler);
 signal(SIGTERM, sighandler);
 /* 
  * First, process the command line instructions
  */	
 if(command)execute_script_buffer(globals, command);
 
 if(!argv[optind])
 {
  if(!command)printf("Error. No input file specified ! \n");
  nasl_exit(globals);
 }
 

 while(argv[optind])
 {
#ifdef DEBUG_NASL
 if(!q)printf("Executing %s : \n", argv[optind]);
#endif
 execute_script(globals, argv[optind]);
 optind++;
 }
 nasl_exit(globals);
 return(0);
}
