/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
#include <includes.h>

#ifdef USE_GTK
#include <gtk/gtk.h>
#include "../xstuff.h"
#include "../preferences.h"
#include "prefs_dialog.h"
#include "../monitor_dialog.h"
#include "../error_dialog.h"
#include "../read_target_file.h"
#include "globals.h"

struct arglist * prefs_dialog_target(preferences)
 struct arglist * preferences;
{
 GtkWidget * frame;
 GtkWidget * table;
 GtkWidget * max_hosts;
 GtkWidget * label;
 GtkWidget * check_dns;
 GtkWidget * entry;
 GtkWidget * box;
 GtkWidget * hbox;
 GtkWidget * button;
 struct arglist *  ctrls = emalloc(sizeof(struct arglist));
 
 frame = gtk_frame_new("Target selection");
 gtk_container_border_width(GTK_CONTAINER(frame), 10);
 gtk_widget_show(frame);
 
 arg_add_value(ctrls,"PREFERENCES", ARG_PTR, -1, frame);
 arg_add_value(ctrls, "FRAME", ARG_PTR, -1, frame);
 
 
 table = gtk_table_new(5, 2, FALSE);
 gtk_container_add(GTK_CONTAINER(frame), table);
 gtk_container_border_width(GTK_CONTAINER(table), 10);
 gtk_table_set_row_spacings(GTK_TABLE(table), 5);
 gtk_widget_show(table);

 label = gtk_label_new("Primary target(s) : ");
 gtk_table_attach(GTK_TABLE(table), label, 0,1,0,1,GTK_FILL | GTK_EXPAND,0,0,0);
 gtk_widget_show(label);
 
 hbox = gtk_hbox_new(FALSE, 10);
 gtk_table_attach(GTK_TABLE(table), hbox, 1,2,0,1, GTK_FILL|GTK_EXPAND, 0,0,0);
 gtk_widget_show(hbox);
 
 entry = gtk_entry_new();
 gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 0);
 gtk_widget_show(entry);
 
 button = gtk_button_new_with_label("Read file...");
 gtk_box_pack_end(GTK_BOX(hbox), button, TRUE, TRUE, 0);
 gtk_signal_connect /*_object*/ (GTK_OBJECT (button),
             "clicked", (GtkSignalFunc)target_file_select, NULL);

 gtk_widget_show(button);
 
 
 gtk_widget_show(entry);
 arg_add_value(ctrls, "TARGET", ARG_PTR, -1, entry);
 
 label = gtk_label_new("Max hosts : ");
 gtk_table_attach(GTK_TABLE(table), label, 0,1,1,2,GTK_FILL | GTK_EXPAND,0,0,0);
 gtk_widget_show(label);
 
 max_hosts = gtk_entry_new();
 arg_add_value(ctrls, "MAX_HOSTS", ARG_PTR, -1, max_hosts);
 gtk_table_attach(GTK_TABLE(table), max_hosts, 1,2,1,2,GTK_FILL | GTK_EXPAND,0,0,0);
 gtk_widget_show(max_hosts);
 
 label = gtk_label_new("Host expansion : ");
 gtk_table_attach(GTK_TABLE(table), label, 0,1,3,4,GTK_FILL | GTK_EXPAND,0,0,0);
 gtk_widget_show(label);
 
 box = gtk_hbox_new(FALSE, 10);
 gtk_table_attach(GTK_TABLE(table), box, 1,2,3,4,GTK_FILL | GTK_EXPAND,0,0,0);
 gtk_widget_show(box);
 
 check_dns = gtk_check_button_new_with_label("Perform a DNS zone transfer");
 arg_add_value(ctrls, "DNS_EXPAND", ARG_PTR, -1, check_dns);
 gtk_box_pack_start(GTK_BOX(box), check_dns, FALSE, FALSE, 0);
 gtk_widget_show(check_dns);
 

 
 
 return(ctrls);
}
#endif
