#
# This script was written by Noam Rathaus <noamr@securiteam.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "An SNMP Agent is running";
 script_name(english:name["english"]);
 
 desc["english"] = "Either (or both) of the ports UDP:161 and UDP:162 are open. This usually
indicates an SNMP agent is present. Having such an agent open to outside
access may be used to compromise sensitive information, and can be used to
cause a Denial of Service attack. Certain SNMP agents (such as BMC's Patrol
Agent) are vulnerable to root compromise attacks.

More Information:
http://www.securiteam.com/exploits/Patrol_s_SNMP_Agent_3_2_can_lead_to_root_compromise.html

Risk factor : High";

 script_description(english:desc["english"]);
 
 summary["english"] = "An SNMP Agent is running";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 1999 SecuriTeam");
 family["english"] = "General";
 script_family(english:family["english"]);
 
 exit(0);
}

#
# The script code starts here
#

 socudp161 = open_sock_udp(161);
 socudp162 = open_sock_udp(162);

 if (socudp161)
 {
  send(socket:socudp161, data:string("\r\n"));
  result = recv(socket:socudp161, length:1000);
  if (result)
  {
   data = "SNMP Agent port open, it is possible to execute
SNMP GET and SET, (with the proper community names)";
   security_warning(port:161, data:data, protocol:"udp");
  }
 }
 if (socudp162)
 {
  send(socket:socudp162, data:string("\r\n"));
  result = recv(socket:socudp162, length:1000);
  if (result)
  {
   data = "SNMP Trap Agent port open, it is possible to
overflow the SNMP Traps log with fake traps (if proper community
names are known), causing a Denial of Service";
   security_warning(port:162, data:data, protocol:"udp");
  }
 }

 close(socudp161);
 close(socudp162);


