/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include	<X11/IntrinsicP.h>
#include	<X11/StringDefs.h>
#include	<X11/Xlib.h>
#include	<X11/xpm.h>

#include	"CheckButtonP.h"
#include	"Init.h"
#include	"utils.h"
#include	"cvt.h"
#include	"misc.h"

/* pixmapy */
#include	"doff.xpm"
#include	"don.xpm"
#include	"roff.xpm"
#include	"ron.xpm"
#include	"c_off.xpm"
#include	"c_on.xpm"
#include	"choff.xpm"
#include	"chon.xpm"
#include	"c2on.xpm"
#include	"c2off.xpm"
#include	"cron.xpm"
#include	"croff.xpm"


#define offset(field) XtOffsetOf(CheckButtonRec,checkButton.field)

/* deklaracia atributov widgetu */
static XtResource resources [] = {
	{
	 XtNset ,
	 XtCSet ,
	 XtRCallback ,
	 sizeof(XtCallbackList) ,
	 offset(set) ,
	 XtRCallback ,
	 (XtPointer) NULL
	},
	{
	 XtNreset ,
	 XtCReset ,
	 XtRCallback ,
	 sizeof(XtCallbackList) ,
	 offset(reset) ,
	 XtRCallback ,
	 (XtPointer) NULL
	},
	{
	 XtNswitch ,
	 XtCSwitch ,
	 XtRCallback ,
	 sizeof(XtCallbackList) ,
	 offset(switch_it) ,
	 XtRCallback ,
	 (XtPointer) NULL
	},
	{
	 XtNon , 
	 XtCOn ,
	 XtRBoolean ,
	 sizeof(Boolean) ,
	 offset(on) ,
	 XtRImmediate ,
	 (XtPointer) False
	},
	{
	 XtNauto_switch , 
	 XtCAuto_switch ,
	 XtRBoolean ,
	 sizeof(Boolean) ,
	 offset(auto_switch) ,
	 XtRImmediate ,
	 (XtPointer) True
	},
	{
	 XtNlabel,
         XtCLabel,
         XtRString,
         sizeof(String),
         offset(label),
         XtRImmediate,
        (XtPointer)NULL 
        },
        {
         XtNfont,
         XtCFont,
         XtRFontStruct,
         sizeof(XFontStruct *),
         offset(font),
         XtRString,
         (XtPointer) XtDefaultFont 
        },
	{
	 XtNspacing ,
	 XtCSpacing ,
	 XtRInt ,
	 sizeof(XtCallbackList) ,
	 offset(spacing) ,
	 XtRImmediate ,
	 (XtPointer) 5
	},
	{
	 XtNbox_type ,
	 XtCBox_type ,
	 XtRInt ,
	 sizeof(int) ,
	 XtOffsetOf(CheckButtonRec,base.box_type) ,
	 XtRImmediate ,
	 (XtPointer) XtCno_box
	},
	{
	 XtNtype ,
	 XtCType ,
	 XtRCheck_type ,
	 sizeof(int) ,
	 offset(type) ,
	 XtRImmediate ,
	 (XtPointer) XtCdiamond
	},
	{
	 XtNhighlight_on_enter ,
	 XtCHighlight_on_enter ,
	 XtRBoolean ,
	 sizeof(Boolean) ,
	 XtOffsetOf(CheckButtonRec,base.highlight_on_enter) ,
	 XtRImmediate ,
	 (XtPointer) True
	},
	{
	 XtNproportional ,
	 XtCProportional ,
	 XtRBoolean ,
	 sizeof(Boolean) ,
	 offset(proportional) ,
	 XtRImmediate ,
	 (XtPointer) False
	},	
};

static void Initialize ();
static void Destroy ();
static void Redisplay ();
static Boolean SetValues ();
static void ClassInitialize();
static XtGeometryResult QueryGeometry();


static void Set ();
static void Reset ();
static void Switch ();

static XtActionsRec action [] = {
	{"set",Set},
	{"reset",Reset},
	{"switch",Switch},
};

static char trans_tab [] = "\
	<Btn1Down>:	switch() \n\
	<Enter>:	highlight() show_help() \n\
	<Leave>:	unhighlight() hide_help() \n\
	<FocusIn>:	focusIn()\n\
	<FocusOut>:	focusOut()\n\
	<Key>space:	switch() \n\
	~Shift<Key>Tab:	traverseForward()\n\
	Shift<Key>Tab:	traverseBackward()\n\
	<BtnDown>:	hide_help()\n\
	<KeyDown>:	hide_help()";

CheckButtonClassRec checkButtonClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &baseClassRec,
    /* class_name            */ "CheckButton",
    /* widget_size           */ sizeof(CheckButtonRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ (XtInitProc) Initialize,
    /* initialize_hook       */ NULL,
    /* realize               */ XtInheritRealize,
    /* actions               */ action,
    /* num_actions           */ XtNumber(action),
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ TRUE,
    /* compress_exposure     */ TRUE,
    /* compress_enterleave   */ TRUE,
    /* visible_interest      */ FALSE,
    /* destroy               */ (XtWidgetProc) Destroy,
    /* resize                */ XtInheritResize,
    /* expose                */ (XtExposeProc) Redisplay,
    /* set_values            */ (XtSetValuesFunc) SetValues,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ XtInheritAcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ trans_tab,
    /* query_geometry        */ QueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
/* base */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* highlight	       */ XtInheritHighlight,
    /* unhighlight	       */ XtInheritUnhighlight ,
    /* highlightBorder	       */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },
/* checkButton */
   {
    /* empty                 */ 0
   }
};

WidgetClass checkButtonWidgetClass = (WidgetClass) & checkButtonClassRec;


static Icon * get_icon(w,icon_data)
CheckButtonWidget w;
char **icon_data;
{
	XColor top , bottom , bc;
	Icon *iconfin = (Icon *) XtMalloc(sizeof(Icon));
	Display *dpy = XtDisplay((Widget) w);
	static XpmColorSymbol	tbl[4];
	XpmAttributes		attributes;

	bc.pixel=w->core.background_pixel;

	XQueryColor(dpy,DefaultColormap(dpy,DefaultScreen(dpy)),&bc);

	LightColor(w->base.box_intensity,bc,top);

	DarkColor(w->base.box_intensity,bc,bottom);

	tbl[0].name="topShadowColor";
	tbl[0].value=NULL;
	tbl[0].pixel=top.pixel;
	tbl[1].name="bottomShadowColor";
	tbl[1].value=NULL;
	tbl[1].pixel=bottom.pixel;
	tbl[2].name="foreground";
	tbl[2].value=NULL;
	tbl[2].pixel=w->base.foreground;
	tbl[3].name="background";
	tbl[3].value=NULL;
	tbl[3].pixel=w->core.background_pixel;
	

	iconfin->shape=None;
	attributes.valuemask = XpmReturnInfos | XpmColorSymbols;
	attributes.colorsymbols = tbl;
	attributes.numsymbols = 4;


	XpmCreatePixmapFromData (dpy , DefaultRootWindow(dpy) , icon_data , 
				&iconfin->pixmap , &iconfin->shape , &attributes);

	iconfin->width = attributes.width;
	iconfin->height = attributes.height;

	return iconfin;
}


static void ClassInitialize()
{

    _InitializeWidgetSet();

    XtSetTypeConverter(XtRString, XtRCheck_type, cvtStringToCheckType,
                       NULL, 0, XtCacheNone, NULL);

}

static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	CheckButtonWidget nw = (CheckButtonWidget) new_widget;
	XGCValues gc_res;
	XtGCMask gc_mask;
	Display *dpy=XtDisplay(new_widget);
	int width=0,height=0;
	char ** id_on , ** id_off;

	switch (nw->checkButton.type)
	{
		case XtCrectangle:
			id_on = ron;
			id_off = roff;
			break;
		case XtCcircle:
			id_on = con;
			id_off = coff;
			break;
		case XtCcheck:
			id_on = chon;
			id_off = choff;
			break;
		case XtCcircle2:
			id_on = c2on;
			id_off = c2off;
			break;
		case XtCcross:
			id_on = cron;
			id_off = croff;
			break;
		case XtCdiamond:
		default :
			id_on = don;
			id_off = doff;
	}	

	nw->checkButton.i_on=get_icon(nw,id_on);
	nw->checkButton.i_off=get_icon(nw,id_off);


	gc_res.background =nw->core.background_pixel;
	gc_res.foreground = nw->base.foreground;
	gc_res.font = nw->checkButton.font->fid;
        gc_mask= GCForeground | GCFont | GCBackground ;

	nw->checkButton.text_gc = XCreateGC(dpy,DefaultRootWindow(dpy),
				gc_mask, &gc_res);

	height = nw->checkButton.i_on->height + 2 * nw->checkButton.spacing;
	width = nw->checkButton.i_on->width + 2 * nw->checkButton.spacing;
	
	if (nw->checkButton.label)
	{
		nw->checkButton.label = XtNewString(nw->checkButton.label);

		height = MAX(height , nw->checkButton.font->max_bounds.descent +
			nw->checkButton.font->max_bounds.ascent +
			2 * nw->checkButton.spacing) ;

		width = width + 2 * nw->checkButton.spacing + 
			XTextWidth(nw->checkButton.font,nw->checkButton.label,
			strlen(nw->checkButton.label));
	}

	if (nw->core.width) width = nw->core.width;
	if (nw->core.height) height = nw->core.height;

	checkButtonClassRec.base_class.set_internal_dimension(new_widget,width,height);
	
	nw->checkButton.entered=False;

}

static void Destroy (w)
Widget w;
{
	CheckButtonWidget cw = (CheckButtonWidget) w;
	Display *dpy = XtDisplay(w);

	XFreeGC(dpy , cw->checkButton.text_gc);

	XFreePixmap(dpy , cw->checkButton.i_on->pixmap);
	XFreePixmap(dpy , cw->checkButton.i_on->shape);
	XFreePixmap(dpy , cw->checkButton.i_off->pixmap);
	XFreePixmap(dpy , cw->checkButton.i_off->shape);

	if (cw->checkButton.label)
		XtFree(cw->checkButton.label);
}

static void Redisplay(w,event,region)
Widget w;
XEvent * event;
Region  region;
{
	CheckButtonWidget nw = (CheckButtonWidget) w;
	Display *dpy = XtDisplay(w);
	Window win = XtWindow(w);
	Position x , y;
	Dimension width , height;
	int text_x , text_y , icon_x , icon_y , pom , text_w = 0 , text_h = 0;
	
	checkButtonClassRec.base_class.get_internal_dimension(w , &x , &y , 
			&width , &height);

	if (nw->checkButton.label)
	{
		text_w = XTextWidth(nw->checkButton.font , nw->checkButton.label ,
			strlen(nw->checkButton.label));
		text_h = nw->checkButton.font->max_bounds.ascent + 
			nw->checkButton.font->max_bounds.descent;
	}

	pom = (width - text_w - nw->checkButton.i_on->width) / 
		((nw->checkButton.label !=NULL) + 2);

	if (nw->checkButton.proportional)
		text_x = width - text_w - pom;
	else
		text_x = 2 * nw->checkButton.spacing + nw->checkButton.i_on->width;

	text_y = (height - text_h) / 2 + nw->checkButton.font->max_bounds.ascent;

	if (nw->checkButton.proportional)
		icon_x = pom;
	else
		icon_x = nw->checkButton.spacing;

	icon_y = (height - nw->checkButton.i_on->height) / 2;

	if (nw->checkButton.label)
	{
		if (nw->base.entered)
			XSetForeground(dpy , nw->checkButton.text_gc , nw->base.activ_fg);
		else
			XSetForeground(dpy , nw->checkButton.text_gc , nw->base.foreground);

		XDrawString(dpy , win , nw->checkButton.text_gc ,
				x + text_x , y + text_y,
				nw->checkButton.label,strlen(nw->checkButton.label));
	}

	XClearArea(dpy , win , x + icon_x , y + icon_y ,
		nw->checkButton.i_on->width , nw->checkButton.i_on->height ,
		False);

	if (nw->checkButton.on)
	{
		X_DrawIcon(dpy , win , nw->checkButton.i_on , x + icon_x , y + icon_y);
	} else {
		X_DrawIcon(dpy , win , nw->checkButton.i_off , x + icon_x , y + icon_y);
	}		
	baseClassRec.core_class.expose(w , event , region);
}

#define WidgetValuesDiffer(w1,w2,component) (w1 -> checkButton.component != \
                                             w2 -> checkButton.component)

static Boolean SetValues(current, request, new_widget, args, num_args)
Widget current;
Widget request;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	CheckButtonWidget cw = (CheckButtonWidget) current;
	CheckButtonWidget nw = (CheckButtonWidget) new_widget;
	Display *dpy = XtDisplay(current);
	Boolean redraw = False;
	char ** id_on , ** id_off;

	if WidgetValuesDiffer( nw , cw , type)
	{
		switch (nw->checkButton.type)
		{
			case XtCrectangle:
				id_on = ron;
				id_off = roff;
				break;
			case XtCcircle:
				id_on = con;
				id_off = coff;
				break;
			case XtCcheck:
				id_on = chon;
				id_off = choff;
				break;
			case XtCcircle2:
				id_on = c2on;
				id_off = c2off;
				break;
			case XtCcross:
				id_on = cron;
				id_off = croff;
				break;
			case XtCdiamond:
			default :
				id_on = doff;
				id_off = don;
		}	
		nw->checkButton.i_on = get_icon(nw,id_on);
		nw->checkButton.i_off  = get_icon(nw,id_off);
		XFreePixmap(dpy , cw->checkButton.i_on->pixmap);
		XFreePixmap(dpy , cw->checkButton.i_on->shape);
		XFreePixmap(dpy , cw->checkButton.i_off->pixmap);
		XFreePixmap(dpy , cw->checkButton.i_off->shape);

		redraw = True;
	}

	if WidgetValuesDiffer(nw , cw , font)
	{

		XSetFont(dpy , nw->checkButton.text_gc , nw->checkButton.font->fid);

		redraw = True;
	}

	if (nw->base.foreground != cw->base.foreground)
	{
		XSetForeground(dpy , nw->checkButton.text_gc , nw->base.foreground);

		redraw = True;
	}

	if (nw->checkButton.on != cw->checkButton.on)
	{
		if (nw->checkButton.on)
			XtCallCallbackList((Widget)nw , nw->checkButton.set, NULL);
		else XtCallCallbackList((Widget)nw , nw->checkButton.reset , NULL);

		XtCallCallbackList((Widget)nw , nw->checkButton.switch_it , NULL);
		redraw = True;
	}

	if WidgetValuesDiffer( nw , cw , label)
	{
		if (cw->checkButton.label)
		{
			XtFree(cw->checkButton.label);
			cw->checkButton.label = NULL;
		}
		if (nw->checkButton.label)
			nw->checkButton.label = XtNewString(nw->checkButton.label);

		redraw = True;		
	}

	return redraw;
}

static XtGeometryResult QueryGeometry(w, intended , preferred)
Widget w;
XtWidgetGeometry *intended;
XtWidgetGeometry *preferred;
{
	CheckButtonWidget cw = (CheckButtonWidget) w;
	Dimension pwidth=0 , pheight=0;
	Dimension width , height;
	Position x,y;

	checkButtonClassRec.base_class.get_internal_dimension(w , &x , &y ,
			&width , &height);

	if (cw->checkButton.label)
	{
		pheight = cw->checkButton.font->max_bounds.descent +
			cw->checkButton.font->max_bounds.ascent +
			2 * cw->checkButton.spacing ;

		pheight = pheight < 2 * cw->checkButton.spacing +
			cw->checkButton.i_on->height
			? 2 * cw->checkButton.spacing +
			cw->checkButton.i_on->height
			: pheight;

		pwidth = 4 * cw->checkButton.spacing + 
			XTextWidth(cw->checkButton.font , cw->checkButton.label,
			strlen(cw->checkButton.label)) +
			cw->checkButton.i_on->width;

	}
	else
	{
		pheight = cw->checkButton.i_on->height + 2 * cw->checkButton.spacing;
		pwidth = cw->checkButton.i_on->width + 2 * cw->checkButton.spacing;
	}

	preferred->request_mode = CWWidth | CWHeight;
	preferred->width = pwidth + (cw->core.width - width) ;
	preferred->height = pheight + (cw->core.height - height);

	if (((intended->request_mode & (CWWidth | CWHeight))
		== (CWWidth | CWHeight)) &&
		intended->width == preferred->width &&
		intended->height == preferred->height)
		return XtGeometryYes;

	else if (preferred->width == cw->core.width &&
		preferred->height == cw->core.height)
		return XtGeometryNo;

	else return XtGeometryAlmost;
	
}
static void Set (w, event, params, num_params)
CheckButtonWidget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	if (w->checkButton.auto_switch)
	{
		w->checkButton.on = True ;
		checkButtonClassRec.core_class.expose((Widget)w,NULL,NULL);
	}
	XtCallCallbackList((Widget)w , w->checkButton.set , NULL);
	XtCallCallbackList((Widget)w , w->checkButton.switch_it , NULL);
}


static void Reset (w, event, params, num_params)
CheckButtonWidget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	if (w->checkButton.auto_switch)
	{
		w->checkButton.on = False ;
		checkButtonClassRec.core_class.expose((Widget)w,NULL,NULL);
	}

	XtCallCallbackList((Widget)w , w->checkButton.reset , NULL);
	XtCallCallbackList((Widget)w , w->checkButton.switch_it , NULL);
}

static void Switch (w, event, params, num_params)
CheckButtonWidget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	if (w->checkButton.auto_switch)
	{
		w->checkButton.on=!w->checkButton.on;
		checkButtonClassRec.core_class.expose((Widget)w,NULL,NULL);
	}

	if (w->checkButton.on) 
		XtCallCallbackList((Widget)w , w->checkButton.set , NULL);
	else XtCallCallbackList((Widget)w , w->checkButton.reset , NULL);


	XtCallCallbackList((Widget)w , w->checkButton.switch_it , NULL);
}

void CheckButtonSet(w , do_calls)
Widget w;
Boolean do_calls;
{
	CheckButtonWidget cw = (CheckButtonWidget) w;

	cw->checkButton.on = True ;
	checkButtonClassRec.core_class.expose(w,NULL,NULL);
	if (do_calls)
	{
		XtCallCallbackList(w,cw->checkButton.set, NULL);

		XtCallCallbackList((Widget)w , cw->checkButton.switch_it , NULL);
	}
}

void CheckButtonReset(w , do_calls)
Widget w;
Boolean do_calls;
{
	CheckButtonWidget cw = (CheckButtonWidget) w;

	cw->checkButton.on = False ;
	checkButtonClassRec.core_class.expose(w,NULL,NULL);
	if (do_calls)
	{
		XtCallCallbackList(w,cw->checkButton.reset, NULL);	

		XtCallCallbackList((Widget)w , cw->checkButton.switch_it , NULL);
	}
}
