/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _EntryLineP_H_
#define _EntryLineP_H_

#include	<Nws/BaseP.h>
#include	<Nws/EntryLine.h>

#if NeedFunctionPrototypes
typedef void (*get_text_dimension_Proc) (Widget , Position * , Position * , Dimension * , Dimension *);
#else
typedef void (*get_text_dimension_Proc) ();
#endif

#define  XtInheritGetTextDimension ((get_text_dimension_Proc) _XtInherit)

typedef struct {
	get_text_dimension_Proc		get_text_dimension;
} EntryLineClassPart;

typedef struct _EntryLineClassRec {
	CoreClassPart		core_class;
	BaseClassPart		base_class;
	EntryLineClassPart	entryLine_class;
} EntryLineClassRec;

extern EntryLineClassRec entryLineClassRec;

typedef struct {
	/* resources */
	Boolean		echo;
	Boolean		editable;
	XFontStruct	*font;
	char		*text;
	char		*valid;
	int		spacing;
	int		max_length;
	Pixel		cursor_color;
	Pixel		selection_fg;
	Pixel		selection_bg;
	XtCallbackList	activate;
	XtCallbackList	change;
	/* private */
	int		text_length;
	int		buffer_length;
	int		crsr_pos;
	int		first;
	int		shown_length;
	Boolean		have_selection;
	Boolean		selecting;
	int		selection_start;
	int		selection_end;
	char		*selection;
	GC		normalGC;
	GC		reverseGC;
} EntryLinePart;

typedef struct _EntryLineRec {
	CorePart	core;
	BasePart	base;
	EntryLinePart	entryLine;
} EntryLineRec;

#endif
