/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <stdio.h>
#include <stdarg.h>

#include	<Nws/ScrollWinP.h>
#include	<Nws/Init.h>
#include	<Nws/cvt.h>
#include	<Nws/misc.h>
#include	<Nws/utils.h>
#include	<Nws/Scrollbar.h>
#include	<Nws/BaseConstP.h>
#include	<Nws/Traverse.h>
#include	<X11/Core.h>

#define offset(field) XtOffsetOf(ScrollWinRec, scrollWin.field)

static XtResource resources[] = { 
	{
	 XtNshow_always_scrollbars ,
	 XtCShow_always_scrollbars ,
	 XtRBoolean ,
	 sizeof(Boolean) ,
	 offset(show_always_scrollbars) ,
	 XtRImmediate ,
	 (XtPointer) False
	},
	{
	 XtNscrollbar_thickness ,
	 XtCScrollbar_thickness ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(scrollbar_thickness) ,
	 XtRImmediate ,
	 (XtPointer) 18
	},
	{
	 XtNposition_x ,
	 XtCPosition_x ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(position_x) ,
	 XtRImmediate ,
	 (XtPointer) 0
	},
	{
	 XtNposition_y ,
	 XtCPosition_y ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(position_y) ,
	 XtRImmediate ,
	 (XtPointer) 0
	},
	{
	 XtNspacing ,
	 XtCSpacing ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(spacing) ,
	 XtRImmediate ,
	 (XtPointer) 2
	},
	{
	 XtNscroll_cb ,
	 XtCScroll_cb ,
	 XtRCallback ,
	 sizeof(XtCallbackList) ,
	 offset(scroll_cb) ,
	 XtRImmediate ,
	 (XtPointer) NULL
	},
	{
	 XtNvincrement ,
	 XtCVincrement ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(vincrement) ,
	 XtRImmediate ,
	 (XtPointer) 10
	},
	{
	 XtNhincrement ,
	 XtCHincrement ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(hincrement) ,
	 XtRImmediate ,
	 (XtPointer) 10
	},
	{
	 XtNslave_mode ,
	 XtCSlave_mode ,
	 XtRBoolean ,
	 sizeof(Boolean) ,
	 offset(slave_mode) ,
	 XtRImmediate ,
	 (XtPointer) False
	},
	{
	 XtNchild_width ,
	 XtCChild_width ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(child_width) ,
	 XtRImmediate ,
	 (XtPointer) 0
	},
	{
	 XtNchild_height ,
	 XtCChild_height ,
	 XtRInt ,
	 sizeof(int) ,
	 offset(child_height) ,
	 XtRImmediate ,
	 (XtPointer) 0
	},
};

static void ClassInitialize();
static void Initialize ();
static Boolean SetValues ();
static void Resize ();
static void Redisplay ();
static void ChangeManaged ();
static XtGeometryResult GeometryManager ();
static void InsertChild ();
static void DeleteChild ();
static void Realize ();
static XtGeometryResult QueryGeometry();
static Boolean AcceptFocus();
static void TraverseOut();
static Widget TraverseInside();
static void Layout ();
static void SetSB ();
static void DrawFocusFrame();

static void scrollHCB ();
static void scrollVCB ();

ScrollWinClassRec scrollWinClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &baseCompClassRec,
    /* class_name            */ "ScrollWin",
    /* widget_size           */ sizeof(ScrollWinRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ (XtInitProc) Initialize,
    /* initialize_hook       */ NULL,
    /* realize               */ Realize,
    /* actions               */ NULL,
    /* num_actions           */ 0,
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ True,
    /* compress_exposure     */ True,
    /* compress_enterleave   */ True,
    /* visible_interest      */ FALSE,
    /* destroy               */ NULL,
    /* resize                */ Resize,
    /* expose                */ Redisplay,
    /* set_values            */ (XtSetValuesFunc) SetValues,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ AcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ NULL,
    /* query_geometry        */ QueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
/* composite */
   {
    /* geometry_manager	     */ GeometryManager,
    /* change_managed	     */ ChangeManaged,
    /* insert_child	     */ InsertChild,
    /* delete_child	     */ DeleteChild,
    /* extension	     */ NULL
   },
/* baseComp */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* traverse                */ XtInheritTraverse,
    /* traverseTo              */ XtInheritTraverseTo,
    /* traverseOut	       */ TraverseOut,
    /* traverseInside          */ TraverseInside,
    /* highlightBorder         */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },
/* scrollWin */
   {
    /* empty		       */ 0
   },
};

WidgetClass scrollWinWidgetClass = (WidgetClass) &scrollWinClassRec;

static void ClassInitialize()
{
	_InitializeWidgetSet();
}

static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	ScrollWinWidget nw = (ScrollWinWidget) new_widget;

	nw->scrollWin.is_in_layout = False;
	nw->scrollWin.normal_ins_child = True;

	nw->scrollWin.vbar = XtVaCreateWidget("__vscrollbar" ,
		scrollbarWidgetClass , new_widget ,
		XtNorientation , XtCvertical ,
		XtNthickness , nw->scrollWin.scrollbar_thickness ,
		XtNbox_color , nw->baseComp.box_color ,
		XtNauto_scrolling , False ,
		NULL);

	XtAddCallback(nw->scrollWin.vbar , XtNscroll_cb , scrollVCB , NULL);

	nw->scrollWin.hbar = XtVaCreateWidget("__hscrollbar" ,
		scrollbarWidgetClass , new_widget ,
		XtNorientation , XtChorizontal ,
		XtNthickness , nw->scrollWin.scrollbar_thickness ,
		XtNbox_color , nw->baseComp.box_color ,
		XtNauto_scrolling , False ,
		NULL);

	XtAddCallback(nw->scrollWin.hbar , XtNscroll_cb , scrollHCB , NULL);


	nw->scrollWin.clipw = XtVaCreateManagedWidget("__clipw" , coreWidgetClass ,
		new_widget , NULL);

	nw->scrollWin.normal_ins_child = False;
	nw->scrollWin.have_child = False;
	nw->scrollWin.schild = NULL;

	Layout(new_widget);
}

static void Realize(w, valueMask, attributes)
Widget w;
Mask *valueMask;
XSetWindowAttributes *attributes;
{
	ScrollWinWidget cw = (ScrollWinWidget) w;

	baseCompClassRec.core_class.realize(w, valueMask, attributes);

	if (cw->scrollWin.have_child && !cw->scrollWin.reparented)
	{
		XtResizeWidget(cw->scrollWin.schild , cw->scrollWin.schild->core.width ,
			cw->scrollWin.schild->core.height , (Dimension) 0);

		XtMoveWidget(cw->scrollWin.schild , cw->scrollWin.position_x ,
			cw->scrollWin.position_y);

		XtRealizeWidget(cw->scrollWin.clipw);

		XtRealizeWidget(cw->scrollWin.schild);

		XReparentWindow(XtDisplay(w) , XtWindow(cw->scrollWin.schild) ,
			XtWindow(cw->scrollWin.clipw) ,
			(Position) cw->scrollWin.position_x ,
			(Position) cw->scrollWin.position_y);		

		XtMapWidget(cw->scrollWin.schild);
	}

	Layout(w);
}

static void Redisplay(w , event , region)
Widget w;
XEvent *event;
Region region;
{
	ScrollWinWidget cw = (ScrollWinWidget) w;
	Dimension width,height;
	Position x,y;

	XtVaGetValues(cw->scrollWin.clipw , XtNx , &x , XtNy , &y ,
		XtNwidth , &width , XtNheight , &height , NULL);

	XClearWindow(XtDisplay(w) , XtWindow(w));

	X_DrawSimple3DFrame(XtDisplay(w) , XtWindow(w) , x - cw->baseComp.box_width ,
		y - cw->baseComp.box_width , width + 2 * cw->baseComp.box_width ,
		height + 2 * cw->baseComp.box_width , cw->baseComp.box_width ,
		cw->baseComp.dark , cw->baseComp.light);

	if (cw->baseComp.current_focused)
		DrawFocusFrame(w , cw->baseComp.bd_color);

	baseCompClassRec.core_class.expose(w , event , region);
}

static void Resize(w)
Widget w;
{
	ScrollWinWidget cw = (ScrollWinWidget) w;

	if (cw->core.width < (2 * cw->scrollWin.scrollbar_thickness + 
		3 * cw->scrollWin.spacing)) 
		cw->core.width = 2 * cw->scrollWin.scrollbar_thickness + 
			3 * cw->scrollWin.spacing;
	if (cw->core.height < (2 * cw->scrollWin.scrollbar_thickness +
		3 * cw->scrollWin.spacing)) 
		cw->core.height = 2 * cw->scrollWin.scrollbar_thickness + 
			3 * cw->scrollWin.spacing;

	Layout(w);
}

#define WidgetValuesDiffer(w1,w2,component) (w1 -> scrollWin.component != \
                                             w2 -> scrollWin.component)

static Boolean SetValues(current, request, new_widget, args, num_args)
Widget current;
Widget request;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	ScrollWinWidget cw = (ScrollWinWidget) current;
	ScrollWinWidget nw = (ScrollWinWidget) new_widget;
	Boolean redraw = False;

	if WidgetValuesDiffer( nw , cw , show_always_scrollbars)
	{
		Layout(new_widget);
		redraw = True;
	}
	if (WidgetValuesDiffer(nw , cw , position_x) && nw->scrollWin.have_child)
	{
		Position y;

		XtVaGetValues(nw->scrollWin.schild , XtNy , &y , NULL);

		XtMoveWidget(nw->scrollWin.schild , nw->scrollWin.position_x , y);
	}

	if (WidgetValuesDiffer(nw , cw , position_y) && nw->scrollWin.have_child)
	{
		Position x;

		XtVaGetValues(nw->scrollWin.schild , XtNx , &x , NULL);

		XtMoveWidget(nw->scrollWin.schild , x , nw->scrollWin.position_y);

	}

	return redraw;
}

static void InsertChild (child)
Widget child;
{
	ScrollWinWidget cw = (ScrollWinWidget) XtParent(child);

	if (cw->scrollWin.normal_ins_child)
	{
		baseCompClassRec.composite_class.insert_child(child);
	}
	else
	{
		if (!cw->scrollWin.have_child)
		{
			cw->scrollWin.schild = child;
			cw->scrollWin.have_child = True;
			cw->scrollWin.reparented = False;
			baseCompClassRec.composite_class.insert_child(child);
		}
		else
		{
			XtWarning("Doesn't insert more children in ScrollWin widget");
		}
	}
}

static void DeleteChild(child)
Widget child;
{
	ScrollWinWidget cw = (ScrollWinWidget) XtParent(child);

	if (cw->scrollWin.schild == child)
	{
		cw->scrollWin.have_child = False;
		cw->scrollWin.schild = NULL;
	}

	baseCompClassRec.composite_class.delete_child(child);
}

static XtGeometryResult GeometryManager(w , request , reply)
Widget w;
XtWidgetGeometry * request;
XtWidgetGeometry * reply;
{
	ScrollWinWidget cw = (ScrollWinWidget) XtParent(w);

	if (!cw->scrollWin.is_in_layout)
		Layout((Widget)cw);
	else if (request->request_mode & (CWWidth | CWHeight))
	{
		XtResizeWidget(w , request->width , request->height , 0);
		Layout((Widget)cw);
	}
	return XtGeometryDone;
}

static XtGeometryResult QueryGeometry(w, intended , preferred)
Widget w;
XtWidgetGeometry *intended;
XtWidgetGeometry *preferred;
{
	ScrollWinWidget cw = (ScrollWinWidget) w;
	XtWidgetGeometry pref_geom;
	Dimension width,height;
	Position x,y;

	((ScrollWinWidgetClass)XtClass(w))->baseComp_class.get_internal_dimension
		(w , &x , &y , &width , &height);

	if (cw->scrollWin.have_child)
	{
		 XtQueryGeometry(cw->scrollWin.schild , intended , &pref_geom);

		 preferred->width = pref_geom.width + 3 * cw->scrollWin.spacing +
		 	cw->scrollWin.scrollbar_thickness + 2 * cw->baseComp.box_width;
		 preferred->height = pref_geom.height + 3 * cw->scrollWin.spacing +
		 	cw->scrollWin.scrollbar_thickness +  2 * cw->baseComp.box_width;
	}
	else
	{
		preferred->width = 2 * cw->scrollWin.scrollbar_thickness + 
			3 * cw->scrollWin.spacing + 2 * cw->baseComp.box_width ;

		preferred->height = 2 * cw->scrollWin.scrollbar_thickness + 
			3 * cw->scrollWin.spacing + 2 * cw->baseComp.box_width ;
	}

	return XtGeometryYes;
}

#define ForAllChildren(cw, childP) \
        for ( (childP) = (cw)->composite.children ; \
                (childP) < ((cw)->composite.children + \
                (cw)->composite.num_children ) ; \
                (childP)++ )


static void ChangeManaged(w)
Widget w;
{
	ScrollWinWidget cw = (ScrollWinWidget) w;

	if (!XtIsRealized(w) || cw->scrollWin.is_in_layout) return;

	if (! cw->scrollWin.have_child) 
	{
		Layout(cw);
		return ;
	}

	if ((! XtIsManaged(cw->scrollWin.schild)) || cw->scrollWin.reparented)
	{
		Layout(cw);
		return;
	}

	if (!cw->scrollWin.slave_mode)
	{
		XtResizeWidget(cw->scrollWin.schild , cw->scrollWin.schild->core.width ,
			cw->scrollWin.schild->core.height , (Dimension) 0);

		XtMoveWidget(cw->scrollWin.schild , cw->scrollWin.position_x ,
			cw->scrollWin.position_y);
	}
	else
	{
		XtResizeWidget(cw->scrollWin.schild , cw->scrollWin.clipw->core.width ,
			cw->scrollWin.clipw->core.height , (Dimension) 0);

		XtMoveWidget(cw->scrollWin.schild , 0 , 0);
	}

	if (!XtIsRealized(cw->scrollWin.schild))
	{
		Window win = XtWindow(w);

		cw->core.window = XtWindow(cw->scrollWin.clipw);
		XtRealizeWidget(cw->scrollWin.schild);
		cw->core.window = win;
	}
	else
	{
		XReparentWindow( XtDisplay(w) , XtWindow(cw->scrollWin.schild) ,
			XtWindow(cw->scrollWin.clipw) ,
			(Position) (cw->scrollWin.slave_mode ? 0 :
			            cw->scrollWin.position_x) ,
			(Position) (cw->scrollWin.slave_mode ? 0 : 
			            cw->scrollWin.position_y));


		XtMapWidget(cw->scrollWin.schild);
	}
	Layout(w);

	cw->scrollWin.reparented = True;

	baseCompClassRec.composite_class.change_managed(w);
}


static void Scroll(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	ScrollWinWidget cw = (ScrollWinWidget) w;
	Dimension _clipwidth , _clipheight;
	int clipwidth , clipheight;
	Dimension chwidth , chheight;
	Position x , y ;
	Position new_x , new_y;	
	static ScrollWinInfo vgeometry;

	if (*num_params != 1)
	{
		XtWarning("Action 'scroll' called with wrong parameters count");
		return;
	}
	if (!cw->scrollWin.have_child) return;

	XtVaGetValues(cw->scrollWin.schild , XtNheight , &chheight ,
		XtNwidth , &chwidth , XtNx , &x , XtNy , &y , NULL);

	XtVaGetValues(cw->scrollWin.clipw , XtNwidth , &_clipwidth ,
		XtNheight , &_clipheight , NULL);

	clipheight = _clipheight;
	clipwidth = _clipwidth;

	new_x = -x;
	new_y = -y;

	if (!strcmp(params[0] , "down"))
	{
		new_y += cw->scrollWin.vincrement;
	}
	else if (!strcmp(params[0] , "right"))
	{
		new_x += cw->scrollWin.hincrement;
	}
	else if (!strcmp(params[0] , "up"))
	{
		new_y -= cw->scrollWin.vincrement;
	}
	else if (!strcmp(params[0] , "left"))
	{
		new_x -= cw->scrollWin.hincrement;
	}
	else if (!strcmp(params[0] , "page_down"))
	{
		new_y += clipheight;
	}
	else if (!strcmp(params[0] , "page_right"))
	{
		new_x += clipwidth;
	}
	else if (!strcmp(params[0] , "page_up"))
	{
		new_y -= clipheight;
	}
	else if (!strcmp(params[0] , "page_left"))
	{
		new_x -= clipwidth;
	}
	else if (!strcmp(params[0] , "page_top"))
	{
		new_y = 0;
	}
	else if (!strcmp(params[0] , "page_bottom"))
	{
		new_y = (chheight - clipheight);
	}
	else if (!strcmp(params[0] , "most_left"))
	{
		new_x = 0;
	}
	else if (!strcmp(params[0] , "most_right"))
	{
		new_x = (chwidth - clipwidth);
	}
	else 
	{
		XtWarning("Action 'scroll' called with wrong parameter");
		return;
	}

	new_y = (new_y < 0) ? 0 : new_y;

	new_y = (new_y > (chheight - clipheight)) ? (chheight - clipheight) : new_y ;

	new_x = (new_x < 0) ? 0 : new_x;

	new_x = (new_x > (chwidth - clipwidth)) ? (chwidth - clipwidth) : new_x ;

	if (!cw->scrollWin.slave_mode)
	{
		XtMoveWidget(cw->scrollWin.schild , -new_x , -new_y);
	}

	SetSB(cw);

	vgeometry.x = -new_x;
	vgeometry.y = -new_y;
	vgeometry.height = clipheight;
	vgeometry.width = clipwidth;

	XtCallCallbackList((Widget)cw , cw->scrollWin.scroll_cb , (XtPointer) &vgeometry);
}

static void Layout(cw)
ScrollWinWidget cw;
{
	Dimension width , height;
	Position x , y;
	Position _px , _py;
	int px,py;
	Dimension _clipwidth , _clipheight;
	int clipwidth , clipheight;
	Boolean show_vbar = False , show_hbar = False;
	XtWidgetGeometry pref_geom , inten_geom;
	int prefw,prefh;
	static ScrollWinInfo vgeometry;

/*	if (cw->scrollWin.is_in_layout) return;
*/
	cw->scrollWin.is_in_layout = True;
	
	scrollWinClassRec.baseComp_class.get_internal_dimension((Widget) cw , &x , &y ,
		&width , &height);

	if (cw->scrollWin.show_always_scrollbars)
	{
		XtVaSetValues(cw->scrollWin.vbar ,
			XtNx , x + width - cw->scrollWin.spacing -
			cw->scrollWin.scrollbar_thickness , 1,
			XtNy , y + cw->scrollWin.spacing ,
			XtNlength , MAX(1 , height - 3 * cw->scrollWin.spacing -
			cw->scrollWin.scrollbar_thickness),
			NULL);

		XtConfigureWidget(cw->scrollWin.vbar , x + width - cw->scrollWin.spacing -
			cw->scrollWin.scrollbar_thickness , y + cw->scrollWin.spacing ,
			cw->scrollWin.scrollbar_thickness , MAX(1 , height - 3 *
			cw->scrollWin.spacing - cw->scrollWin.scrollbar_thickness) ,
			0);

		XtVaSetValues(cw->scrollWin.hbar ,
			XtNx , x + cw->scrollWin.spacing ,
			XtNy , y + height -  cw->scrollWin.spacing -
			cw->scrollWin.scrollbar_thickness ,
			XtNlength , MAX(1 , width - 3 * cw->scrollWin.spacing -
			cw->scrollWin.scrollbar_thickness) ,
			NULL);

		XtConfigureWidget(cw->scrollWin.hbar , x + cw->scrollWin.spacing ,
			 y + height -  cw->scrollWin.spacing -
			cw->scrollWin.scrollbar_thickness ,
			MAX(width - 3 * cw->scrollWin.spacing -
			cw->scrollWin.scrollbar_thickness , 1),
			cw->scrollWin.scrollbar_thickness , 0);

		XtManageChild(cw->scrollWin.hbar);
		XtManageChild(cw->scrollWin.vbar);

		XtVaSetValues(cw->scrollWin.clipw ,
			XtNx , x + cw->scrollWin.spacing + cw->baseComp.box_width,
			XtNy , y + cw->scrollWin.spacing + cw->baseComp.box_width,
			XtNwidth , MAX(1 , width -  3 * cw->scrollWin.spacing -
			cw->scrollWin.scrollbar_thickness - 2 * cw->baseComp.box_width),
			XtNheight , MAX(1 , height -  3 * cw->scrollWin.spacing -
			cw->scrollWin.scrollbar_thickness - 2 * cw->baseComp.box_width),
			NULL);

		XtConfigureWidget(cw->scrollWin.clipw , x + cw->scrollWin.spacing +
			cw->baseComp.box_width, y + cw->scrollWin.spacing +
			cw->scrollWin.spacing , MAX(1 , width -  
			3 * cw->scrollWin.spacing -
			cw->scrollWin.scrollbar_thickness - 2 * cw->baseComp.box_width) ,
			MAX(1 , height -  3 * cw->scrollWin.spacing - 
			2 * cw->baseComp.box_width - 
			cw->scrollWin.scrollbar_thickness), 0);

		if (cw->scrollWin.have_child)
		{

			XtVaGetValues(cw->scrollWin.clipw , XtNwidth , &_clipwidth ,
				XtNheight , &_clipheight , NULL);

			clipheight = _clipheight;
			clipwidth = _clipwidth;

			if (cw->scrollWin.slave_mode)
			{
				prefw = cw->scrollWin.child_width;
				prefh = cw->scrollWin.child_height;				
				px = cw->scrollWin.position_x;
				py = cw->scrollWin.position_y;
			}
			else
			{
				XtVaGetValues(cw->scrollWin.schild ,
					XtNx , &_px , XtNy , &_py , NULL);

				inten_geom.request_mode = CWWidth | CWHeight;
				inten_geom.width = clipwidth;
				inten_geom.height = clipheight;

				XtQueryGeometry(cw->scrollWin.schild , &inten_geom , &pref_geom);

				prefw = pref_geom.width;
				prefh = pref_geom.height;
				px = _px;
				py = _py;
			}

			if ((prefw - (-px)) <  clipwidth)
				px = - (prefw - clipwidth);

			if (px > 0) px = 0;
			
			if ((prefh -(-py)) < clipheight) 
				py = -(prefh - clipheight);
			
			if (py > 0) py = 0;

			if (clipheight > prefh)
				prefh = clipheight;
			
			if (clipwidth > prefw)
				prefw = clipwidth;


			if (cw->scrollWin.slave_mode)
			{
				cw->scrollWin.child_width = prefw;
				cw->scrollWin.child_height = prefh;
				cw->scrollWin.position_x = px;
				cw->scrollWin.position_y = py;

				XtResizeWidget(cw->scrollWin.schild , clipwidth ,
					clipheight , 0);

				vgeometry.x = px;
				vgeometry.y = py;
				vgeometry.height = clipheight;
				vgeometry.width = clipwidth;

				XtCallCallbackList((Widget)cw , cw->scrollWin.scroll_cb ,
					 (XtPointer) &vgeometry);
			}
			else
			{
				XtResizeWidget(cw->scrollWin.schild , prefw ,
					prefh , 0);

				XtMoveWidget(cw->scrollWin.schild , px , py);
			}
		}
	}
	else
	{
		if (cw->scrollWin.have_child)
		{

			
			clipwidth = width - 2 * cw->scrollWin.spacing - 
				2 * cw->baseComp.box_width;

			clipheight = height - 2 * cw->scrollWin.spacing - 
				2 * cw->baseComp.box_width;

			if (cw->scrollWin.slave_mode)
			{
				prefw = cw->scrollWin.child_width;
				prefh = cw->scrollWin.child_height;				
				px = cw->scrollWin.position_x;
				py = cw->scrollWin.position_y;
			}
			else
			{
				XtVaGetValues(cw->scrollWin.schild ,
					XtNx , &_px , XtNy , &_py , NULL);

				inten_geom.request_mode = CWWidth | CWHeight;
				inten_geom.width = clipwidth;
				inten_geom.height = clipheight;

				XtQueryGeometry(cw->scrollWin.schild , &inten_geom , &pref_geom);

				prefw = pref_geom.width;
				prefh = pref_geom.height;
				px = _px;
				py = _py;
			}

			if (clipwidth < prefw) 
			{
				clipheight = clipheight - cw->scrollWin.spacing -
					cw->scrollWin.scrollbar_thickness;
				show_hbar = True;

			}

			if (clipheight < prefh)
			{
				clipwidth = clipwidth - cw->scrollWin.spacing -
					cw->scrollWin.scrollbar_thickness;
				show_vbar = True;
			}

			if (clipwidth < prefw && !show_hbar) 
			{
				clipheight = clipheight - cw->scrollWin.spacing -
					cw->scrollWin.scrollbar_thickness;
				show_hbar = True;

			}

			if (clipheight < prefh  && !show_vbar)
			{
				clipwidth = clipwidth - cw->scrollWin.spacing -
					cw->scrollWin.scrollbar_thickness;
				show_vbar = True;
			}

			XtVaSetValues(cw->scrollWin.vbar ,
				XtNx , x + width - cw->scrollWin.spacing -
				cw->scrollWin.scrollbar_thickness ,
				XtNy , y + cw->scrollWin.spacing ,
				XtNlength ,MAX(1 , clipheight +
				2 * cw->baseComp.box_width) ,
				NULL);

			XtConfigureWidget(cw->scrollWin.vbar , x + width - 
				cw->scrollWin.spacing - cw->scrollWin.scrollbar_thickness,
				y + cw->scrollWin.spacing ,
				cw->scrollWin.scrollbar_thickness ,
				MAX(1 , clipheight + 2 * cw->baseComp.box_width) , 0);

			XtVaSetValues(cw->scrollWin.hbar ,
				XtNx , x + cw->scrollWin.spacing ,
				XtNy , y + height -  cw->scrollWin.spacing -
				cw->scrollWin.scrollbar_thickness ,
				XtNlength , clipwidth +
				MAX(1 , 2 * cw->baseComp.box_width) ,
				NULL);

			XtConfigureWidget(cw->scrollWin.hbar , x + cw->scrollWin.spacing ,
				y + height -  cw->scrollWin.spacing -
				cw->scrollWin.scrollbar_thickness ,
				MAX(1 , clipwidth + 2 * cw->baseComp.box_width) ,
				cw->scrollWin.scrollbar_thickness , 0);

			if (show_vbar)
			{
				XtManageChild(cw->scrollWin.vbar);
			}
			else
			{
				XtUnmanageChild(cw->scrollWin.vbar);
			}

			if (show_hbar)
			{
				XtManageChild(cw->scrollWin.hbar);
			}
			else
			{
				XtUnmanageChild(cw->scrollWin.hbar);
			}

			XtVaSetValues(cw->scrollWin.clipw ,
				XtNx , x + cw->scrollWin.spacing + cw->baseComp.box_width,
				XtNy , y + cw->scrollWin.spacing + cw->baseComp.box_width,
				XtNwidth , MAX(1 , clipwidth) ,
				XtNheight , MAX(1 , clipheight),
				NULL);

			XtConfigureWidget(cw->scrollWin.clipw ,
				x + cw->scrollWin.spacing + cw->baseComp.box_width ,
				y + cw->scrollWin.spacing + cw->baseComp.box_width ,
				MAX(1 , clipwidth) , MAX(1 , clipheight) , 0);

			if ((prefw - (-px)) <  clipwidth)
				px = - (prefw - clipwidth);

			if (px > 0) px = 0;
			
			if ((prefh -(-py)) < clipheight)
				py = -(prefh - clipheight);
			
			if (py > 0) py = 0;

			if (clipheight > prefh)
				prefh = clipheight;
			
			if (clipwidth > prefw)
				prefw = clipwidth;

			if (cw->scrollWin.slave_mode)
			{
				cw->scrollWin.child_width = prefw;
				cw->scrollWin.child_height = prefh;
				cw->scrollWin.position_x = px;
				cw->scrollWin.position_y = py;

				XtResizeWidget(cw->scrollWin.schild , clipwidth ,
					clipheight , 0);

				vgeometry.x = px;
				vgeometry.y = py;
				vgeometry.height = clipheight;
				vgeometry.width = clipwidth;

				XtCallCallbackList((Widget)cw , cw->scrollWin.scroll_cb ,
					 (XtPointer) &vgeometry);
				
			}
			else
			{
				XtResizeWidget(cw->scrollWin.schild , MAX(1 , prefw) ,
					MAX(1 , prefh) , 0);

				XtMoveWidget(cw->scrollWin.schild , px , py);
			}
			
		}
		else
		{
			XtUnmanageChild(cw->scrollWin.hbar);
			XtUnmanageChild(cw->scrollWin.vbar);

			XtVaSetValues(cw->scrollWin.clipw ,
				XtNx , x + cw->scrollWin.spacing + cw->baseComp.box_width,
				XtNy , y + cw->scrollWin.spacing + cw->baseComp.box_width,
				XtNwidth , MAX(1 , width - 2 * cw->scrollWin.spacing -
				2 * cw->baseComp.box_width) ,
				XtNheight , MAX(1 , height - 2 * cw->scrollWin.spacing - 
				2 * cw->baseComp.box_width) ,
				NULL);

			XtConfigureWidget(cw->scrollWin.clipw ,
				x + cw->scrollWin.spacing + cw->baseComp.box_width, 
				y + cw->scrollWin.spacing + cw->baseComp.box_width,
				MAX(1 , width - 2 * cw->scrollWin.spacing -
				2 * cw->baseComp.box_width) ,
				MAX(1 , height - 2 * cw->scrollWin.spacing -
				2 * cw->baseComp.box_width) , 0);

			XtVaSetValues(cw->scrollWin.vbar ,
				XtNx , x + width - cw->scrollWin.spacing -
				cw->scrollWin.scrollbar_thickness ,
				XtNy , y + cw->scrollWin.spacing ,
				XtNlength ,MAX(1 , height - 3 * cw->scrollWin.spacing -
				cw->scrollWin.scrollbar_thickness) ,
				NULL);

			XtVaSetValues(cw->scrollWin.hbar ,
				XtNx , x + cw->scrollWin.spacing ,
				XtNy , y + height -  cw->scrollWin.spacing -
				cw->scrollWin.scrollbar_thickness ,
				XtNlength , MAX(1 , width - 3 * cw->scrollWin.spacing -
				cw->scrollWin.scrollbar_thickness) ,
				NULL);
		}
	}
	
	SetSB(cw);

	cw->scrollWin.is_in_layout = False;
}

static void SetSB(cw)
ScrollWinWidget cw;
{
	float size,pos;

	if (!XtIsRealized((Widget)cw)) return;

	if (cw->scrollWin.have_child)
	{
		Dimension _clipwidth , _clipheight;
		Dimension clipwidth , clipheight;
		int chwidth , chheight;
		int x,y;

		if (!cw->scrollWin.slave_mode)
		{
			Dimension _chwidth , _chheight;
			Position _x , _y;

			XtVaGetValues(cw->scrollWin.schild , XtNheight , &_chheight ,
				XtNwidth , &_chwidth , XtNx , &_x , XtNy , &_y , NULL);
			
			chheight = _chheight;
			chwidth = _chwidth;
			x = _x;
			y = _y;
		}
		else
		{
			chheight = cw->scrollWin.child_height;
			chwidth = cw->scrollWin.child_width;
			x = cw->scrollWin.position_x;
			y = cw->scrollWin.position_y;
		}

		XtVaGetValues(cw->scrollWin.clipw , XtNwidth , &_clipwidth ,
			XtNheight , &_clipheight , NULL);

		clipheight = _clipheight;
		clipwidth = _clipwidth;

		size = (float) ((float)clipheight /(float) chheight);
		pos = (float) ((float)(-y) /(float) MAX((chheight-clipheight),0.000001));

		SetScrollbar(cw->scrollWin.vbar , pos , size);

		size = (float) ((float)clipwidth /(float)chwidth);
		pos = (float) ((float)(-x) /(float) MAX((chwidth-clipwidth),0.000001));

		SetScrollbar(cw->scrollWin.hbar , pos , size);
	}
	else
	{
		SetScrollbar(cw->scrollWin.hbar ,(float) 0.0 , (float)1.0);
		SetScrollbar(cw->scrollWin.vbar ,(float) 0.0 , (float)1.0);
	}
}

static void scrollVCB(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	ScrollbarSetting *sbstat = (ScrollbarSetting*) call_data;
	ScrollWinWidget cw = (ScrollWinWidget) XtParent(w);
	Dimension _clipwidth , _clipheight;
	int clipwidth , clipheight;
	int chwidth , chheight;
	int x , y ;
	static ScrollWinInfo vgeometry;

	if (!cw->scrollWin.schild) return;

	if (!cw->scrollWin.slave_mode)
	{
		Dimension _chwidth , _chheight;
		Position _x , _y;

		XtVaGetValues(cw->scrollWin.schild , XtNheight , &_chheight ,
			XtNwidth , &_chwidth , XtNx , &_x , XtNy , &_y , NULL);

		chheight = _chheight;
		chwidth = _chwidth;
		x = _x;
		y = _y;
	}
	else
	{
			chheight = cw->scrollWin.child_height;
			chwidth = cw->scrollWin.child_width;
			x = cw->scrollWin.position_x;
			y = cw->scrollWin.position_y;
	}

	XtVaGetValues(cw->scrollWin.clipw , XtNwidth , &_clipwidth ,
		XtNheight , &_clipheight , NULL);

	clipheight = _clipheight;
	clipwidth = _clipwidth;

	y = -y;
	switch (sbstat->where)
	{
		case TOP_ARROW:
			y -= cw->scrollWin.vincrement;
			break;
		case BOTTOM_ARROW:
			y += cw->scrollWin.vincrement;
			break;
		case TOP_GAP:
			y -= clipheight;
			break;
		case BOTTOM_GAP:
			y += clipheight;
			break;
		case SLIDER:
			y = (int)(sbstat->position * (chheight - clipheight));

			if (cw->scrollWin.slave_mode)
				cw->scrollWin.position_y = -y;
			else
				XtMoveWidget(cw->scrollWin.schild , x , -y);

			vgeometry.x = x;
			vgeometry.y = -y;
			vgeometry.height = clipheight;
			vgeometry.width = clipwidth;


			XtCallCallbackList((Widget)cw , cw->scrollWin.scroll_cb , 
				(XtPointer) &vgeometry);

			return;
		case NOTHING:
		default:
			return;
	}
	y = (y < 0) ? 0 : y;

	y = (y > (chheight - clipheight)) ? (chheight - clipheight) : y ;

	if (cw->scrollWin.slave_mode)
	{
		cw->scrollWin.position_y = -y;
	}
	else
		XtMoveWidget(cw->scrollWin.schild , x , -y);

	SetSB(cw);

	vgeometry.x = x;
	vgeometry.y = -y;
	vgeometry.height = clipheight;
	vgeometry.width = clipwidth;

	XtCallCallbackList((Widget)cw , cw->scrollWin.scroll_cb , (XtPointer) &vgeometry);
}

static void scrollHCB(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
	ScrollbarSetting *sbstat = (ScrollbarSetting*) call_data;
	ScrollWinWidget cw = (ScrollWinWidget) XtParent(w);
	Dimension _clipwidth , _clipheight;
	int clipwidth , clipheight;
	int chwidth , chheight;
	int x,y;
	static ScrollWinInfo vgeometry;

	if (!cw->scrollWin.schild) return;

	if (!cw->scrollWin.slave_mode)
	{
		Dimension _chwidth , _chheight;
		Position _x , _y;

		XtVaGetValues(cw->scrollWin.schild , XtNheight , &_chheight ,
			XtNwidth , &_chwidth , XtNx , &_x , XtNy , &_y , NULL);

		chheight = _chheight;
		chwidth = _chwidth;
		x = _x;
		y = _y;
	}
	else
	{
			chheight = cw->scrollWin.child_height;
			chwidth = cw->scrollWin.child_width;
			x = cw->scrollWin.position_x;
			y = cw->scrollWin.position_y;
	}

	XtVaGetValues(cw->scrollWin.clipw , XtNwidth , &_clipwidth ,
		XtNheight , &_clipheight , NULL);

	clipheight = _clipheight;
	clipwidth = _clipwidth;

	x = -x;
	switch (sbstat->where)
	{
		case LEFT_ARROW:
			x -= cw->scrollWin.hincrement;
			break;
		case RIGHT_ARROW:
			x += cw->scrollWin.hincrement;
			break;
		case LEFT_GAP:
			x -= clipwidth;
			break;
		case RIGHT_GAP:
			x += clipwidth;
			break;
		case SLIDER:
			x = (int)(sbstat->position * (chwidth - clipwidth));

			if (cw->scrollWin.slave_mode)
				cw->scrollWin.position_x = -x;
			else
				XtMoveWidget(cw->scrollWin.schild , -x , y);

			vgeometry.x = -x;
			vgeometry.y = y;
			vgeometry.height = clipheight;
			vgeometry.width = clipwidth;


			XtCallCallbackList((Widget)cw , cw->scrollWin.scroll_cb , 
				(XtPointer) &vgeometry);

			return;
		case NOTHING:
		default:
			return;
	}

	x = (x < 0) ? 0 : x;

	x = (x > (chwidth - clipwidth)) ? (chwidth - clipwidth) : x ;
	
	if (cw->scrollWin.slave_mode)
	{
		cw->scrollWin.position_x = -x;
	}
	else
		XtMoveWidget(cw->scrollWin.schild , -x ,y);

	SetSB(cw);

	vgeometry.x = -x;
	vgeometry.y = y;
	vgeometry.height = clipheight;
	vgeometry.width = clipwidth;

	XtCallCallbackList((Widget)cw , cw->scrollWin.scroll_cb , (XtPointer) &vgeometry);
}

void SetScrollWin(Widget w , ...)
{
	ScrollWinWidget cw = (ScrollWinWidget) w;
	Dimension _clipwidth , _clipheight;
	int clipwidth , clipheight;
	int chwidth , chheight;
	int x,y;
	int pos,which;
	static ScrollWinInfo vgeometry;
	Boolean need_layout = False;
	va_list	args;

	if (!cw->scrollWin.slave_mode)
	{
		Dimension _chwidth , _chheight;
		Position _x , _y;

		XtVaGetValues(cw->scrollWin.schild , XtNheight , &_chheight ,
			XtNwidth , &_chwidth , XtNx , &_x , XtNy , &_y , NULL);

		chheight = _chheight;
		chwidth = _chwidth;
		x = _x;
		y = _y;
	}
	else
	{
			chheight = cw->scrollWin.child_height;
			chwidth = cw->scrollWin.child_width;
			x = cw->scrollWin.position_x;
			y = cw->scrollWin.position_y;
	}

	XtVaGetValues(cw->scrollWin.clipw , XtNwidth , &_clipwidth ,
		XtNheight , &_clipheight , NULL);

	clipheight = _clipheight;
	clipwidth = _clipwidth;

	va_start(args , w);

	for (which = va_arg(args , int) ; which ; which = va_arg(args , int))
	{
		pos = va_arg(args , int);

		switch (which)
		{
			case XtCbottom_border:
				cw->scrollWin.position_y = y = 
					-(MIN((abs(pos) - clipheight),(chheight - clipheight)));
				break;
			case XtCtop_border:
				cw->scrollWin.position_y = y = 
					-(MIN(abs(pos) , (chheight - clipheight)));
				break;
			case XtCleft_border:
				cw->scrollWin.position_x = x = 
					-(MIN(abs(pos) , (chwidth - clipwidth)));
				break;
			case XtCright_border:
				cw->scrollWin.position_x = x = 
					-(MIN((abs(pos) - clipwidth) , (chwidth - clipwidth)));
				break;
			case XtCchild_width:
				if (((pos - clipwidth) * 
				    (cw->scrollWin.child_width -clipwidth)) < 0) 
			    		need_layout = True;

				cw->scrollWin.child_width = chwidth = pos;
				break;
			case XtCchild_height:
				if (((pos - clipheight) * 
				    (cw->scrollWin.child_height - clipheight)) < 0) 
				    	need_layout = True;

				cw->scrollWin.child_height = chheight = pos;
				break;
			default:
				printf("Bad request to SetScrollWin\n");
				return;
		}
	}

	va_end(args);

	if (cw->scrollWin.position_x > 0) 
	{
		cw->scrollWin.position_x = 0;
		x = 0;
	}

	if (cw->scrollWin.position_y > 0) 
	{
		cw->scrollWin.position_y = 0;
		y = 0;
	}

	if (!cw->scrollWin.slave_mode)
	{
		XtMoveWidget(cw->scrollWin.schild , x , y);
		XtResizeWidget(cw->scrollWin.schild , chwidth , chheight , 
			cw->scrollWin.schild->core.border_width);
	}
	else
	{
		vgeometry.x = x;
		vgeometry.y = y;
		vgeometry.height = clipheight;
		vgeometry.width = clipwidth;

		XtCallCallbackList((Widget)cw , cw->scrollWin.scroll_cb , (XtPointer) &vgeometry);
	}

	SetSB(cw);

	if (need_layout) Layout(w);
}

static Boolean AcceptFocus(w , time)
Widget w;
Time *time;
{
	BaseCompWidget cw = (BaseCompWidget) w;

	if (!XtIsRealized(w) || !XtIsSensitive(w) || !cw->core.visible ||
		!cw->core.ancestor_sensitive || cw->core.being_destroyed ||
		!XtIsManaged(w))
		return False;

	if (cw->baseComp.traverse)
	{
		if (cw->baseComp.current_focused)
		{
			if (((BaseCompWidgetClass)cw->core.widget_class)->
		        	baseComp_class.traverseInside(w ,
		        	TRAVERSE_ACTUAL , time) != NULL)
		        {
				DrawFocusFrame(w , cw->baseComp.bd_color);
		        	return True;
		        }
		       	return False;

		}
		else
		{
			if (((BaseCompWidgetClass)cw->core.widget_class)->
		        	baseComp_class.traverseInside(w , 
		        	cw->baseComp.traverse_direction , time) != NULL)
		        {
				DrawFocusFrame(w , cw->baseComp.bd_color);
		        	return True;
		        }
		        return False;
		}
	}
	else
	{
		if (Xt_IsUp(w))
		{
			XSetInputFocus(XtDisplay(w), XtWindow(w), RevertToParent , *time);
			((BaseCompWidgetClass)cw->core.widget_class)
				->baseComp_class.highlightBorder(w);
		}
		return True;
	}
}

static void TraverseOut(w)
Widget w;
{
	BaseCompWidget cw = (BaseCompWidget) w;

	baseCompClassRec.baseComp_class.traverseOut(w);

	DrawFocusFrame(w , cw->core.background_pixel);
}

static Widget TraverseInside(w , where , time)
Widget w;
int where;
Time *time;
{
	BaseCompWidget cw = (BaseCompWidget) w;
	Widget res;

	res = baseCompClassRec.baseComp_class.traverseInside(w , where , time);

	DrawFocusFrame(w, res ? 
		cw->baseComp.bd_color : cw->core.background_pixel);

	return res;
}

static void DrawFocusFrame(w , pixel)
Widget w;
Pixel pixel;
{
	ScrollWinWidget cw = (ScrollWinWidget) w;
	Dimension width,height;
	Position x,y;


	XtVaGetValues(cw->scrollWin.clipw , XtNx , &x , XtNy , &y ,
		XtNwidth , &width , XtNheight , &height , NULL);

	X_DrawSimpleRawFrame(XtDisplay(w) , XtWindow(w) ,
		x - cw->baseComp.box_width - cw->baseComp.bd_width ,
		y - cw->baseComp.box_width - cw->baseComp.bd_width , 
		width + 2 * cw->baseComp.box_width + 2 * cw->baseComp.bd_width ,
		height + 2 * cw->baseComp.box_width + 2 * cw->baseComp.bd_width , 
		1 , pixel);
}
