/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <unistd.h>
#include <time.h>
#include <string.h>

#ifdef HAVE_SYS_MODE_H
#include <sys/mode.h>
#endif
 
#include "doc.h"
#include "config.h"
#include "file.h"
#include "http.h"
#include "ftp.h"
#include "gopher.h"
#include "url.h"
#include "mode.h"
#include "nscache.h"
#include "errcode.h"

/********************************************************/
/* parameter  -  URL dokumentu				*/
/* vracia deskriptor soketu alebo suboru pre dokument	*/
/* osetrenie vyskytu v lokalnom strome			*/
/********************************************************/
bufio *abs_get_data_socket(docp , pos , modtime)
doc *docp;
int pos;
time_t modtime;
{
	char *fn;
	bufio *sock;
	struct stat estat;
	url *urlr = docp->doc_url;

	docp->errcode = ERR_NOERROR;

	urlr->status &= ~URL_REDIRECT;

	if (cfg.mode != MODE_SYNC)
	{
		fn = url_to_filename(urlr, TRUE);

		if (!access(fn , R_OK) && urlr->type != URLT_FILE)
		{
			urlr->status |= URL_REDIRECT;
			if (stat(fn , &estat) == 0)
			{
        			if (!S_ISDIR(estat.st_mode))
				{
			        	if (!(sock = bufio_open(fn , O_BINARY | O_RDONLY)))
		        		{
		                		xperror(fn);
						docp->errcode = ERR_FILE_OPEN;
					}
					xprintf(1 , gettext("File redirect\n"));

					docp->totsz = estat.st_size;
					return sock;
				}
			}
		}
#ifdef HAVE_DBOPEN
		else if (cfg.ns_cache_dir && urlr->type != URLT_FILE)
		{
			char *cfn;
			char *urlstr = url_to_urlstr(urlr , FALSE);

			cfn = ns_cache_find_localname(urlstr);
			_free(urlstr);

			if (cfn)
			{
				char pom[PATH_MAX];

				sprintf(pom , "%s/%s" , cfg.ns_cache_dir , cfn);

				sock = bufio_open(pom , O_RDONLY);

				if (sock)
				{
					if (file_is_html(pom))
						urlr->status |= URL_ISHTML;
					urlr->status |= URL_INNSCACHE;
					xprintf(1 , gettext("Loading copy from local NS cache - %s\n") , cfn);
					if (stat(fn , &estat) == 0)
						docp->totsz = estat.st_size;
					_free(cfn);
					return sock;
				}
				_free(cfn);
			}
		}
#endif
	}

	if (urlr->type == URLT_HTTP 
#ifdef USE_SSL
		|| urlr->type == URLT_HTTPS
#endif
		|| (urlr->type == URLT_FTP && cfg.ftp_proxy && cfg.ftp_via_http && !cfg.ftp_dirtyp)
		|| (urlr->type == URLT_GOPHER && cfg.gopher_proxy && cfg.gopher_via_http))
	{
		if (cfg.sleep) 
		{
			my_sleep(cfg.sleep);
		}
		urlr->status &= ~URL_REDIRECT;
		return http_get_data_socket(docp , pos , modtime , FALSE);
	}
	else if (urlr->type == URLT_FTP
#ifdef USE_SSL
		|| urlr->type == URLT_FTPS
#endif
		)
	{
		if (cfg.sleep) 
		{
			my_sleep(cfg.sleep);
		}
		urlr->status &= ~URL_REDIRECT;
		return ftp_get_data_socket(docp , pos , modtime);
	}
	if (urlr->type == URLT_GOPHER)
	{
		if (cfg.sleep) 
		{
			my_sleep(cfg.sleep);
		}
		urlr->status &= ~URL_REDIRECT;
		return gopher_get_data_socket(docp);
	}
	if (urlr->type == URLT_FILE)
	{
		urlr->status &= ~URL_REDIRECT;
		return get_file_data_socket(docp);
	}
	xprintf(1 , gettext("Unsupported URL\n"));
	return NULL;
}

static int should_leave_persistent(docp)
doc *docp;
{
	return (docp->is_persistent &&
		!(docp->doc_url->status & URL_REDIRECT) &&
		docp->errcode != ERR_READ &&
		docp->errcode != ERR_BIGGER &&
		docp->errcode != ERR_NOMIMET &&
		docp->errcode != ERR_BREAK &&
		docp->errcode != ERR_OUTTIME &&
		docp->errcode != ERR_SMALLER &&
		docp->errcode != ERR_LOW_TRANSFER_RATE &&
		docp->errcode != ERR_QUOTA_FILE &&
		docp->errcode != ERR_QUOTA_TRANS &&
		docp->errcode != ERR_QUOTA_FS &&
		docp->errcode != ERR_HTTP_UNKNOWN &&
		docp->errcode != ERR_HTTP_TRUNC &&
		docp->errcode != ERR_HTTP_SNDREQ &&
		docp->errcode != ERR_HTTP_NOREGET &&
		docp->errcode != ERR_HTTP_ACTUAL);
}

/********************************************************/
/* parameter URL dokumentu				*/
/* uzatvori deskirptor pre dany dokument		*/
/********************************************************/
void abs_close_socket(docp, read_status)
doc *docp;
int read_status;
{
	url *urlr = docp->doc_url;

	if (!docp->datasock)
		return;

	switch (urlr->type)
	{
		case URLT_FILE:
			bufio_close(docp->datasock);
			docp->datasock = NULL;
			break;
		case URLT_HTTP:
			if (should_leave_persistent(docp))
			{
				DEBUG_NET("Leaving opened persistent HTTP connection\n");
				break;
			}
			else
			{
				if (!(urlr->status & URL_REDIRECT))
					shutdown(bufio_getfd(docp->datasock) , 2);
				bufio_close(docp->datasock);
				docp->datasock = NULL;
			}
			break;
#ifdef USE_SSL
		case URLT_HTTPS:
			if (should_leave_persistent(docp))
			{
				DEBUG_NET("Leaving opened persistent HTTP connection\n");
				break;
			}
			else
			{
				if (!(urlr->status & URL_REDIRECT))
				{
					SSL_set_shutdown(docp->ssl_con, SSL_SENT_SHUTDOWN | SSL_RECEIVED_SHUTDOWN);
					shutdown(bufio_getfd(docp->datasock) , 2);
					if (!cfg.unique_sslid)
					{
						SSL_free(docp->ssl_con);
						SSL_CTX_free(docp->ssl_ctx);
						docp->ssl_con = NULL;
						docp->ssl_ctx = NULL;
					}
				}
				bufio_close(docp->datasock);
				docp->datasock = NULL;
			}
			break;
#endif
		case URLT_GOPHER:
			if (cfg.gopher_proxy && cfg.gopher_via_http &&
				should_leave_persistent(docp))
			{
				DEBUG_NET("Leaving opened persistent HTTP connection\n");
				break;
			}
			else
			{
				if (!(urlr->status & URL_REDIRECT))
					shutdown(bufio_getfd(docp->datasock) , 2);
				bufio_close(docp->datasock);
				docp->datasock = NULL;
			}
			break;
		case URLT_FTP:
			if (cfg.ftp_proxy && cfg.ftp_via_http &&
				!cfg.ftp_dirtyp &&
				should_leave_persistent(docp))
			{
				DEBUG_NET("Leaving opened persistent HTTP connection\n");
				break;
			}
			else
			{
				if (!(urlr->status & URL_REDIRECT))
					shutdown(bufio_getfd(docp->datasock) , 2);
				bufio_close(docp->datasock);
				docp->datasock = NULL;
			}

			if (urlr->status & URL_REDIRECT)
				return;

			if (docp->ftp_control && read_status)
			{
			   if (ftp_get_response(docp, NULL, FALSE) >= 400)
			   {
				xprintf(1 , gettext("Warning: broken ftp transfer ...\n"));
				docp->errcode = ERR_FTP_TRUNC;
				docp->ftp_fatal_err = TRUE;
			    }
			}

			if (docp->ftp_control && docp->ftp_fatal_err)
			{
				shutdown(bufio_getfd(docp->ftp_control) , 2);
				bufio_close(docp->ftp_control);
				docp->ftp_control = NULL;
			}
			break;
#ifdef USE_SSL
		case URLT_FTPS:
			if (!(urlr->status & URL_REDIRECT))
			{
				SSL_set_shutdown(docp->ssl_con, SSL_SENT_SHUTDOWN | SSL_RECEIVED_SHUTDOWN);
				shutdown(bufio_getfd(docp->datasock) , 2);
				SSL_free(docp->ssl_con);
				SSL_CTX_free(docp->ssl_ctx);
				docp->ssl_con = NULL;
				docp->ssl_ctx = NULL;

				if (docp->ftp_control && read_status)
				{
				   if (ftp_get_response(docp, NULL, FALSE) >= 400)
				   {
					xprintf(1 , gettext("Warning: broken ftp transfer ...\n"));
					docp->errcode = ERR_FTP_TRUNC;
				    }
				}

				if (docp->ftp_control && docp->ftp_fatal_err)
				{
					SSL_set_shutdown(docp->ftp_control_ssl_con, SSL_SENT_SHUTDOWN | SSL_RECEIVED_SHUTDOWN);
					SSL_free(docp->ftp_control_ssl_con);
					SSL_CTX_free(docp->ftp_control_ssl_ctx);
					docp->ftp_control_ssl_con = NULL;
					docp->ftp_control_ssl_ctx = NULL;

					shutdown(bufio_getfd(docp->ftp_control) , 2);
					bufio_close(docp->ftp_control);
					docp->ftp_control = NULL;
				}
			}
			bufio_close(docp->datasock);
			docp->datasock = NULL;
			break;
#endif
		default:
			bufio_close(docp->datasock);
			docp->datasock = NULL;
	}
}

int abs_read(docp, sock, buf, bufsize)
doc *docp;
bufio *sock;
char *buf;
int bufsize;
{
	int rv;

#ifdef USE_SSL
	if (!(docp->doc_url->status & URL_REDIRECT) &&
		(docp->doc_url->type == URLT_HTTPS || 
		 docp->doc_url->type == URLT_FTPS))
	{
		rv = bufio_sslnbfread(sock, buf, bufsize, docp->ssl_con);
	}
	else
#endif
		rv = bufio_nbfread(sock, buf, bufsize);

	return rv;
}

int abs_readln(docp, sock, buf, bufsize)
doc *docp;
bufio *sock;
char *buf;
int bufsize;
{
	int rv;

#ifdef USE_SSL
	if (!(docp->doc_url->status & URL_REDIRECT) &&
		(docp->doc_url->type == URLT_HTTPS || 
		 docp->doc_url->type == URLT_FTPS))
	{
		rv = bufio_sslreadln(sock, buf, bufsize, docp->ssl_con);
	}
	else
#endif
		rv = bufio_readln(sock, buf, bufsize);

	return rv;
}

int abs_write(docp, sock, buf, bufsize)
doc *docp;
bufio *sock;
char *buf;
int bufsize;
{
	int rv;

#ifdef USE_SSL
	if (!(docp->doc_url->status & URL_REDIRECT) &&
		(docp->doc_url->type == URLT_HTTPS || 
		 docp->doc_url->type == URLT_FTPS))
	{
		rv = bufio_sslwrite(sock, buf, bufsize, docp->ssl_con);
	}
	else
#endif
		rv = bufio_write(sock, buf, bufsize);

	return rv;
}

int abs_read_data(docp, sock, buf, bufsize)
doc *docp;
bufio *sock;
char *buf;
int bufsize;
{
	int rv;

	if (docp->is_chunked)
	{
		rv = 0;
		if (docp->read_chunksize)
		{
			char pombuf[2048];
			char *endp;

			rv = abs_readln(docp, sock, pombuf, sizeof(pombuf) - 1);
			if (rv <= 0)
			{
				xprintf(1 , gettext("Error reading document with \"chunked\" transfer encoding !!!\n"));
				rv = -1;
			}
			else
			{
				docp->chunk_size = strtol(pombuf , &endp , 16);
				docp->read_chunksize = FALSE;
				if (docp->chunk_size == 0)
					docp->read_trailer = TRUE;
				rv = 0;
			}
		}
		if (!rv && docp->read_trailer)
		{
			char pombuf[2048];
			while ((rv = abs_readln(docp, sock, pombuf, sizeof(pombuf) - 1)) >= 0)
			{
				if (!rv)
				{
					rv = -1;
					break;
				}
				if (strcspn(pombuf , "\r\n") == 0)
				{
					rv = 0;
					break;
				}
			}
		}
		if (!rv && docp->chunk_size > 0)
		{
			int rs;
			rs = (bufsize < docp->chunk_size) ? bufsize : docp->chunk_size;
#ifdef USE_SSL
			if (docp->doc_url->type == URLT_HTTPS)
				rv = bufio_sslnbfread(sock, buf, rs, docp->ssl_con);
			else
#endif
				rv = bufio_nbfread(sock, buf , rs);

			if (rv > 0) docp->chunk_size -= rv;

			if (docp->chunk_size == 0)
			{
				char pombuf[2048];

				abs_readln(docp, sock, pombuf, sizeof(pombuf) - 1);
				docp->read_chunksize = TRUE;
			}
		}
	}
	else if (docp->is_http11 && !(docp->doc_url->status & URL_REDIRECT) &&
		 docp->totsz >= 0)
	{
		int rs;

		rs = ((docp->totsz - docp->size) > bufsize) ? bufsize : docp->totsz - docp->size;

		if (rs)
		{
#ifdef USE_SSL
			if (docp->doc_url->type == URLT_HTTPS)
				rv = bufio_sslnbfread(sock, buf, rs, docp->ssl_con);
			else
#endif
				rv = bufio_nbfread(sock, buf , rs);
		}
		else
			rv = 0;
	}
	else
	{
#ifdef USE_SSL
		if (!(docp->doc_url->status & URL_REDIRECT) &&
			(docp->doc_url->type == URLT_HTTPS || 
			 docp->doc_url->type == URLT_FTPS))
		{
			rv = bufio_sslnbfread(sock, buf, bufsize, docp->ssl_con);
		}
		else
#endif
			rv = bufio_nbfread(sock, buf, bufsize);
	}

	return rv;
}
