/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <unistd.h>
#include <time.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <time.h>

#include "config.h"
#include "url.h"
#include "doc.h"
#include "tools.h"
#include "log.h"
#include "errcode.h"

static char *errcodetype(ecode)
{
	switch (ecode)
	{
		case ERR_NOERROR:
			return "OK";
		case ERR_STORE_DOC:
		case ERR_FILE_OPEN:
		case ERR_DIR_URL:
		case ERR_UNKNOWN:
		case ERR_PROXY_CONNECT:
		case ERR_FTP_UNKNOWN:
		case ERR_FTP_BUSER:
		case ERR_FTP_BPASS:
		case ERR_HTTP_UNKNOWN:
		case ERR_HTTP_AUTH:
		case ERR_HTTP_PAY:
		case ERR_HTTP_BADRQ:
		case ERR_HTTP_FORB:
		case ERR_HTTP_SERV:
		case ERR_GOPHER_UNKNOWN:
			return "FATAL";
		case ERR_LOCKED:
		case ERR_BIGGER:
		case ERR_NOMIMET:
		case ERR_BREAK:
		case ERR_OUTTIME:
		case ERR_SCRIPT_DISABLED:
		case ERR_SMALLER:
		case ERR_ZERO_SIZE:
		case ERR_PROCESSED:
		case ERR_UDISABLED:
		case ERR_RDISABLED:
		case ERR_FTP_NOREGET:
		case ERR_FTP_ACTUAL:
		case ERR_FTP_NOTRANSFER:
		case ERR_FTP_NOMDTM:
		case ERR_FTP_DIRNO:
		case ERR_HTTP_NOREGET:
		case ERR_HTTP_REDIR:
		case ERR_HTTP_ACTUAL:
			return "WARN";
		case ERR_READ:
		case ERR_FTP_BDIR:
		case ERR_FTP_CONNECT:
		case ERR_FTP_DATACON:
		case ERR_FTP_GET:
		case ERR_FTP_NODIR:
		case ERR_FTP_TRUNC:
		case ERR_HTTP_CONNECT:
		case ERR_HTTP_SNDREQ:
		case ERR_HTTP_TRUNC:
		case ERR_HTTP_CYCLIC:
		case ERR_HTTP_NFOUND:
		case ERR_GOPHER_CONNECT:
		case ERR_HTTPS_CONNECT:
			return "ERR";
		default:
			return "UNKNOWN";
	}
}

void short_log(docp , urlp)
doc *docp;
url *urlp;
{
	int fd;
	char pom[1024];
	char *p,*p1;
	time_t t = time(NULL);;

	if (!cfg.short_logfile)
		return;
	LOCK_SLOG
	fd = open(cfg.short_logfile , O_BINARY | O_CREAT | O_APPEND | O_WRONLY , S_IRUSR | S_IWUSR);

	if (fd < 0)
	{
		xperror("shortlog");
		UNLOCK_SLOG
		return;
	}

	if (_flock(fd , cfg.short_logfile , O_BINARY | O_CREAT | O_APPEND | O_WRONLY, TRUE))
	{
		close(fd);
		UNLOCK_SLOG
		return;
	}

	p1 = ctime(&t);
	p = strchr(p1 , '\n');
	if (p) *p = '\0';

	sprintf(pom , "%d %s %d/%d %s %d " , getpid() , p1 ,
		docp->doc_nr, cfg.total_cnt ,
		errcodetype(docp->errcode) , docp->errcode);
	write(fd , pom , strlen(pom));

	p = url_to_urlstr(urlp , FALSE);
	write(fd , p , strlen(p));
	_free(p);

	if (urlp->parent_url && urlp->parent_url[0])
	{
		write(fd , " " , 1);
		p = url_to_urlstr(urlp->parent_url[0] , FALSE);
		write(fd , p , strlen(p));
		_free(p);
	}
	else
	{
		write(fd , " [none]" , 7);
	}

	p = url_to_filename(urlp , FALSE);

	write(fd , " " , 1);
	write(fd , p , strlen(p));

	sprintf(pom , " %ld" , docp->size);
	write(fd , pom , strlen(pom));

	t = doc_etime(docp, FALSE);
	sprintf(pom , " %ld.%03ld" , t / 1000 , t%1000);
	write(fd , pom , strlen(pom));

	if (docp->mime)
	{
		int l = strcspn(docp->mime , "\r\n");
		write(fd , " " , 1);
		write(fd , docp->mime , l);
	}

	write(fd , "\n" , 1);

	_funlock(fd);
	close(fd);
	UNLOCK_SLOG
}

static int log_fd = -1;

int log_start(filename)
char *filename;
{
	static char *log_filename = NULL;
	bool start_log = FALSE;
	bool stop_log = FALSE;

	LOCK_LOG
	if (!filename)
		stop_log = TRUE;
	else
	{
		if (log_filename)
		{
			if (strcmp(log_filename , filename))
			{
				start_log = TRUE;
				stop_log = TRUE;
			}
		}
		else
			start_log = TRUE;
	}

	if (stop_log)
	{
		if (log_fd >= 0)
		{
			char pom[1024];
			time_t t = time(NULL);
			LOCK_TIME
			strftime(pom , sizeof(pom) ,
				gettext("Ending log : %H:%M:%S %d.%m.%Y\n") , localtime(&t));
			UNLOCK_TIME
			log_str(pom);
			_funlock(log_fd);
			close(log_fd);
		}
	}
	if (start_log)
	{
		int nr = 0;
		char nfn[PATH_MAX];

		strcpy(nfn , filename);

		while (TRUE)
		{
			log_fd = open(nfn , O_BINARY | O_CREAT | O_APPEND | O_WRONLY , 0644);

			if (log_fd < 0)
			{
				xperror(nfn);
				xprintf(0, gettext("Unable to open log file - disabling logging\n"));
				break;
			}

			if (_flock(log_fd, nfn , O_BINARY | O_CREAT | O_APPEND | O_WRONLY , FALSE))
			{
				close(log_fd);
				log_fd = -1;
				xprintf(0, gettext("Log file is locked by another process - "));
				if (cfg.gen_logname)
				{
					sprintf(nfn , "%s.%04d" , filename , nr);
					xprintf(0, gettext("generating new log filename\n"));
					nr++;
				}
				else
				{
					xprintf(0, gettext("disabling logging\n"));
					break;
				}
			}
			else
			{
				break;
			}
		}
		if (nr > 0)
		{
			filename = nfn;
			_free(cfg.logfile);
			cfg.logfile = new_string(nfn);
		}

		if (log_fd >= 0)
		{
			char pom[1024];
			time_t t = time(NULL);
			LOCK_TIME
			strftime(pom , sizeof(pom) ,
				gettext("Starting log : %H:%M:%S %d.%m.%Y\n") , localtime(&t));
			UNLOCK_TIME
			write(log_fd , pom , strlen(pom));
		}

	}
	_free(log_filename);
	log_filename = new_string(filename);
	UNLOCK_LOG
	return 0;
}

void log_str(str)
char *str;
{
	LOCK_LOG
	if (log_fd >= 0)
		write(log_fd , str , strlen(str));
	UNLOCK_LOG
}

