/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/time.h>

#include "config.h"
#include "dns.h"

#ifdef X_FACE
static void TOut(client_data , timer)
XtPointer client_data;
XtIntervalId *timer;
{
	*(XtIntervalId *)client_data = 0;
	errno = ETIMEDOUT;

	_X_EscLoop();
}

static void ConnectCB(ptr , src , id)
XtPointer ptr;
int *src;
XtInputId *id;
{
	XtRemoveInput(*id);
	*(XtInputId *)ptr = 0;
	DEBUG_NET("Async connect - connected\n");
	_X_EscLoop();
}
#endif


#ifdef GTK_FACE
static gint TOut(data)
gpointer data;
{
	*(int *)data = 0;
	errno = ETIMEDOUT;
	_X_EscLoop();

	return FALSE;
}

static void ConnectCB(data , source , condition)
gpointer data;
gint source;
GdkInputCondition condition;
{
	gdk_input_remove(*(int *)data );
	*(int *)data = 0;
	DEBUG_NET("Async connect - connected\n");
	_X_EscLoop();
}
#endif

int net_host_to_in_addr(hostname, haddr)
char *hostname;
struct in_addr *haddr;
{
	int len;

	if ((haddr->s_addr = inet_addr(hostname)) == -1)
	{
		if (dns_gethostbyname(hostname , &len  , (char *)haddr))
		{
			return -1;
		}
	}
	return 0;
}

/*****************************************************************/
/* otvori spojenie na dany port servera  s (IP , DNS) adresou	 */
/*****************************************************************/
int net_connect(hostname , port_no)
char *hostname;
int port_no;
{
	struct sockaddr_in addr;
	int sock;
	int rv,l;
	bool timeout = FALSE;

	h_errno = 0;

	memset(&addr , '\0' ,  sizeof(addr));
	if ((addr.sin_addr.s_addr = inet_addr(hostname)) == -1)
	{
		if (dns_gethostbyname(hostname , &rv  , (char *)&(addr.sin_addr)))
		{
			return -1;
		}
	}
	_Xt_Serve

	addr.sin_family = AF_INET;
	addr.sin_port = htons(port_no);

	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) == -1)
	{
		return -1;
	}

	if (fcntl(sock , F_SETFL , O_NONBLOCK))
	{
		xperror("fcntl() - F_SETFL");
		close(sock);
		return -1;
	}

	if (cfg.local_ip)
	{
		struct sockaddr_in localaddr;

		memset(&localaddr , '\0' ,  sizeof(localaddr));

		localaddr.sin_addr.s_addr = cfg.local_ip_addr.s_addr;
		localaddr.sin_family = AF_INET;
		localaddr.sin_port = htons(0);

		if (bind(sock, (struct sockaddr *)&localaddr, sizeof(localaddr)) == -1)
		{
			close(sock);
			return -1;
		}
	}

	rv = connect(sock, (struct sockaddr*)&addr, sizeof(addr));
	if (rv && 
		(errno != EINPROGRESS) &&
		(errno != EISCONN) &&
		(errno != EAGAIN) &&
		(errno != EWOULDBLOCK))
	{
		close(sock);
		return -1;
	}


#ifdef I_FACE
	if (cfg.xi_face)
	{
#ifdef X_FACE
		XtInputId iid;
		XtIntervalId inid;
#endif
#ifdef GTK_FACE
		gint iid;
		gint inid;
#endif
		if (rv && (errno == EINPROGRESS))
		{
			if (cfg.ctimeout && (cfg.ctimeout > (ULONG_MAX / 60000)))
			{
				xprintf(0 , gettext("Too high timeout value for GUI interface implementation of connect\n"));
			}

#ifdef X_FACE
			inid = cfg.ctimeout ? XtAppAddTimeOut(cfg.X.app_context , 
					cfg.ctimeout * 60000, TOut , &inid) : 0;
#endif

#ifdef GTK_FACE
			inid = cfg.ctimeout ? gtk_timeout_add(cfg.ctimeout * 60000 ,
					(GtkFunction)TOut , &inid) : 0;
#endif
#ifdef X_FACE
			iid = XtAppAddInput(cfg.X.app_context ,
				sock , (XtPointer) (XtInputExceptMask | 
				XtInputWriteMask) , 
				ConnectCB , &iid);
#endif

#ifdef GTK_FACE
			iid = gdk_input_add(sock , 
				GDK_INPUT_WRITE | GDK_INPUT_EXCEPTION, 
				(GdkInputFunction) ConnectCB , (gpointer) &iid);
#endif


			_Xt_ServeLoop

#ifdef X_FACE
			if (inid)
			{
				XtRemoveTimeOut(inid);
				inid = 0;
			}
#endif   

#ifdef GTK_FACE
			if (inid)
			{
				gtk_timeout_remove(inid);
				inid = 0;
			}
#endif
			else if (cfg.ctimeout)
			{
				timeout = TRUE;
			}

			if (cfg.rbreak || cfg.stop || timeout)
			{
#ifdef X_FACE
				if (iid) 
#endif
#ifdef GTK_FACE
				if (iid) 
#endif
				{
#ifdef X_FACE
					XtRemoveInput(iid);
#endif

#ifdef GTK_FACE
					gdk_input_remove(iid);
#endif
					iid = 0;
					close(sock);
					return -1;
				}
			}
			
		}
	}
	else
#endif
	{
		if (rv && 
			(errno == EINPROGRESS ||
			 errno == EAGAIN ||
			 errno == EWOULDBLOCK))
		{
			while ((rv = _selectw(sock , 60 * cfg.ctimeout)) == -1 
				&& errno == EINTR);
			if (rv <= 0)
			{
				if (rv == 0) errno = ETIMEDOUT;
				return -1;
			}
		}
	}
#if 0
	if ((connect(sock, (struct sockaddr*)&addr, sizeof(addr)) == -1) &&
	     (errno && (errno != EISCONN)))
	{
		close(sock);
		return -1;
	}
#else
	l = sizeof(rv);
	if (getsockopt(sock, SOL_SOCKET, SO_ERROR, (void *)&rv , &l))
	{
		close(sock);
		errno = rv;
		return -1;
	}
	else
	{
		if (rv)
		{
			close(sock);
			errno = rv;
			return -1;
		}
	}
#endif

	DEBUG_NET("Successfully connected to %s,%d\n", hostname , port_no);

	return(sock);
}

int net_bindport(port)
int port;
{
	int sock;
	int n;
	struct sockaddr_in addr;
	char pom[512];

	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) == -1)
	{
		perror("socket");
		return -1;
	}

	addr.sin_addr.s_addr = cfg.local_ip_addr.s_addr;
	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);

	n = 1;
	if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, (char *)&n, sizeof(n)))
		xperror("net_bind: setsockopt - SO_REUSEADDR");

	if (bind(sock, (struct sockaddr*) &addr, sizeof(addr)) == -1)
	{
		sprintf(pom , "bind to port(%d)" , port);
		xperror(pom);
		close(sock);
		return -1;
	}

	n = sizeof(addr);
	if (getsockname(sock , (struct sockaddr*) &addr, &n))
	{
		xperror("getsockname");
		close(sock);
		return -1;
	}

	DEBUG_NET("BINDING to port : %d\n" , ntohs(addr.sin_port));

	if (listen(sock,1) == -1)
	{
		xperror("listen");
		close(sock);
		return -1;
	}

	return sock;
}

int net_accept(sock)
int sock;
{
	struct sockaddr_in caller;
	int p,rsock = -1;
	int rv;

	p = sizeof(caller);

	if (fcntl(sock , F_SETFL , O_NONBLOCK))
	{
		xperror("fcntl() - F_SETFL");
		close(sock);
		return -1;
	}

	rsock = accept(sock, (struct sockaddr*)&caller, &p);
	if ((rsock < 0) && (errno != EWOULDBLOCK) && (errno != EAGAIN))
	{
		close(sock);
		return -1;
	}

#ifdef I_FACE
	if (cfg.xi_face)
	{
#ifdef X_FACE
		XtInputId iid;
		XtIntervalId inid;
#endif
#ifdef GTK_FACE
		gint iid;
		gint inid;
#endif

		if ((rsock < 0) && 
			(errno == EWOULDBLOCK ||
			 errno == EAGAIN))
		{
#ifdef X_FACE
			inid = cfg.ctimeout ? XtAppAddTimeOut(cfg.X.app_context , 
					cfg.ctimeout * 60000, TOut , &inid) : 0;
#endif

#ifdef GTK_FACE
			inid = cfg.ctimeout ? gtk_timeout_add(cfg.ctimeout * 60000 ,
					(GtkFunction)TOut , &inid) : 0;
#endif
#ifdef X_FACE
			iid = XtAppAddInput(cfg.X.app_context ,
				sock , (XtPointer) (XtInputExceptMask | 
				XtInputReadMask) , 
				ConnectCB , (XtPointer) &iid);
#endif

#ifdef GTK_FACE
			iid = gdk_input_add(sock , 
				GDK_INPUT_READ | GDK_INPUT_EXCEPTION, 
				(GdkInputFunction) ConnectCB , (gpointer) &iid);
#endif

			_Xt_ServeLoop

#ifdef X_FACE
			if (inid)
			{
				XtRemoveTimeOut(inid);
				inid = 0;
			}
#endif 

#ifdef GTK_FACE
			if (inid)
			{
				gtk_timeout_remove(inid);
				inid = 0;
			}
#endif
			if (cfg.rbreak || cfg.stop)
			{
				if (iid) 
				{

#ifdef X_FACE
					XtRemoveInput(iid);
#endif
#ifdef GTK_FACE
					gdk_input_remove(iid);
#endif
					iid = 0;
					return -1;
				}
			}
		}
	}
	else
#endif
	{
		if ((rsock < 0) && (errno == EWOULDBLOCK || errno == EAGAIN))
		{
			while ((rv = _selectr(sock , 60 * cfg.ctimeout)) == -1 
				&& errno == EINTR);
			if (rv <= 0)
			{
				if (rv == 0) errno = ETIMEDOUT;
				close(sock);
				return -1;
			}
		}
	}

	if ((rsock < 0) && ((rsock = accept(sock, (struct sockaddr*)&caller, &p)) == -1))
	{
		close(sock);
		return -1;
	}

	DEBUG_NET("ACCEPTING connection from: %s\n", inet_ntoa(caller.sin_addr));

	return rsock;
}

