/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * main.cc
 *   Test program for the DdtDB and all inherited classes.
 *
 * $Id: rmacct.cc,v 1.8 2001/11/24 21:11:50 benoit Exp $
 *
 * Copyright (c) 1999 Remi Lefebvre <remi@dhis.net>
 *                and Benoit Joly <benoit@dhis.net>
 *                and Luca Filipozzi <lfilipoz@dhis.net>
 *
 * Licensed under the GPLv2
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <opt.h>

#include "Logger.h"
#include "DbPsql.h"
#include "Packet.h"

int accountId;
int main (int argc, char **argv)
{
    optrega(&accountId, OPT_INT, 'a', "accountId", "");
    optDefaultFile("main.opt");

    opt(&argc, &argv);

    Logger* log = Logger::Instance();
    log->setIdent(argv[0]);
    log->openSyslog(LOG_USER, LOG_DEBUG); 

    // login information for the database
    // will come from a config file or the command line
    const char dbname[] = "ddtdb";
    const char dbuser[] = "remi";
    const char dbpass[] = "pjqA53";

    // open the database
    Db* ddtdb = new DbPsql(log, dbname, dbuser, dbpass);

    ddtdb->delUserAccount(accountId);

    return 0;
}
