/***************************************************************************
                          gutenbrowser.h  -  description
                             -------------------
    begin                : Mon Jul 24 22:33:12 MDT 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GUTENBROWSER_H
#define GUTENBROWSER_H

// include files for QT

#include "LibraryDialog.h"
#include "multiline_ex.h"
#include "NetworkDialog.h"
//#include "styles.h"
//#include <qmultilineedit.h>
#include <qurloperator.h>
#include <qtooltip.h>


#include <qstring.h>
#include <qsplitter.h>
#include <qlistview.h>
#include <qtextview.h>
#include <qstatusbar.h>
#include "CConfigFile.h"

#include <qlayout.h>
#include <qpopupmenu.h>
#include <qmainwindow.h>
#include <qaccel.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qapp.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qpushbutton.h>
#include <qmultilineedit.h> 
#include <qfontmetrics.h> 
#include <qfontinfo.h>
// application specific includes
#include "gutenbrowserview.h"
#include "gutenbrowserdoc.h"
#include "resource.h"

class Gutenbrowser : public QMainWindow
{
    Q_OBJECT
  
public:
    Gutenbrowser();
    ~Gutenbrowser();
    void initMenuBar();
    void initButtonBar();
    void initStatusBar();
    void initDoc();
    void initView();
    void initConfig();
    void initSlots();
    void toggleButtonIcons( bool usingIcons);
    bool useIcons;
    bool queryExit();
    bool b_queryExit;
    bool UnZipIt(QString zipFile);
    QBoxLayout *topLayout;
    QBoxLayout *menu;
    QBoxLayout *buttons;
    QBoxLayout *buttons2;
    QBoxLayout *edits;
    QMenuBar* menubar;  
    QStatusBar* statusBar;
    
    QPushButton* DownloadButton;
    QPushButton* LibraryButton;
    QPushButton* OpenButton;
    QPushButton* ForwardButton;
    QPushButton* BackButton;
    QPushButton* PrintButton;
    QPushButton* SearchButton;
    QPushButton* dictionaryButton;    
    QPushButton* beginButton;   
    
    QPushButton* ExitButton;            
    QPushButton* OptionsButton;
    QPushButton* FontButton;
    QPushButton* ClearButton;   
    QPushButton* lastBmkButton;
    QPushButton* setBookmarkButton;   
    QPushButton* HelpButton;
    QFile newindexLib, indexLib;
    QLabel* StatusBar;
    QButton* InfoBar;
//    QLabel* InfoBar;

    CConfigFile *config;
    QPrinter *printer;
    SearchDialog* searchDlg;

    QString local_library;
    QString local_index;
    QString iniFile;
    QString prefBrowser;
    QString brow;
    QString file_name;
    QString ftp_base_dir;
    QString ftp_host;
    QString listItemFile;
    QString listItemNumber;
    QString listItemTitle;
    QString listItemYear;
    QString pattern;
    QString status;
    QString statusTop;
    QString title;

    int check;
    int lineCheck;
    int i_pageNum;
    int pages;    
    int direction;
    
    char host[1024];
    char login[1024];
    char password[1024];
      /**  */
    bool loadCheck;
    int lastScrollRow;

    void  Search();
    int repeatSearch();
    bool setTitle();
    bool getTitle( const char *file);
    void AdjustStatus();
    void ResizeEdits();
      /**  */
    void OnNetworkDialog( QString networkUrl, QString output);

    QString fontStr, pointSizeStr, weightStr, italicStr, boldStr;
    int pointSize, weight;
    bool italic, bold;
//    pointSizeStr.setNum( pointSize);    

    QString networkUrl;
  int styleI;
  
public slots:
//    void statusCallback(int id_);
    void slotFileNew();
    void slotFileOpen();
    void slotFileSave();
    void slotFileSaveAs();
    void slotFileClose();
    void slotFilePrint();
    void slotFileQuit();
    void slotEditCut();
    void slotEditCopy();
    void slotEditPaste();
    void slotViewToolBar();
    void slotViewStatusBar();
  
    void slotHelpAbout();
    void BeginBtn();    
    void slotStatusHelpMsg(const QString &text);
//    void showFtpList();

//    void search_slot( QString searcherStr);
    void search_slot();
    void searchdone_slot();
    bool setStatus();
//    bool checkFTP();
void setStyle(int styleInt);


    void goGetit( QString url, bool showMsg);
private:
    QSplitter *splitter;
    GutenbrowserView *view;
    GutenbrowserDoc *doc;
    QPopupMenu *fileMenu;
    QPopupMenu *editMenu;
    QPopupMenu *viewMenu;
    QPopupMenu *DownloadMenu;
    QPopupMenu *optionsMenu;
    QPopupMenu *bookmarksMenu;
    QPopupMenu *donateMenu;

    QPopupMenu *helpMenu;
  
    QToolBar *fileToolbar;
    MultiLine_Ex* Lview;
    MultiLine_Ex* Rview;
    int last_search;
private slots:

    bool load( const char *fileName );
    void resizeEvent( QResizeEvent * );

protected slots:
    void stylePlatinum();
    void styleWindows();
    void styleCDE();
    void styleMotif();
    void styleMotifPlus();
    void styleMetal();
    void styleWood();
    void styleSgi();    
    void stylePlatinumPlus();
    void styleLace();
    void styleLacePlus();
    
    void InfoBarClick();
    virtual void DownloadIndex();
    virtual void downloadFtpList();
//    virtual void setBrowser();
    virtual void PrintBtn();
    virtual void SearchBtn();
    virtual void ForwardBtn();
    virtual void BackBtn();
    virtual void LibraryBtn();
    virtual void OpenBtn();
    virtual void HelpBtn();
    virtual void ChangeFont();
    virtual bool Bookmark();
    virtual void setBookmark();
    virtual void LookupBtn();
    virtual void ClearEdit();
    virtual void ByeBye();
    virtual void doOptions();
    virtual void donateGutenberg();
    virtual void donateByteMonkie();
    virtual void annotations();
    void downloadLibIndex();
protected:
    void writeConfig();
    void moveSplitter( int pos);
    int doSearch(QString s_pattern, bool case_sensitive, bool forward, int line, int col );
    void keyPressEvent( QKeyEvent * );
    void keyReleaseEvent( QKeyEvent *e);
};
#endif 

