#ifndef __pluginh__
#define __pluginh__

#ifndef __dbmgrh__
  #include "dbmgr.h"
#endif
#ifndef __stringproch__
  #include "stringproc.h"
#endif
#include <string>
#include <map>

typedef ProcFunc CommandFunc;
typedef StringProc::actionFunction FunctionFunc;

class Plugin {
public:
  Plugin();
  virtual void Init() {};  //The initialise function
  virtual ~Plugin() {};
private:
  static map<string,Plugin*> *s_modulemap;
  string m_namespace;
  friend class PluginManager;
  void ForceNamespace(const string& ns) {m_namespace=ns; m_hasNamespace=true; };
  bool m_initialised;
  bool m_hasNamespace;
  int  m_version;
protected:
  void RegisterCommand(const string& name,CommandFunc proc);
  void RegisterFunction(const string& name,FunctionFunc proc);
  void RegisterPlugin(const string& name,int version);
  void RegisterDBDriver(const string& name, const DBManager::ConnectFn proc);
  void SetNamespace(const string& name);
};

#endif
