// Copyright (c) 2000 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef __connection_h
#define __connection_h

class Connection;

#include <qobject.h>
#include <qdatetime.h>


class MQ3d;

class QSocket;
class QSocketNotifier;
class QFile;


class Connection : public QObject
{
    Q_OBJECT
public:
    enum State { Connected, Reply, Error, Done };

    Connection(int, MQ3d *);
    ~Connection();

    State state() const { return State(st); }


private slots:
    void readyRead();
    void readyWrite();
    void otherEndClosed();
    void myEndClosed();


private:
    MQ3d *mq3d;
    QSocket *socket;
    QFile *file;
    QTimer *timer;
    State st;
    // QDateTime startTime;
    // int bytesWritten;
};



#endif // __connection_h
