// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef COLLECTIONVIEW_H
#define COLLECTIONVIEW_H

#include <qlistview.h>
#include <qiconset.h>

class Collection;

class QAction;
class QPopupMenu;


class CollectionView : public QListView
{
    Q_OBJECT

public:
    CollectionView(QWidget *, const char * = 0);

    void setupActions();
    void setupMenus();
    void setupToolbars();

    void loadIcons();
    void dataDescription(QDataStream &) const;

    QPopupMenu *mainMenu() const { return mainmenu; }

    bool isModified() const { return modified; }

    Collection *currentCollection() const { return current; }
    void setCurrentCollection(Collection *);

    static CollectionView *instance();


public slots:
    void load();
    void save();
    void newCollection();
    void renameCollection();
    void removeCollection();
    void importCollection();


private slots:
    void itemSelected(QListViewItem *);


private:
    void setModified(bool m) { modified = m; }

    Collection *current;

    QAction *actionNewColl, *actionRenameColl, *actionRemColl, *actionImportColl;
    QIconSet iconset;
    QPopupMenu *mainmenu, *collmenu;
    bool modified;

    friend class Collection;
    friend class Song;
};

#endif // COLLECTIONVIEW_H
