// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef DRAGOBJECTS_H
#define DRAGOBJECTS_H

#include <qdragobject.h>

class Collection;
class Group;
class Song;


class GroupDrag : public QStoredDrag
{
    Q_OBJECT
public:
    GroupDrag(Group *, QWidget *, const char * = 0);

    static bool canDecode(QMimeSource *);
    static bool decode(QMimeSource *, Group *);
};

class SongDrag : public QStoredDrag
{
    Q_OBJECT
public:
    SongDrag(Song *, QWidget *, const char * = 0);

    static bool canDecode(QMimeSource *);
    static bool decode(QMimeSource *, Group *);
};

class CollectionDrag : public QStoredDrag
{
    Q_OBJECT
public:
    CollectionDrag(Collection *, QWidget *, const char * = 0);

    static bool canDecode(QMimeSource *);
    static bool decode(QMimeSource *);
};

#endif // DRAGOBJECTS_H
