// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#include "eqpreset.h"

#include <qdatastream.h>


EqPreset::EqPreset()
    : def(false), pre(0)
{
    bands[0] = 0;
    bands[1] = 0;
    bands[2] = 0;
    bands[3] = 0;
    bands[4] = 0;
    bands[5] = 0;
    bands[6] = 0;
    bands[7] = 0;
    bands[8] = 0;
    bands[9] = 0;
}

EqPreset::EqPreset(const EqPreset &preset)
    : nm(preset.nm), def(preset.def), pre(preset.pre)
{
    bands[0] = preset.bands[0];
    bands[1] = preset.bands[1];
    bands[2] = preset.bands[2];
    bands[3] = preset.bands[3];
    bands[4] = preset.bands[4];
    bands[5] = preset.bands[5];
    bands[6] = preset.bands[6];
    bands[7] = preset.bands[7];
    bands[8] = preset.bands[8];
    bands[9] = preset.bands[9];
}

EqPreset::EqPreset(const QString &n)
    : nm(n), def(false), pre(0)
{
    bands[0] = 0;
    bands[1] = 0;
    bands[2] = 0;
    bands[3] = 0;
    bands[4] = 0;
    bands[5] = 0;
    bands[6] = 0;
    bands[7] = 0;
    bands[8] = 0;
    bands[9] = 0;
}

EqPreset::EqPreset(const QString &n, int b[10], int p)
    : nm(n), def(false), pre(p)
{
    bands[0] = b[0];
    bands[1] = b[1];
    bands[2] = b[2];
    bands[3] = b[3];
    bands[4] = b[4];
    bands[5] = b[5];
    bands[6] = b[6];
    bands[7] = b[7];
    bands[8] = b[8];
    bands[9] = b[9];
}

EqPreset::~EqPreset()
{
}

EqPreset &EqPreset::operator=( const EqPreset &preset )
{
    nm       = preset.nm;
    def      = preset.def;
    bands[0] = preset.bands[0];
    bands[1] = preset.bands[1];
    bands[2] = preset.bands[2];
    bands[3] = preset.bands[3];
    bands[4] = preset.bands[4];
    bands[5] = preset.bands[5];
    bands[6] = preset.bands[6];
    bands[7] = preset.bands[7];
    bands[8] = preset.bands[8];
    bands[9] = preset.bands[9];
    pre      = preset.pre;

    return *this;
}

bool EqPreset::operator==( const EqPreset &preset ) const
{
    return ( def      == preset.def &&
	     pre      == preset.pre &&
	     bands[0] == preset.bands[0] &&
	     bands[1] == preset.bands[1] &&
	     bands[2] == preset.bands[2] &&
	     bands[3] == preset.bands[3] &&
	     bands[4] == preset.bands[4] &&
	     bands[5] == preset.bands[5] &&
	     bands[6] == preset.bands[6] &&
	     bands[7] == preset.bands[7] &&
	     bands[8] == preset.bands[8] &&
	     bands[9] == preset.bands[9] &&
	     nm       == preset.nm ); // optimization - compare string last
}

bool EqPreset::operator!=( const EqPreset &preset ) const
{
    return ( def      != preset.def ||
	     pre      != preset.pre ||
	     bands[0] != preset.bands[0] ||
	     bands[1] != preset.bands[1] ||
	     bands[2] != preset.bands[2] ||
	     bands[3] != preset.bands[3] ||
	     bands[4] != preset.bands[4] ||
	     bands[5] != preset.bands[5] ||
	     bands[6] != preset.bands[6] ||
	     bands[7] != preset.bands[7] ||
	     bands[8] != preset.bands[8] ||
	     bands[9] != preset.bands[9] ||
	     nm       != preset.nm ); // optimization - compare string last
}

QDataStream &operator<<( QDataStream &stream, const EqPreset &preset )
{
    stream << preset.nm;
    int def = (preset.def == 0);
    stream << def;
    stream << preset.bands[0];
    stream << preset.bands[1];
    stream << preset.bands[2];
    stream << preset.bands[3];
    stream << preset.bands[4];
    stream << preset.bands[5];
    stream << preset.bands[6];
    stream << preset.bands[7];
    stream << preset.bands[8];
    stream << preset.bands[9];
    stream << preset.pre;
    return stream;
}

QDataStream &operator>>( QDataStream &stream, EqPreset &preset )
{
    stream >> preset.nm;
    int def;
    stream >> def;
    preset.def = (def == 0);
    stream >> preset.bands[0];
    stream >> preset.bands[1];
    stream >> preset.bands[2];
    stream >> preset.bands[3];
    stream >> preset.bands[4];
    stream >> preset.bands[5];
    stream >> preset.bands[6];
    stream >> preset.bands[7];
    stream >> preset.bands[8];
    stream >> preset.bands[9];
    stream >> preset.pre;
    return stream;
}
