/*
 * t120proto.cxx
 *
 * T.120 protocol handler
 *
 * Open Phone Abstraction Library
 *
 * Copyright (c) 1998-2000 Equivalence Pty. Ltd.
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Open H323 Library.
 *
 * The Initial Developer of the Original Code is Equivalence Pty. Ltd.
 *
 * Contributor(s): ______________________________________.
 *
 * $Log: t120proto.cxx,v $
 * Revision 1.1  2001/07/17 04:44:32  robertj
 * Partial implementation of T.120 and T.38 logical channels.
 *
 */

#ifdef __GNUC__
#pragma implementation "t120proto.h"
#endif


#include <ptlib.h>
#include "transports.h"
#include "t120proto.h"
#include "mcspdu.h"
#include "x224.h"


#define new PNEW


/////////////////////////////////////////////////////////////////////////////

OpalT120Protocol::OpalT120Protocol()
{
}


BOOL OpalT120Protocol::Originate(H323Transport & /*transport*/)
{
  return FALSE;
}


BOOL OpalT120Protocol::Answer(H323Transport & transport)
{
  PBYTEArray rawData;
  while (transport.ReadPDU(rawData)) {
    X224 pdu;
    if (pdu.Decode(rawData)) {
      PTRACE(4, "H323T120\tRead PDU:\n  " << setprecision(2) << pdu);
      if (!HandlePacket(pdu))
        return TRUE;
    }
    else {
      PTRACE(1, "H323T120\tDecode of PDU failed:\n  " << setprecision(2) << pdu);
    }
  }
  return FALSE;
}


BOOL OpalT120Protocol::HandlePacket(const X224 & pdu)
{
  switch (pdu.GetCode()) {
    case X224::DataPDU :
      break;
    case X224::ConnectRequest :
      return TRUE;
    default :
      return FALSE;
  }

  PBER_Stream ber = pdu.GetData();
  MCS_ConnectMCSPDU mcs_pdu;
  if (mcs_pdu.Decode(ber)) {
    PTRACE(4, "T120\tReceived ConnectMCSPDU:\n  " << setprecision(2) << mcs_pdu);
    return TRUE;
  }

  PTRACE(1, "T120\t\tMCS PDU invalid:\n  " << setprecision(2) << mcs_pdu);
  return FALSE;
}


BOOL OpalT120Protocol::HandleConnect(const MCS_ConnectMCSPDU & /*pdu*/)
{
  return FALSE;
}


BOOL OpalT120Protocol::HandleDomain(const MCS_DomainMCSPDU & /*pdu*/)
{
  return FALSE;
}


/////////////////////////////////////////////////////////////////////////////
