/* Seahorse
 *
 * Copyright (C) 1999, 2000 Anthony Mulcahy
 *   
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include <sys/types.h>
#include <sys/wait.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "gpg-interface.h"
#include "seahorsesig.h"
#include "seahorse.h"
#include "support.h"
#include "keymanager.h"


GtkWidget *key_tree;
GtkWidget *genkey_win;
GtkWidget *adduid;
GtkWidget *changeexpiry;
GtkWidget *changetrust;
GtkWidget *seckeyring;
GtkWidget *delkey;
GtkWidget *delsig;
GtkWidget *deluid;
GtkWidget *lsignkey;
GtkWidget *recv_key;
GtkWidget *revokekey;
GtkWidget *selected_child;
GtkWidget *send_key;
GtkWidget *signkey;
GtkWidget *recvkey_fs;
GtkWidget *sendkey_fs;
extern int ascii_arm;

/********************* Internal State Variables *********************/




/********************* Utility Routines *********************/

/*
static int
check_entry		       (GtkWidget	*widget,
				char		**text)
{
        *text = gtk_entry_get_text (GTK_ENTRY (widget));
	if (strlen (*text) == 0) {
		gtk_widget_grab_focus (widget);
		return 1;
	} else return 0;
}
*/


/*
static int
extract_free_sig	       (char		*line,
				char		**sig)
{
	char keysig[9];

	strncpy (keysig, line + 17, 8);
	keysig[8] = '\0';

	if (*sig != NULL)
		free (*sig);
        *sig = strdup (keysig);
	
	if (strlen (*sig) == 0)
		return 1;

	return 0;
}


static int
extract_free_uid	       (char		*line,
				char		**uid)
{
	char* keyuid;
	int index;

	keyuid = malloc (strlen (line + 17)+1);
	if (keyuid == NULL)
		show_error ("extract_free_uid: malloc");
	strcpy (keyuid, line + 17);
	keyuid[strlen (keyuid) - 1] = '\0';

	if (*uid != NULL)
		free (*uid);
	for (index = (strlen (keyuid) - 1); ((keyuid[index] != '(') ||
				(index == 0)); index--) {
	}

	*uid = strdup (keyuid+index+1);
	free (keyuid);
	
	if (strlen (*uid) == 0)
		return 1;

	return 0;
}


static GList*
make_key_list			()
{
	gchar	*keyid;
	gint	index;
	gint key_cnt;
	GList *glist = NULL;
	Key *key;

	MyKeyring = refresh_keyring (MyKeyring);
	key_cnt = g_list_length (MyKeyring);	
	for (index = 0; index < key_cnt; index++) {
		key = g_list_nth_data (MyKeyring, index);
		keyid = g_strdup (key->KeyID);
		glist = g_list_append (glist, keyid);
	}
	return (glist);
}
*/

GList*
make_name_list			()
{
	gint	index;
	gint key_cnt;
	GList	*glist = NULL;
	Key *key;

	MyKeyring = refresh_keyring (MyKeyring);
	key_cnt = g_list_length (MyKeyring);
	for (index = 0; index < key_cnt; index++) {
		key = g_list_nth_data (MyKeyring, index);
		if (strcmp (key->UserID, "[revoked]")) 
			glist = g_list_append (glist, key->UserID);
	}
	return (glist);
}


GList*
make_secretkey_list			()
{
	gchar	*keyid;
	gint	index;
	gint key_cnt;
	GList	*glist = NULL;
	Key *key;
	gint secret;

	MyKeyring = refresh_keyring (MyKeyring);
	key_cnt = g_list_length (MyKeyring);

	for (index = 0; index < key_cnt; index++) {
		key = g_list_nth_data (MyKeyring, index);
		secret = key->secret;
		if (secret == 1) {
			if(strcmp(key->UserID,"[revoked]")) {
				keyid = key->UserID;
				glist = g_list_append (glist, keyid);
			}
		}
	}
	return (glist);
}


/********************* Export Key *********************/

void
on_sendkey_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{

//	on_sendkey_ok_clicked (NULL, NULL);
}



void
on_sendkey_cancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy (send_key);
}


void
on_sendkey_selectkeyfile_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	sendkey_fs = create_sendkey_fs ();
	gtk_widget_show (sendkey_fs);
}

void
on_send_key_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
/*	GList		*glist;
	GtkWidget	*ascii_arm_btn;
	GtkWidget	*combo;
	GtkWidget	*key_file;
	GtkWidget	*key_id;
	GtkWidget	*radio_btn;
	GtkWidget	*useproxy_btn;

	glist = make_key_list ();
	send_key = create_send_key ();

	if (glist != NULL) {
		combo = get_widget (send_key, "sendkey_keyidcombo");
		gtk_combo_set_popdown_strings(GTK_COMBO(combo), glist);
	}

  	key_id = get_widget (send_key, "sendkey_keyid");
	if (keymanager_keyid != NULL) {
		gtk_entry_set_text (GTK_ENTRY (key_id),
				keymanager_keyid);
	}

	key_file = get_widget (send_key, "sendkey_keyfile");
	if (sendkey_keyfilename != NULL) {
		gtk_entry_set_text (GTK_ENTRY (key_file),
				sendkey_keyfilename);
	}
	
  	ascii_arm_btn = get_widget (send_key, "ascii_arm_btn");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ascii_arm_btn),
			ascii_arm);

  	useproxy_btn = get_widget (send_key, "useproxy_btn");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (useproxy_btn),
			use_proxy);

	if (sendkey_tokeyserver)
		radio_btn = get_widget (send_key,
				"sendkey_server_radiobtn");
	else radio_btn = get_widget (send_key, "sendkey_file_radiobtn");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio_btn), TRUE);


	gtk_widget_show (send_key);
*/}


/********************* Import Key *********************/

void
on_recvkey_activate                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
//	on_recvkey_ok_clicked (NULL, NULL);
}

void
on_receive_key_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
/*	GtkWidget	*key_file;
	GtkWidget	*key_id;
	GtkWidget	*radio_btn;
	GtkWidget	*useproxy_btn;

  	recv_key = create_recv_key ();

	key_file = get_widget (recv_key, "recvkey_keyfile");
	if (recvkey_keyfilename != NULL) {
		gtk_entry_set_text (GTK_ENTRY (key_file),
				recvkey_keyfilename);
	}
	
	key_id = get_widget (recv_key, "recvkey_keyid");
	if (recvkey_keyid != NULL) {
		gtk_entry_set_text (GTK_ENTRY (key_id),
				recvkey_keyid);
	}
	
	if (recvkey_fromkeyserver)
		radio_btn = get_widget (recv_key,
				"recvkey_server_radiobtn");
	else radio_btn = get_widget (recv_key, "recvkey_file_radiobtn");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio_btn), TRUE);

  	useproxy_btn = get_widget (recv_key, "useproxy_btn");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (useproxy_btn),
			use_proxy);

  	gtk_widget_show (recv_key);
*/}


/********************* Key Manager *********************/


/*void
keymanager_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	on_key_manager_activate (NULL, NULL);
}
*/


void
on_keymanagerrevoke_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
/*	GList *i; 
	GtkLabel *label; 
	GtkWidget *item; 

  	key_tree = get_widget (key_manager, "key_tree");

	i = GTK_TREE_SELECTION(key_tree); 
	if (!i)
		return;
	item = GTK_WIDGET (i->data); 
	label = GTK_LABEL (GTK_BIN (item)->child); 
	if (extract_free_key_type_id (keyring_item, &keymanager_type,
				&keymanager_keyid))
		return;

	if (!strcmp (keymanager_type, "pub") || 
			!strcmp (keymanager_type, "sec")) {
		revokekey = create_revokekey ();
		gtk_widget_show (revokekey);
	}
*/}

void
on_keymanagerexpiry_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
/* To be rewritten
	GDate *expires;
	GList *i; 
	GtkLabel *label; 
  	GtkWidget *expiry_lbl;
	GtkWidget *item; 
	GtkWidget *key_tree;


  	key_tree = get_widget (KeyManager, "ctree");

	i = GTK_TREE_SELECTION(key_tree); 
	if (!i)
		return;
	item = GTK_WIDGET (i->data); 
	label = GTK_LABEL (GTK_BIN (item)->child); 
	if (extract_free_key_type_id (keyring_item, &keymanager_type,
				&keymanager_keyid))
		return;

	changeexpiry = create_changeexpiry ();
  	expiry_lbl = get_widget (changeexpiry, "expiry_lbl");
	expires = extract_pub_id_expiry	(&my_key_ring, keymanager_keyid);
	gtk_label_set (GTK_LABEL (expiry_lbl), expires);
	gtk_widget_show (changeexpiry);

*/}


void
on_keymanageradduid_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
/*
	GList *i; 
	GtkLabel *label; 
	GtkWidget *item; 


  	key_tree = get_widget (key_manager, "key_tree");

	i = GTK_TREE_SELECTION(key_tree); 
	if (!i)
		return;
	item = GTK_WIDGET (i->data); 
	label = GTK_LABEL (GTK_BIN (item)->child); 
	if (extract_free_key_type_id (keyring_item, &keymanager_type,
				&keymanager_keyid))
		return;

	adduid = create_adduid ();
	gtk_widget_show (adduid);
*/}




/*void
on_key_manager_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  	key_manager = create_key_manager ();
  	key_tree = get_widget (key_manager, "key_tree");
	display_key_ring (key_tree);

	gtk_widget_show (key_manager);
}*/


gint
on_key_manager_close                   (GnomeDialog     *gnomedialog,
                                        gpointer         user_data)
{
	on_keys_manager_ok_clicked (NULL, NULL);
	return 0;
}

void
on_keys_manager_ok_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	selected_child = NULL;
  	gtk_widget_destroy (key_manager);
}


/********************* Generate Key Druid *********************/


gboolean
on_genkeydruid_next                    (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data)
{
	char	*keytype;
	char	*realname;
	char	*email;
	char	*comment;
	char	*passphrase;
	int result;
  	GtkWidget *keytype_txtbx;
  	GtkWidget *realname_txtbx;
  	GtkWidget *email_txtbx;
  	GtkWidget *comment_txtbx;
  	GtkWidget *passphrase_txtbx;
  	GtkWidget *log_textbox;
  	GtkWidget *druid;
  	GtkWidget *nextpage;


  	druid = get_widget (genkey_druid, "druid1");
  	nextpage = get_widget (genkey_druid, "druidpagefinish1");

  	keytype_txtbx = get_widget (genkey_druid, "keytype_txtbx");
	if (check_entry (keytype_txtbx, &keytype))
		return TRUE;

  	realname_txtbx = get_widget (genkey_druid, "realname_txtbx");
	if (check_entry (realname_txtbx, &realname))
		return TRUE;
	
  	email_txtbx = get_widget (genkey_druid, "email_txtbx");
	if (check_entry (email_txtbx, &email))
		return TRUE;
	
  	comment_txtbx = get_widget (genkey_druid, "comment_txtbx");
	if (check_entry (comment_txtbx, &comment))
		return TRUE;
	
  	passphrase_txtbx = get_widget (genkey_druid, "passphrase_txtbx");
	if (check_entry (passphrase_txtbx, &passphrase))
		return TRUE;
	
	genkey_win = create_genkey_win ();
	gtk_widget_show (genkey_win);
  	log_textbox = get_widget (genkey_win, "genkeywin_logtxtbx");

	result = gpg_gen_key (keytype, 1024, 0, realname, email,
			      comment, passphrase, log_textbox);

	result = gpg_gen_key (keytype, 1024, 0, realname, email,
			      comment, passphrase, log_textbox);

  	gtk_widget_destroy (genkey_win);

	if (result == 0) {
	}
	else ;

	gnome_druid_set_page (GNOME_DRUID (druid),
			GNOME_DRUID_PAGE (nextpage));

	return TRUE;
}


void
on_genkeydruid_activate                (GtkEditable     *editable,
                                        gpointer         user_data)
{
	on_genkeydruid_next (NULL, NULL, NULL);
}


void
on_genkeydruid_finish                  (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data)
{
	gtk_widget_show (main_win);
  	gtk_widget_destroy (genkey_druid);
}


gboolean
on_genkeydruid_cancel                  (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data)
{
	gtk_exit (0);
	return (FALSE); /* NOT REACHED */
}



/********************* *********************/

void
recvkeyfs_ok_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	char *filename;
  	GtkWidget *recvkey_keyfile;

  	recvkey_keyfile = get_widget (recv_key, "recvkey_keyfile");
	filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION (recvkey_fs));
        gtk_entry_set_text (GTK_ENTRY (recvkey_keyfile), filename);
	gtk_widget_destroy (recvkey_fs);
}


void
recvkeyfs_cancel_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy (recvkey_fs);
}


void
on_gen_key_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gen_key = create_gen_key ();
	gtk_widget_show (gen_key);
}

void
on_genkey_activate                     (GtkEditable     *editable,
                                        gpointer         user_data)
{
	on_genkey_ok_clicked (NULL, NULL);
}



void
on_genkey_cancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy (gen_key);
}


void
sendkeyfs_ok_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	char *filename;
  	GtkWidget *sendkey_keyfile;

  	sendkey_keyfile = get_widget (send_key, "sendkey_keyfile");
	filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION (sendkey_fs));
        gtk_entry_set_text (GTK_ENTRY (sendkey_keyfile), filename);
	gtk_widget_destroy (sendkey_fs);
}


void
sendkeyfs_cancel_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy (sendkey_fs);
}


/*********************************************************************/


void
on_changeexpiry_activate               (GtkEditable     *editable,
                                        gpointer         user_data)
{
	on_changeexpiry_ok_clicked (NULL, NULL);
}


void
on_changeexpiry_ok_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
/*	char	*diagnostics;
	char	*output;
	char	*expiry;
	char	*passphrase;
	int	result;
  	GtkWidget *expiry_txtbx;
  	GtkWidget *passphrase_txtbx;
  	GtkWidget *log_textbox;


  	log_textbox = get_widget (main_win, "log_textbox");

  	expiry_txtbx = get_widget (changeexpiry, "expiry_txtbx");
	if (check_entry (expiry_txtbx, &expiry))
		return;
	
  	passphrase_txtbx = get_widget (changeexpiry, "passphrase_txtbx");
	if (check_entry (passphrase_txtbx, &passphrase))
		return;
	
  	gtk_widget_hide (changeexpiry);
	result = gpg_change_expiry (keymanager_keyid, expiry, 
			passphrase, &output, &diagnostics, log_textbox); 
  	gtk_widget_destroy (changeexpiry);
	
  	key_tree = get_widget (key_manager, "key_tree");
	display_key_ring (key_tree);
*/}


void
on_changeexpiry_cancel_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
  	gtk_widget_destroy (changeexpiry);
}


