/* RIPEMD-160 Production Implementation                                       */
/* This implementation: (c) 1999 Andreas Steinmetz                            */
/* RIPEMD-160 algorithm by Hans Dobbertin, Antoon Bosselaers and Bart Preneel,*/
/* see http://www.esat.kuleuven.ac.be/~bosselae/ripemd160.html                */
/* HMAC algorithm by Krawczyk, et. al., see RFC2104                           */
/* Test cases for HMAC: see RFC2286                                           */
/*                                                                            */
/* License:                                                                   */
/* This code is under the GNU public license                                  */
/* for use with the virtual private network daemon (vpnd).                    */
/* The copyright holder will however retain the copyright.                    */
/* In addition to vpnd this code may be used                                  */
/* for all GPL/LGPL based open source software products.                      */
/* For all other software products please contact astmail@yahoo.com           */
/* for a license agreement. There is no guarantee for the fitness             */
/* and usability of this code for any purpose. The author takes no            */
/* responsibility for any damages caused by the use of this code.             */
/* Distribution and use of this code is explicitly granted provided           */
/* that the above header is not modified and the above conditions             */
/* are met.                                                                   */
/*                                                                            */
/* This implementation is tuned for speed.                                    */
/*                                                                            */
/* Note that the implementation is processor independent.                     */
/* It does not depend on any run time library and                             */
/* should be 64 bit clean.                                                    */
/*                                                                            */
/* Restriction:                                                               */
/*                                                                            */
/* The maximum data length to be processed is 2^32-1 bytes but                */
/* this shouldn't be an issue for nearly all applications. If                 */
/* it is an issue you will have to extend the variable 'total'                */
/* from 32 bits to 64 bits in the RIPEMD-160 routines.                        */
/*                                                                            */
/* Data sizes:                                                                */
/*                                                                            */
/* data block for RMD160 transformation   WORD08[64]                          */
/* resulting RMD160 or HMAC hash          WORD08[20]                          */
/*                                                                            */
/* WORD08 means an unsigned word of 8 bits length                             */
/* WORD32 means an unsigned word of at least 32 bits length                   */
/*                                                                            */
/* Mode of operation:                                                         */
/*                                                                            */
/* RMD160_FULL defined:                                                       */
/*                                                                            */
/* 1. Call rmd160init                                                         */
/* 2. For all data to be hashed call rmd160next                               */
/* 3. To retrieve the hash call rmd160end                                     */
/*                                                                            */
/* RMD160_FAST defined:                                                       */
/*                                                                            */
/* Call rmd160 to get the hash for the specified data                         */
/*                                                                            */
/* RMD160_HMAC_FULL defined:                                                  */
/*                                                                            */
/* 1. Call rmd160hmkey once to preprocess the selected key                    */
/* 2. Call rmd160hminit                                                       */
/* 3. For all data to be hashed call rmd160hmnext                             */
/* 4. To retrieve the hash call rmd160hmend                                   */
/* 5. When the preprocessed key is no longer required                         */
/*    reset the RMD160HMDATA structure                                        */
/*                                                                            */
/* RMD160_HMAC_FAST defined:                                                  */
/*                                                                            */
/* 1. Call rmd160hmkey once to preprocess the selected key                    */
/* 2. Call rmd160hmac to get the hash for the specified data                  */
/* 3. When the preprocessed key is no longer required                         */
/*    reset the RMD160HMDATA structure                                        */

.text

.ifndef RMD160_FULL
.ifndef RMD160_FAST
.ifndef RMD160_HMAC_FULL
.ifndef RMD160_HMAC_FAST
		RMD160_FULL=1
		RMD160_FAST=1
		RMD160_HMAC_FULL=1
		RMD160_HMAC_FAST=1
		RMD160_PARANOID=1
.endif
.endif
.endif
.endif

.ifdef  RMD160_HMAC_FULL
                _RMD160_HMAC=1
.endif
.ifdef  RMD160_HMAC_FAST
                _RMD160_HMAC=1
.endif
.ifdef  RMD160_FULL
                _RMD160_FULL=1
.endif
.ifdef  _RMD160_HMAC
                _RMD160_FULL=1
                RMD160_PARANOID=1
.endif

/* static void rmd160block(WORD32 *rmd160,WORD08 *block) */

		.type	rmd160init,@function
		.align	16
rmd160block:
		pushl	%ebx
		pushl	%esi
		pushl	%edi
		pushl	%ebp

		movl	(%ebp),%ebx
		movl	4(%ebp),%ecx
		movl	8(%ebp),%edx
		movl	12(%ebp),%esi
		movl	16(%ebp),%ebp

		subl	$20,%esp

		addl	(%edi),%ebx
		movl	%edx,%eax
		xorl	%ecx,%eax
		xorl	%esi,%eax
		addl	%eax,%ebx
		roll	$11,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	4(%edi),%ebp
		xorl	%ebx,%eax
		addl	%eax,%ebp
		roll	$14,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	8(%edi),%esi
		xorl	%ebp,%eax
		addl	%eax,%esi
		roll	$15,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	12(%edi),%edx
		xorl	%esi,%eax
		addl	%eax,%edx
		roll	$12,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	16(%edi),%ecx
		xorl	%edx,%eax
		addl	%eax,%ecx
		roll	$5,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	20(%edi),%ebx
		xorl	%ecx,%eax
		addl	%eax,%ebx
		roll	$8,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	24(%edi),%ebp
		xorl	%ebx,%eax
		addl	%eax,%ebp
		roll	$7,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	28(%edi),%esi
		xorl	%ebp,%eax
		addl	%eax,%esi
		roll	$9,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	32(%edi),%edx
		xorl	%esi,%eax
		addl	%eax,%edx
		roll	$11,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	36(%edi),%ecx
		xorl	%edx,%eax
		addl	%eax,%ecx
		roll	$13,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	40(%edi),%ebx
		xorl	%ecx,%eax
		addl	%eax,%ebx
		roll	$14,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	44(%edi),%ebp
		xorl	%ebx,%eax
		addl	%eax,%ebp
		roll	$15,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	48(%edi),%esi
		xorl	%ebp,%eax
		addl	%eax,%esi
		roll	$6,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	52(%edi),%edx
		xorl	%esi,%eax
		addl	%eax,%edx
		roll	$7,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	56(%edi),%ecx
		xorl	%edx,%eax
		addl	%eax,%ecx
		roll	$9,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	60(%edi),%ebx
		xorl	%ecx,%eax
		addl	%eax,%ebx
		roll	$8,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	28(%edi),%ebp
		andl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x5a827999(%eax,%ebp,),%ebp
		roll	$7,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	16(%edi),%esi
		andl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x5a827999(%eax,%esi,),%esi
		roll	$6,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	52(%edi),%edx
		andl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x5a827999(%eax,%edx,),%edx
		roll	$8,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	4(%edi),%ecx
		andl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x5a827999(%eax,%ecx,),%ecx
		roll	$13,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	40(%edi),%ebx
		andl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x5a827999(%eax,%ebx,),%ebx
		roll	$11,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	24(%edi),%ebp
		andl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x5a827999(%eax,%ebp,),%ebp
		roll	$9,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	60(%edi),%esi
		andl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x5a827999(%eax,%esi,),%esi
		roll	$7,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	12(%edi),%edx
		andl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x5a827999(%eax,%edx,),%edx
		roll	$15,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	48(%edi),%ecx
		andl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x5a827999(%eax,%ecx,),%ecx
		roll	$7,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	(%edi),%ebx
		andl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x5a827999(%eax,%ebx,),%ebx
		roll	$12,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	36(%edi),%ebp
		andl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x5a827999(%eax,%ebp,),%ebp
		roll	$15,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	20(%edi),%esi
		andl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x5a827999(%eax,%esi,),%esi
		roll	$9,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	8(%edi),%edx
		andl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x5a827999(%eax,%edx,),%edx
		roll	$11,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	56(%edi),%ecx
		andl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x5a827999(%eax,%ecx,),%ecx
		roll	$7,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	44(%edi),%ebx
		andl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x5a827999(%eax,%ebx,),%ebx
		roll	$13,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	32(%edi),%ebp
		andl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x5a827999(%eax,%ebp,),%ebp
		roll	$12,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		notl	%eax
		addl	12(%edi),%esi
		orl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x6ed9eba1(%eax,%esi,),%esi
		roll	$11,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		notl	%eax
		addl	40(%edi),%edx
		orl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x6ed9eba1(%eax,%edx,),%edx
		roll	$13,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		notl	%eax
		addl	56(%edi),%ecx
		orl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x6ed9eba1(%eax,%ecx,),%ecx
		roll	$6,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		notl	%eax
		addl	16(%edi),%ebx
		orl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x6ed9eba1(%eax,%ebx,),%ebx
		roll	$7,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		notl	%eax
		addl	36(%edi),%ebp
		orl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x6ed9eba1(%eax,%ebp,),%ebp
		roll	$14,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		notl	%eax
		addl	60(%edi),%esi
		orl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x6ed9eba1(%eax,%esi,),%esi
		roll	$9,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		notl	%eax
		addl	32(%edi),%edx
		orl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x6ed9eba1(%eax,%edx,),%edx
		roll	$13,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		notl	%eax
		addl	4(%edi),%ecx
		orl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x6ed9eba1(%eax,%ecx,),%ecx
		roll	$15,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		notl	%eax
		addl	8(%edi),%ebx
		orl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x6ed9eba1(%eax,%ebx,),%ebx
		roll	$14,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		notl	%eax
		addl	28(%edi),%ebp
		orl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x6ed9eba1(%eax,%ebp,),%ebp
		roll	$8,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		notl	%eax
		addl	(%edi),%esi
		orl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x6ed9eba1(%eax,%esi,),%esi
		roll	$13,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		notl	%eax
		addl	24(%edi),%edx
		orl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x6ed9eba1(%eax,%edx,),%edx
		roll	$6,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		notl	%eax
		addl	52(%edi),%ecx
		orl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x6ed9eba1(%eax,%ecx,),%ecx
		roll	$5,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		notl	%eax
		addl	44(%edi),%ebx
		orl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x6ed9eba1(%eax,%ebx,),%ebx
		roll	$12,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		notl	%eax
		addl	20(%edi),%ebp
		orl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x6ed9eba1(%eax,%ebp,),%ebp
		roll	$7,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		notl	%eax
		addl	48(%edi),%esi
		orl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x6ed9eba1(%eax,%esi,),%esi
		roll	$5,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		addl	4(%edi),%edx
		xorl	%esi,%eax
		andl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x8f1bbcdc(%eax,%edx,),%edx
		roll	$11,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		addl	36(%edi),%ecx
		xorl	%edx,%eax
		andl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x8f1bbcdc(%eax,%ecx,),%ecx
		roll	$12,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		addl	44(%edi),%ebx
		xorl	%ecx,%eax
		andl	%esi,%eax
		xorl	%edx,%eax
		leal	0x8f1bbcdc(%eax,%ebx,),%ebx
		roll	$14,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		addl	40(%edi),%ebp
		xorl	%ebx,%eax
		andl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x8f1bbcdc(%eax,%ebp,),%ebp
		roll	$15,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		addl	(%edi),%esi
		xorl	%ebp,%eax
		andl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x8f1bbcdc(%eax,%esi,),%esi
		roll	$14,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		addl	32(%edi),%edx
		xorl	%esi,%eax
		andl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x8f1bbcdc(%eax,%edx,),%edx
		roll	$15,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		addl	48(%edi),%ecx
		xorl	%edx,%eax
		andl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x8f1bbcdc(%eax,%ecx,),%ecx
		roll	$9,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		addl	16(%edi),%ebx
		xorl	%ecx,%eax
		andl	%esi,%eax
		xorl	%edx,%eax
		leal	0x8f1bbcdc(%eax,%ebx,),%ebx
		roll	$8,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		addl	52(%edi),%ebp
		xorl	%ebx,%eax
		andl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x8f1bbcdc(%eax,%ebp,),%ebp
		roll	$9,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		addl	12(%edi),%esi
		xorl	%ebp,%eax
		andl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x8f1bbcdc(%eax,%esi,),%esi
		roll	$14,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		addl	28(%edi),%edx
		xorl	%esi,%eax
		andl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x8f1bbcdc(%eax,%edx,),%edx
		roll	$5,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		addl	60(%edi),%ecx
		xorl	%edx,%eax
		andl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x8f1bbcdc(%eax,%ecx,),%ecx
		roll	$6,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		addl	56(%edi),%ebx
		xorl	%ecx,%eax
		andl	%esi,%eax
		xorl	%edx,%eax
		leal	0x8f1bbcdc(%eax,%ebx,),%ebx
		roll	$8,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		addl	20(%edi),%ebp
		xorl	%ebx,%eax
		andl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x8f1bbcdc(%eax,%ebp,),%ebp
		roll	$6,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		addl	24(%edi),%esi
		xorl	%ebp,%eax
		andl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x8f1bbcdc(%eax,%esi,),%esi
		roll	$5,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		addl	8(%edi),%edx
		xorl	%esi,%eax
		andl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x8f1bbcdc(%eax,%edx,),%edx
		roll	$12,%edx
		addl	%ecx,%edx
		roll	$10,%ebp

		addl	16(%edi),%ecx
		movl	%ebp,%eax
		notl	%eax
		orl	%esi,%eax
		xorl	%edx,%eax
		leal	0xa953fd4e(%eax,%ecx,),%ecx
		roll	$9,%ecx
		addl	%ebx,%ecx
		roll	$10,%esi

		addl	(%edi),%ebx
		movl	%esi,%eax
		notl	%eax
		orl	%edx,%eax
		xorl	%ecx,%eax
		leal	0xa953fd4e(%eax,%ebx,),%ebx
		roll	$15,%ebx
		addl	%ebp,%ebx
		roll	$10,%edx

		addl	20(%edi),%ebp
		movl	%edx,%eax
		notl	%eax
		orl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0xa953fd4e(%eax,%ebp,),%ebp
		roll	$5,%ebp
		addl	%esi,%ebp
		roll	$10,%ecx

		addl	36(%edi),%esi
		movl	%ecx,%eax
		notl	%eax
		orl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0xa953fd4e(%eax,%esi,),%esi
		roll	$11,%esi
		addl	%edx,%esi
		roll	$10,%ebx

		addl	28(%edi),%edx
		movl	%ebx,%eax
		notl	%eax
		orl	%ebp,%eax
		xorl	%esi,%eax
		leal	0xa953fd4e(%eax,%edx,),%edx
		roll	$6,%edx
		addl	%ecx,%edx
		roll	$10,%ebp

		addl	48(%edi),%ecx
		movl	%ebp,%eax
		notl	%eax
		orl	%esi,%eax
		xorl	%edx,%eax
		leal	0xa953fd4e(%eax,%ecx,),%ecx
		roll	$8,%ecx
		addl	%ebx,%ecx
		roll	$10,%esi

		addl	8(%edi),%ebx
		movl	%esi,%eax
		notl	%eax
		orl	%edx,%eax
		xorl	%ecx,%eax
		leal	0xa953fd4e(%eax,%ebx,),%ebx
		roll	$13,%ebx
		addl	%ebp,%ebx
		roll	$10,%edx

		addl	40(%edi),%ebp
		movl	%edx,%eax
		notl	%eax
		orl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0xa953fd4e(%eax,%ebp,),%ebp
		roll	$12,%ebp
		addl	%esi,%ebp
		roll	$10,%ecx

		addl	56(%edi),%esi
		movl	%ecx,%eax
		notl	%eax
		orl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0xa953fd4e(%eax,%esi,),%esi
		roll	$5,%esi
		addl	%edx,%esi
		roll	$10,%ebx

		addl	4(%edi),%edx
		movl	%ebx,%eax
		notl	%eax
		orl	%ebp,%eax
		xorl	%esi,%eax
		leal	0xa953fd4e(%eax,%edx,),%edx
		roll	$12,%edx
		addl	%ecx,%edx
		roll	$10,%ebp

		addl	12(%edi),%ecx
		movl	%ebp,%eax
		notl	%eax
		orl	%esi,%eax
		xorl	%edx,%eax
		leal	0xa953fd4e(%eax,%ecx,),%ecx
		roll	$13,%ecx
		addl	%ebx,%ecx
		roll	$10,%esi

		addl	32(%edi),%ebx
		movl	%esi,%eax
		notl	%eax
		orl	%edx,%eax
		xorl	%ecx,%eax
		leal	0xa953fd4e(%eax,%ebx,),%ebx
		roll	$14,%ebx
		addl	%ebp,%ebx
		roll	$10,%edx

		addl	44(%edi),%ebp
		movl	%edx,%eax
		notl	%eax
		orl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0xa953fd4e(%eax,%ebp,),%ebp
		roll	$11,%ebp
		addl	%esi,%ebp
		roll	$10,%ecx

		addl	24(%edi),%esi
		movl	%ecx,%eax
		notl	%eax
		orl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0xa953fd4e(%eax,%esi,),%esi
		roll	$8,%esi
		addl	%edx,%esi
		roll	$10,%ebx

		addl	60(%edi),%edx
		movl	%ebx,%eax
		notl	%eax
		orl	%ebp,%eax
		xorl	%esi,%eax
		leal	0xa953fd4e(%eax,%edx,),%edx
		roll	$5,%edx
		addl	%ecx,%edx
		roll	$10,%ebp

		addl	52(%edi),%ecx
		movl	%ebp,%eax
		notl	%eax
		orl	%esi,%eax
		xorl	%edx,%eax
		leal	0xa953fd4e(%eax,%ecx,),%ecx
		roll	$6,%ecx
		addl	%ebx,%ecx
		roll	$10,%esi

		movl	20(%esp),%eax

		movl	%ebx,(%esp)
		movl	%ecx,4(%esp)
		movl	%edx,8(%esp)
		movl	%esi,12(%esp)
		movl	%ebp,16(%esp)

		movl	(%eax),%ebx
		movl	4(%eax),%ecx
		movl	8(%eax),%edx
		movl	12(%eax),%esi
		movl	16(%eax),%ebp

		addl	20(%edi),%ebx
		movl	%esi,%eax
		notl	%eax
		orl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x50a28be6(%eax,%ebx,),%ebx
		roll	$8,%ebx
		addl	%ebp,%ebx
		roll	$10,%edx

		addl	56(%edi),%ebp
		movl	%edx,%eax
		notl	%eax
		orl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x50a28be6(%eax,%ebp,),%ebp
		roll	$9,%ebp
		addl	%esi,%ebp
		roll	$10,%ecx

		addl	28(%edi),%esi
		movl	%ecx,%eax
		notl	%eax
		orl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x50a28be6(%eax,%esi,),%esi
		roll	$9,%esi
		addl	%edx,%esi
		roll	$10,%ebx

		addl	(%edi),%edx
		movl	%ebx,%eax
		notl	%eax
		orl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x50a28be6(%eax,%edx,),%edx
		roll	$11,%edx
		addl	%ecx,%edx
		roll	$10,%ebp

		addl	36(%edi),%ecx
		movl	%ebp,%eax
		notl	%eax
		orl	%esi,%eax
		xorl	%edx,%eax
		leal	0x50a28be6(%eax,%ecx,),%ecx
		roll	$13,%ecx
		addl	%ebx,%ecx
		roll	$10,%esi

		addl	8(%edi),%ebx
		movl	%esi,%eax
		notl	%eax
		orl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x50a28be6(%eax,%ebx,),%ebx
		roll	$15,%ebx
		addl	%ebp,%ebx
		roll	$10,%edx

		addl	44(%edi),%ebp
		movl	%edx,%eax
		notl	%eax
		orl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x50a28be6(%eax,%ebp,),%ebp
		roll	$15,%ebp
		addl	%esi,%ebp
		roll	$10,%ecx

		addl	16(%edi),%esi
		movl	%ecx,%eax
		notl	%eax
		orl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x50a28be6(%eax,%esi,),%esi
		roll	$5,%esi
		addl	%edx,%esi
		roll	$10,%ebx

		addl	52(%edi),%edx
		movl	%ebx,%eax
		notl	%eax
		orl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x50a28be6(%eax,%edx,),%edx
		roll	$7,%edx
		addl	%ecx,%edx
		roll	$10,%ebp

		addl	24(%edi),%ecx
		movl	%ebp,%eax
		notl	%eax
		orl	%esi,%eax
		xorl	%edx,%eax
		leal	0x50a28be6(%eax,%ecx,),%ecx
		roll	$7,%ecx
		addl	%ebx,%ecx
		roll	$10,%esi

		addl	60(%edi),%ebx
		movl	%esi,%eax
		notl	%eax
		orl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x50a28be6(%eax,%ebx,),%ebx
		roll	$8,%ebx
		addl	%ebp,%ebx
		roll	$10,%edx

		addl	32(%edi),%ebp
		movl	%edx,%eax
		notl	%eax
		orl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x50a28be6(%eax,%ebp,),%ebp
		roll	$11,%ebp
		addl	%esi,%ebp
		roll	$10,%ecx

		addl	4(%edi),%esi
		movl	%ecx,%eax
		notl	%eax
		orl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x50a28be6(%eax,%esi,),%esi
		roll	$14,%esi
		addl	%edx,%esi
		roll	$10,%ebx

		addl	40(%edi),%edx
		movl	%ebx,%eax
		notl	%eax
		orl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x50a28be6(%eax,%edx,),%edx
		roll	$14,%edx
		addl	%ecx,%edx
		roll	$10,%ebp

		addl	12(%edi),%ecx
		movl	%ebp,%eax
		notl	%eax
		orl	%esi,%eax
		xorl	%edx,%eax
		leal	0x50a28be6(%eax,%ecx,),%ecx
		roll	$12,%ecx
		addl	%ebx,%ecx
		roll	$10,%esi

		addl	48(%edi),%ebx
		movl	%esi,%eax
		notl	%eax
		orl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x50a28be6(%eax,%ebx,),%ebx
		roll	$6,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		addl	24(%edi),%ebp
		xorl	%ebx,%eax
		andl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x5c4dd124(%eax,%ebp,),%ebp
		roll	$9,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		addl	44(%edi),%esi
		xorl	%ebp,%eax
		andl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x5c4dd124(%eax,%esi,),%esi
		roll	$13,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		addl	12(%edi),%edx
		xorl	%esi,%eax
		andl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x5c4dd124(%eax,%edx,),%edx
		roll	$15,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		addl	28(%edi),%ecx
		xorl	%edx,%eax
		andl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x5c4dd124(%eax,%ecx,),%ecx
		roll	$7,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		addl	(%edi),%ebx
		xorl	%ecx,%eax
		andl	%esi,%eax
		xorl	%edx,%eax
		leal	0x5c4dd124(%eax,%ebx,),%ebx
		roll	$12,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		addl	52(%edi),%ebp
		xorl	%ebx,%eax
		andl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x5c4dd124(%eax,%ebp,),%ebp
		roll	$8,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		addl	20(%edi),%esi
		xorl	%ebp,%eax
		andl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x5c4dd124(%eax,%esi,),%esi
		roll	$9,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		addl	40(%edi),%edx
		xorl	%esi,%eax
		andl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x5c4dd124(%eax,%edx,),%edx
		roll	$11,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		addl	56(%edi),%ecx
		xorl	%edx,%eax
		andl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x5c4dd124(%eax,%ecx,),%ecx
		roll	$7,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		addl	60(%edi),%ebx
		xorl	%ecx,%eax
		andl	%esi,%eax
		xorl	%edx,%eax
		leal	0x5c4dd124(%eax,%ebx,),%ebx
		roll	$7,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		addl	32(%edi),%ebp
		xorl	%ebx,%eax
		andl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x5c4dd124(%eax,%ebp,),%ebp
		roll	$12,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		addl	48(%edi),%esi
		xorl	%ebp,%eax
		andl	%ecx,%eax
		xorl	%ebx,%eax
		leal	0x5c4dd124(%eax,%esi,),%esi
		roll	$7,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		addl	16(%edi),%edx
		xorl	%esi,%eax
		andl	%ebx,%eax
		xorl	%ebp,%eax
		leal	0x5c4dd124(%eax,%edx,),%edx
		roll	$6,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		addl	36(%edi),%ecx
		xorl	%edx,%eax
		andl	%ebp,%eax
		xorl	%esi,%eax
		leal	0x5c4dd124(%eax,%ecx,),%ecx
		roll	$15,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		addl	4(%edi),%ebx
		xorl	%ecx,%eax
		andl	%esi,%eax
		xorl	%edx,%eax
		leal	0x5c4dd124(%eax,%ebx,),%ebx
		roll	$13,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		addl	8(%edi),%ebp
		xorl	%ebx,%eax
		andl	%edx,%eax
		xorl	%ecx,%eax
		leal	0x5c4dd124(%eax,%ebp,),%ebp
		roll	$11,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		notl	%eax
		addl	60(%edi),%esi
		orl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x6d703ef3(%eax,%esi,),%esi
		roll	$9,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		notl	%eax
		addl	20(%edi),%edx
		orl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x6d703ef3(%eax,%edx,),%edx
		roll	$7,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		notl	%eax
		addl	4(%edi),%ecx
		orl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x6d703ef3(%eax,%ecx,),%ecx
		roll	$15,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		notl	%eax
		addl	12(%edi),%ebx
		orl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x6d703ef3(%eax,%ebx,),%ebx
		roll	$11,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		notl	%eax
		addl	28(%edi),%ebp
		orl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x6d703ef3(%eax,%ebp,),%ebp
		roll	$8,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		notl	%eax
		addl	56(%edi),%esi
		orl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x6d703ef3(%eax,%esi,),%esi
		roll	$6,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		notl	%eax
		addl	24(%edi),%edx
		orl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x6d703ef3(%eax,%edx,),%edx
		roll	$6,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		notl	%eax
		addl	36(%edi),%ecx
		orl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x6d703ef3(%eax,%ecx,),%ecx
		roll	$14,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		notl	%eax
		addl	44(%edi),%ebx
		orl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x6d703ef3(%eax,%ebx,),%ebx
		roll	$12,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		notl	%eax
		addl	32(%edi),%ebp
		orl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x6d703ef3(%eax,%ebp,),%ebp
		roll	$13,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		notl	%eax
		addl	48(%edi),%esi
		orl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x6d703ef3(%eax,%esi,),%esi
		roll	$5,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		notl	%eax
		addl	8(%edi),%edx
		orl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x6d703ef3(%eax,%edx,),%edx
		roll	$14,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		notl	%eax
		addl	40(%edi),%ecx
		orl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x6d703ef3(%eax,%ecx,),%ecx
		roll	$13,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		notl	%eax
		addl	(%edi),%ebx
		orl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x6d703ef3(%eax,%ebx,),%ebx
		roll	$13,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		notl	%eax
		addl	16(%edi),%ebp
		orl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x6d703ef3(%eax,%ebp,),%ebp
		roll	$7,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		notl	%eax
		addl	52(%edi),%esi
		orl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x6d703ef3(%eax,%esi,),%esi
		roll	$5,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	32(%edi),%edx
		andl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x7a6d76e9(%eax,%edx,),%edx
		roll	$15,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	24(%edi),%ecx
		andl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x7a6d76e9(%eax,%ecx,),%ecx
		roll	$5,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	16(%edi),%ebx
		andl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x7a6d76e9(%eax,%ebx,),%ebx
		roll	$8,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	4(%edi),%ebp
		andl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x7a6d76e9(%eax,%ebp,),%ebp
		roll	$11,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	12(%edi),%esi
		andl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x7a6d76e9(%eax,%esi,),%esi
		roll	$14,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	44(%edi),%edx
		andl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x7a6d76e9(%eax,%edx,),%edx
		roll	$14,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	60(%edi),%ecx
		andl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x7a6d76e9(%eax,%ecx,),%ecx
		roll	$6,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	(%edi),%ebx
		andl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x7a6d76e9(%eax,%ebx,),%ebx
		roll	$14,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	20(%edi),%ebp
		andl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x7a6d76e9(%eax,%ebp,),%ebp
		roll	$6,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	48(%edi),%esi
		andl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x7a6d76e9(%eax,%esi,),%esi
		roll	$9,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	8(%edi),%edx
		andl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x7a6d76e9(%eax,%edx,),%edx
		roll	$12,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	52(%edi),%ecx
		andl	%edx,%eax
		xorl	%ebp,%eax
		leal	0x7a6d76e9(%eax,%ecx,),%ecx
		roll	$9,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	36(%edi),%ebx
		andl	%ecx,%eax
		xorl	%esi,%eax
		leal	0x7a6d76e9(%eax,%ebx,),%ebx
		roll	$12,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	28(%edi),%ebp
		andl	%ebx,%eax
		xorl	%edx,%eax
		leal	0x7a6d76e9(%eax,%ebp,),%ebp
		roll	$5,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	40(%edi),%esi
		andl	%ebp,%eax
		xorl	%ecx,%eax
		leal	0x7a6d76e9(%eax,%esi,),%esi
		roll	$15,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	56(%edi),%edx
		andl	%esi,%eax
		xorl	%ebx,%eax
		leal	0x7a6d76e9(%eax,%edx,),%edx
		roll	$8,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	48(%edi),%ecx
		xorl	%edx,%eax
		addl	%eax,%ecx
		roll	$8,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	60(%edi),%ebx
		xorl	%ecx,%eax
		addl	%eax,%ebx
		roll	$5,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	40(%edi),%ebp
		xorl	%ebx,%eax
		addl	%eax,%ebp
		roll	$12,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	16(%edi),%esi
		xorl	%ebp,%eax
		addl	%eax,%esi
		roll	$9,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	4(%edi),%edx
		xorl	%esi,%eax
		addl	%eax,%edx
		roll	$12,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	20(%edi),%ecx
		xorl	%edx,%eax
		addl	%eax,%ecx
		roll	$5,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	32(%edi),%ebx
		xorl	%ecx,%eax
		addl	%eax,%ebx
		roll	$14,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	28(%edi),%ebp
		xorl	%ebx,%eax
		addl	%eax,%ebp
		roll	$6,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	24(%edi),%esi
		xorl	%ebp,%eax
		addl	%eax,%esi
		roll	$8,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	8(%edi),%edx
		xorl	%esi,%eax
		addl	%eax,%edx
		roll	$13,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	52(%edi),%ecx
		xorl	%edx,%eax
		addl	%eax,%ecx
		roll	$6,%ecx
		movl	%edx,%eax
		roll	$10,%esi
		addl	%ebx,%ecx

		xorl	%esi,%eax
		addl	56(%edi),%ebx
		xorl	%ecx,%eax
		addl	%eax,%ebx
		roll	$5,%ebx
		movl	%ecx,%eax
		roll	$10,%edx
		addl	%ebp,%ebx

		xorl	%edx,%eax
		addl	(%edi),%ebp
		xorl	%ebx,%eax
		addl	%eax,%ebp
		roll	$15,%ebp
		movl	%ebx,%eax
		roll	$10,%ecx
		addl	%esi,%ebp

		xorl	%ecx,%eax
		addl	12(%edi),%esi
		xorl	%ebp,%eax
		addl	%eax,%esi
		roll	$13,%esi
		movl	%ebp,%eax
		roll	$10,%ebx
		addl	%edx,%esi

		xorl	%ebx,%eax
		addl	36(%edi),%edx
		xorl	%esi,%eax
		addl	%eax,%edx
		roll	$11,%edx
		movl	%esi,%eax
		roll	$10,%ebp
		addl	%ecx,%edx

		xorl	%ebp,%eax
		addl	44(%edi),%ecx
		xorl	%edx,%eax
		addl	%eax,%ecx
		roll	$11,%ecx
		addl	%ebx,%ecx
		roll	$10,%esi

		movl	20(%esp),%eax

		addl	16(%esp),%ebx
		addl	(%esp),%ecx
		addl	4(%esp),%edx
		addl	8(%esp),%esi
		addl	12(%esp),%ebp

		addl	$20,%esp

		addl	12(%eax),%ebx
		addl	16(%eax),%ecx
		addl	(%eax),%edx
		addl	4(%eax),%esi
		addl	8(%eax),%ebp

		movl	%ebp,4(%eax)
		movl	%esi,(%eax)

		popl	%ebp
		popl	%edi

		movl	%ebx,8(%eax)
		movl	%ecx,12(%eax)
		movl	%edx,16(%eax)

		popl	%esi
		popl	%ebx
		ret

/* void rmd160init(RMD160DATA *ptr) */

.ifdef _RMD160_FULL

.globl rmd160init
		.type	rmd160init,@function
		.align	16
rmd160init:
		movl	4(%esp),%eax
		movl	$0x67452301,(%eax)
		movl	$0xefcdab89,4(%eax)
		movl	$0x98badcfe,8(%eax)
		movl	$0x10325476,12(%eax)
		movl	$0xc3d2e1f0,16(%eax)
		movl	$0,20(%eax)
		movb	$0,88(%eax)
		ret
.endif

/* void rmd160next(WORD08 *data,WORD32 length,RMD160DATA *ptr) */

.ifdef _RMD160_FULL

.globl rmd160next
		.type	rmd160next,@function
		.align	16
rmd160next:
		pushl	%ebp
		pushl	%ebx
		pushl	%esi
		pushl	%edi

		movl	28(%esp),%ebp
		movl	24(%esp),%esi
		leal	24(%ebp),%edi
		movl	20(%esp),%ebx
		addl	%esi,20(%ebp)

		movzbl	88(%ebp),%ecx
		testl	%esi,%esi
		je	rmd160nxtl1end
rmd160nextlp1:	testl	%ecx,%ecx
		je	rmd160nxtl1end
		movb	(%ebx),%al
		incl	%ebx
		movb	%al,(%edi,%ecx,)
		incl	%ecx
		cmpl	$64,%ecx
		je	rmd160nxtcont1
		decl	%esi
		jne	rmd160nextlp1
		jmp	rmd160nxtl1end
rmd160nxtcont1:	call	rmd160block
		xorl	%ecx,%ecx
		decl	%esi

rmd160nxtl1end:	movl	%ebx,%edi
		movl	%ecx,%ebx
		cmpl	$64,%esi
		jnae	rmd160nxtl2end

rmd160nextlp2:	call	rmd160block
		subl	$64,%esi
		addl	$64,%edi
		cmpl	$64,%esi
		jnb	rmd160nextlp2

rmd160nxtl2end:	movl	%esi,%edx
		shrl	$2,%esi
		je	rmd160nxtl3end

rmd160nextlp3:	movl	(%edi),%eax
		addl	$4,%edi
		movl	%eax,24(%ebp,%ebx,)
		addl	$4,%ebx
		decl	%esi
		jne	rmd160nextlp3

rmd160nxtl3end:	andl	$3,%edx
		je	rmd160nextend

rmd160nextlp4:	movb	(%edi),%al
		incl	%edi
		movb	%al,24(%ebp,%ebx,)
		incl	%ebx
		decl	%edx
		jne	rmd160nextlp4

rmd160nextend:	movb	%bl,88(%ebp)

		popl	%edi
		popl	%esi
		popl	%ebx
		popl	%ebp
		ret

.endif

/* void rmd160end(WORD08 *result,RMD160DATA *ptr) */

.ifdef _RMD160_FULL

.globl rmd160end
		.type	rmd160end,@function
		.align	16
rmd160end:
		pushl	%ebp
		pushl	%esi
		pushl	%edi
		pushl	%ebx

		movl	24(%esp),%ebp
		movl	20(%esp),%esi
		leal	24(%ebp),%edi

		movzbl	88(%ebp),%ebx
		incl	%ebx
		movl	%ebx,%eax
		movb	$128,-1(%edi,%ebx,)
		andl	$3,%eax
		je	rmd160endlaend

rmd160endlpa:	movb	$0,(%edi,%ebx,)
		incl	%eax
		incl	%ebx
		cmpl	$4,%eax
		jne	rmd160endlpa

rmd160endlaend:	shrl	$2,%ebx
		jmp	rmd160endlbbeg

rmd160endlpb:	movl	$0,(%edi,%ebx,4)
		incl	%ebx

rmd160endlbbeg:	cmpl	$14,%ebx
		je	rmd160endlbend
		cmpl	$16,%ebx
		jne	rmd160endlpb
		xorl	%ebx,%ebx
		call	rmd160block
		jmp	rmd160endlpb

rmd160endlbend:	movl	20(%ebp),%edx
		movl	%edx,%ecx
		shll	$3,%edx
		shrl	$29,%ecx
		movl	%edx,80(%ebp)
		movl	%ecx,84(%ebp)
		call	rmd160block

		movl	$5,%edx

.ifdef RMD160_PARANOID
		movl	$16,%ecx
		xorl	%eax,%eax
.endif

rmd160endloop2:	decl	%edx
		movl	(%ebp,%edx,4),%ebx
		movl	%ebx,(%esi,%edx,4)
		jne	rmd160endloop2

.ifdef RMD160_PARANOID
rmd160endloop3:	decl	%ecx
		movl	%eax,24(%ebp,%ecx,4)
		jne	rmd160endloop3
.endif

		popl	%ebx
		popl	%edi
		popl	%esi
		popl	%ebp
		ret

.endif

/* void rmd160(WORD08 *data,WORD32 length,WORD08 *result) */

.ifdef RMD160_FAST

.globl rmd160
		.type	rmd160,@function
		.align	16
rmd160:
		pushl	%ebx
		pushl	%ebp
		pushl	%esi
		pushl	%edi
		subl	$84,%esp

		movl	%esp,%ebp
		movl	$0x67452301,(%ebp)
		movl	$0xefcdab89,4(%ebp)
		movl	$0x98badcfe,8(%ebp)
		movl	$0x10325476,12(%ebp)
		movl	$0xc3d2e1f0,16(%ebp)

		movl	108(%esp),%esi
		movl	104(%esp),%edi
		cmpl	$64,%esi
		jnae	rmd160loop2end

rmd160loop2:	call	rmd160block
		subl	$64,%esi
		addl	$64,%edi
		cmpl	$64,%esi
		jnb	rmd160loop2

rmd160loop2end:	movl	%esi,%ecx
		movl	%edi,%edx
		xorl	%ebx,%ebx
		leal	20(%esp),%edi
		shrl	$2,%ecx
		je	rmd160lp3bbeg

rmd160loop3a:	movl	(%edx,%ebx,4),%eax
		movl	%eax,(%edi,%ebx,4)
		incl	%ebx
		decl	%ecx
		jne	rmd160loop3a
		leal	(,%ebx,4),%ebx

rmd160lp3bbeg:	andl	$3,%esi
		je	rmd160loop3end

rmd160loop3b:	movb	(%edx,%ebx,),%al
		movb	%al,(%edi,%ebx,)
		incl	%ebx
		decl	%esi
		jne	rmd160loop3b

rmd160loop3end:	incl	%ebx
		movl	%ebx,%eax
		movb	$128,-1(%edi,%ebx,)
		andl	$3,%eax
		je	rmd160lp4aend

rmd160loop4a:	movb	$0,(%edi,%ebx,)
		incl	%eax
		incl	%ebx
		cmpl	$4,%eax
		jne	rmd160loop4a

rmd160lp4aend:	shrl	$2,%ebx
		jmp	rmd160lp4bbeg

rmd160loop4b:	movl	$0,(%edi,%ebx,4)
		incl	%ebx

rmd160lp4bbeg:	cmpl	$14,%ebx
		je	rmd160loop4end
		cmpl	$16,%ebx
		jne	rmd160loop4b
		xorl	%ebx,%ebx
		call	rmd160block
		jmp	rmd160loop4b

rmd160loop4end:	movl	108(%esp),%edx
		movl	%edx,%ecx
		shll	$3,%edx
		shrl	$29,%ecx
		movl	%edx,56(%edi)
		movl	%ecx,60(%edi)
		call	rmd160block

		movl	112(%esp),%ecx
		movl	$5,%ebx
rmd160loop5:	decl	%ebx
		movl	(%ebp,%ebx,4),%eax
		movl	%eax,(%ecx,%ebx,4)
		jne	rmd160loop5

.ifdef RMD160_PARANOID

		movl	$16,%ebx
		xorl	%eax,%eax
rmd160loop6:	decl	%ebx
		movl	%eax,(%edi,%ebx,4)
		jne	rmd160loop6

.endif

		addl	$84,%esp
		popl	%edi
		popl	%esi
		popl	%ebp
		popl	%ebx
		ret

.endif

/* void rmd160hmkey(WORD08 *key,WORD32 keylength,RMD160HMDATA *ptr) */

.ifdef	_RMD160_HMAC

.globl rmd160hmkey
		.type	rmd160hmkey,@function
		.align	16
rmd160hmkey:
		pushl	%ebx
		pushl	%esi
		pushl	%ebp
		pushl	%edi

		movl	20(%esp),%ebx
		movl	24(%esp),%esi
		movl	28(%esp),%ebp
		subl	$112,%esp
		movl	%esp,%edi

		cmpl	$65,%esi
		jnae	rmd160hmkey1

		pushl	%edi
		call	rmd160init
		pushl	%esi
		pushl	%ebx
		call	rmd160next
		leal	92(%edi),%ebx
		pushl	%edi
		pushl	%ebx
		call	rmd160end
		xorl	%eax,%eax
		movl	%edi,%esp
		movl	$20,%esi
		movl	%eax,(%edi)
		movl	%eax,4(%edi)
		movl	%eax,8(%edi)
		movl	%eax,12(%edi)
		movl	%eax,16(%edi)

rmd160hmkey1:	movl	$0x67452301,(%ebp)
		movl	$0xefcdab89,4(%ebp)
		movl	$0x98badcfe,8(%ebp)
		movl	$0x10325476,12(%ebp)
		movl	$0xc3d2e1f0,16(%ebp)
		movl	$0x67452301,20(%ebp)
		movl	$0xefcdab89,24(%ebp)
		movl	$0x98badcfe,28(%ebp)
		movl	$0x10325476,32(%ebp)
		movl	$0xc3d2e1f0,36(%ebp)

		xorl	%ecx,%ecx
		movb	$54,%dl
		jmp	rmd160hmkey2
rmd160hmkeylp3:	movb	(%ebx,%ecx,),%al
		xorb	%dl,%al
		movb	%al,(%edi,%ecx,)
		incl	%ecx
rmd160hmkey2:	cmpl	%ecx,%esi
		jne	rmd160hmkeylp3

		jmp	rmd160hmkey3
rmd160hmkeylp4:	movb	%dl,(%edi,%ecx,)
		incl	%ecx
rmd160hmkey3:	cmpl	$64,%ecx
		jne	rmd160hmkeylp4

		call	rmd160block

		xorl	%ecx,%ecx
		movb	$92,%dl
		jmp	rmd160hmkey4
rmd160hmkeylp5:	movb	(%ebx,%ecx,),%al
		xorb	%dl,%al
		movb	%al,(%edi,%ecx,)
		incl	%ecx
rmd160hmkey4:	cmpl	%ecx,%esi
		jne	rmd160hmkeylp5

		jmp	rmd160hmkey5
rmd160hmkeylp6:	movb	%dl,(%edi,%ecx,)
		incl	%ecx
rmd160hmkey5:	cmpl	$64,%ecx
		jne	rmd160hmkeylp6

		addl	$20,%ebp
		call	rmd160block

		movl	$20,%edx
		xorl	%eax,%eax
rmd160hmkeylp7:	decl	%edx
		movl	%eax,(%edi,%edx,4)
		movb	%al,92(%edi,%edx,)
		jne	rmd160hmkeylp7

		addl	$112,%esp
		popl	%edi
		popl	%ebp
		popl	%esi
		popl	%ebx
		ret

.endif

/* void rmd160hminit(RMD160DATA *ptr,RMD160HMDATA *key) */

.ifdef	RMD160_HMAC_FULL

.globl rmd160hminit
		.type	rmd160hminit,@function
		.align	16
rmd160hminit:
		movl	8(%esp),%ecx
		movl	4(%esp),%edx
		movl	(%ecx),%eax
		movb	$0,88(%edx)
		movl	%eax,(%edx)
		movl	4(%ecx),%eax
		movl	$64,20(%edx)
		movl	%eax,4(%edx)
		movl	8(%ecx),%eax
		movl	%eax,8(%edx)
		movl	12(%ecx),%eax
		movl	%eax,12(%edx)
		movl	16(%ecx),%eax
		movl	%eax,16(%edx)
		ret

.endif

/* void rmd160hmend(WORD08 *result,RMD160DATA *ptr,RMD160HMDATA *key) */

.ifdef	RMD160_HMAC_FULL

.globl rmd160hmend
		.type	rmd160hmend,@function
		.align	16
rmd160hmend:
		pushl	%ebx
		pushl	%esi
		subl	$12,%esp
		movl	%esp,%esi
		movl	24(%esi),%eax
		movl	28(%esi),%ebx
		movl	%eax,(%esi)
		movl	%ebx,4(%esi)
		call	rmd160end
		movl	32(%esi),%ecx
		movb	$0,88(%ebx)
		movl	20(%ecx),%eax
		movl	24(%ecx),%edx
		movl	%eax,(%ebx)
		movl	%edx,4(%ebx)
		movl	28(%ecx),%eax
		movl	32(%ecx),%edx
		movl	%eax,8(%ebx)
		movl	%edx,12(%ebx)
		movl	36(%ecx),%eax
		movl	$64,20(%ebx)
		movl	%eax,16(%ebx)
		movl	$20,4(%esi)
		movl	%ebx,8(%esi)
		call	rmd160next
		movl	%ebx,4(%esi)
		call	rmd160end
		addl	$12,%esp
		popl	%esi
		popl	%ebx
		ret

.endif

/* void rmd160hmac(WORD08 *data,WORD32 length,WORD08 *result,RMD160HMDATA *key) */

.ifdef	RMD160_HMAC_FAST

.globl rmd160hmac
		.type	rmd160hmac,@function
		.align	16
rmd160hmac:
		pushl	%ebx
		pushl	%edi
		pushl	%esi

		xorl	%ecx,%ecx	/* keep this ! */

		movl	28(%esp),%ebx
		subl	$104,%esp
		movl	%esp,%esi
		leal	12(%esi),%edi

		movl	(%ebx),%eax
		movl	4(%ebx),%edx
		movl	%eax,(%edi)
		movl	%edx,4(%edi)
		movl	8(%ebx),%eax
		movl	12(%ebx),%edx
		movl	%eax,8(%edi)
		movl	%edx,12(%edi)
		movl	16(%ebx),%eax
		movb	$0,88(%edi)
		movl	%eax,16(%edi)

		movl	$64,20(%edi)

		movl	120(%esi),%eax
		movl	124(%esi),%ecx
		movl	%eax,(%esi)
		movl	%ecx,4(%esi)
		movl	%edi,8(%esi)
		call	rmd160next

		movl	128(%esi),%eax
		movl	%edi,4(%esi)
		movl	%eax,(%esi)
		call	rmd160end

		movl	20(%ebx),%eax
		movl	24(%ebx),%edx
		movl	%eax,(%edi)
		movl	%edx,4(%edi)
		movl	28(%ebx),%eax
		movl	32(%ebx),%edx
		movl	%eax,8(%edi)
		movl	%edx,12(%edi)
		movl	36(%ebx),%eax
		movb	$0,88(%edi)
		movl	%eax,16(%edi)

		movl	$64,20(%edi)

		movl	$20,4(%esi)
		call	rmd160next

		movl	%edi,4(%esi)
		call	rmd160end

		addl	$104,%esp
		popl	%esi
		popl	%edi
		popl	%ebx
		ret

.endif
