// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cloudfront provides a client for Amazon CloudFront.
package cloudfront

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restxml"
)

const opCreateCloudFrontOriginAccessIdentity = "CreateCloudFrontOriginAccessIdentity2016_01_28"

// CreateCloudFrontOriginAccessIdentityRequest generates a request for the CreateCloudFrontOriginAccessIdentity operation.
func (c *CloudFront) CreateCloudFrontOriginAccessIdentityRequest(input *CreateCloudFrontOriginAccessIdentityInput) (req *request.Request, output *CreateCloudFrontOriginAccessIdentityOutput) {
	op := &request.Operation{
		Name:       opCreateCloudFrontOriginAccessIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/2016-01-28/origin-access-identity/cloudfront",
	}

	if input == nil {
		input = &CreateCloudFrontOriginAccessIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateCloudFrontOriginAccessIdentityOutput{}
	req.Data = output
	return
}

// Create a new origin access identity.
func (c *CloudFront) CreateCloudFrontOriginAccessIdentity(input *CreateCloudFrontOriginAccessIdentityInput) (*CreateCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.CreateCloudFrontOriginAccessIdentityRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDistribution = "CreateDistribution2016_01_28"

// CreateDistributionRequest generates a request for the CreateDistribution operation.
func (c *CloudFront) CreateDistributionRequest(input *CreateDistributionInput) (req *request.Request, output *CreateDistributionOutput) {
	op := &request.Operation{
		Name:       opCreateDistribution,
		HTTPMethod: "POST",
		HTTPPath:   "/2016-01-28/distribution",
	}

	if input == nil {
		input = &CreateDistributionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDistributionOutput{}
	req.Data = output
	return
}

// Create a new distribution.
func (c *CloudFront) CreateDistribution(input *CreateDistributionInput) (*CreateDistributionOutput, error) {
	req, out := c.CreateDistributionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateInvalidation = "CreateInvalidation2016_01_28"

// CreateInvalidationRequest generates a request for the CreateInvalidation operation.
func (c *CloudFront) CreateInvalidationRequest(input *CreateInvalidationInput) (req *request.Request, output *CreateInvalidationOutput) {
	op := &request.Operation{
		Name:       opCreateInvalidation,
		HTTPMethod: "POST",
		HTTPPath:   "/2016-01-28/distribution/{DistributionId}/invalidation",
	}

	if input == nil {
		input = &CreateInvalidationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateInvalidationOutput{}
	req.Data = output
	return
}

// Create a new invalidation.
func (c *CloudFront) CreateInvalidation(input *CreateInvalidationInput) (*CreateInvalidationOutput, error) {
	req, out := c.CreateInvalidationRequest(input)
	err := req.Send()
	return out, err
}

const opCreateStreamingDistribution = "CreateStreamingDistribution2016_01_28"

// CreateStreamingDistributionRequest generates a request for the CreateStreamingDistribution operation.
func (c *CloudFront) CreateStreamingDistributionRequest(input *CreateStreamingDistributionInput) (req *request.Request, output *CreateStreamingDistributionOutput) {
	op := &request.Operation{
		Name:       opCreateStreamingDistribution,
		HTTPMethod: "POST",
		HTTPPath:   "/2016-01-28/streaming-distribution",
	}

	if input == nil {
		input = &CreateStreamingDistributionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateStreamingDistributionOutput{}
	req.Data = output
	return
}

// Create a new streaming distribution.
func (c *CloudFront) CreateStreamingDistribution(input *CreateStreamingDistributionInput) (*CreateStreamingDistributionOutput, error) {
	req, out := c.CreateStreamingDistributionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteCloudFrontOriginAccessIdentity = "DeleteCloudFrontOriginAccessIdentity2016_01_28"

// DeleteCloudFrontOriginAccessIdentityRequest generates a request for the DeleteCloudFrontOriginAccessIdentity operation.
func (c *CloudFront) DeleteCloudFrontOriginAccessIdentityRequest(input *DeleteCloudFrontOriginAccessIdentityInput) (req *request.Request, output *DeleteCloudFrontOriginAccessIdentityOutput) {
	op := &request.Operation{
		Name:       opDeleteCloudFrontOriginAccessIdentity,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2016-01-28/origin-access-identity/cloudfront/{Id}",
	}

	if input == nil {
		input = &DeleteCloudFrontOriginAccessIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteCloudFrontOriginAccessIdentityOutput{}
	req.Data = output
	return
}

// Delete an origin access identity.
func (c *CloudFront) DeleteCloudFrontOriginAccessIdentity(input *DeleteCloudFrontOriginAccessIdentityInput) (*DeleteCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.DeleteCloudFrontOriginAccessIdentityRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDistribution = "DeleteDistribution2016_01_28"

// DeleteDistributionRequest generates a request for the DeleteDistribution operation.
func (c *CloudFront) DeleteDistributionRequest(input *DeleteDistributionInput) (req *request.Request, output *DeleteDistributionOutput) {
	op := &request.Operation{
		Name:       opDeleteDistribution,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2016-01-28/distribution/{Id}",
	}

	if input == nil {
		input = &DeleteDistributionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteDistributionOutput{}
	req.Data = output
	return
}

// Delete a distribution.
func (c *CloudFront) DeleteDistribution(input *DeleteDistributionInput) (*DeleteDistributionOutput, error) {
	req, out := c.DeleteDistributionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteStreamingDistribution = "DeleteStreamingDistribution2016_01_28"

// DeleteStreamingDistributionRequest generates a request for the DeleteStreamingDistribution operation.
func (c *CloudFront) DeleteStreamingDistributionRequest(input *DeleteStreamingDistributionInput) (req *request.Request, output *DeleteStreamingDistributionOutput) {
	op := &request.Operation{
		Name:       opDeleteStreamingDistribution,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2016-01-28/streaming-distribution/{Id}",
	}

	if input == nil {
		input = &DeleteStreamingDistributionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteStreamingDistributionOutput{}
	req.Data = output
	return
}

// Delete a streaming distribution.
func (c *CloudFront) DeleteStreamingDistribution(input *DeleteStreamingDistributionInput) (*DeleteStreamingDistributionOutput, error) {
	req, out := c.DeleteStreamingDistributionRequest(input)
	err := req.Send()
	return out, err
}

const opGetCloudFrontOriginAccessIdentity = "GetCloudFrontOriginAccessIdentity2016_01_28"

// GetCloudFrontOriginAccessIdentityRequest generates a request for the GetCloudFrontOriginAccessIdentity operation.
func (c *CloudFront) GetCloudFrontOriginAccessIdentityRequest(input *GetCloudFrontOriginAccessIdentityInput) (req *request.Request, output *GetCloudFrontOriginAccessIdentityOutput) {
	op := &request.Operation{
		Name:       opGetCloudFrontOriginAccessIdentity,
		HTTPMethod: "GET",
		HTTPPath:   "/2016-01-28/origin-access-identity/cloudfront/{Id}",
	}

	if input == nil {
		input = &GetCloudFrontOriginAccessIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetCloudFrontOriginAccessIdentityOutput{}
	req.Data = output
	return
}

// Get the information about an origin access identity.
func (c *CloudFront) GetCloudFrontOriginAccessIdentity(input *GetCloudFrontOriginAccessIdentityInput) (*GetCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.GetCloudFrontOriginAccessIdentityRequest(input)
	err := req.Send()
	return out, err
}

const opGetCloudFrontOriginAccessIdentityConfig = "GetCloudFrontOriginAccessIdentityConfig2016_01_28"

// GetCloudFrontOriginAccessIdentityConfigRequest generates a request for the GetCloudFrontOriginAccessIdentityConfig operation.
func (c *CloudFront) GetCloudFrontOriginAccessIdentityConfigRequest(input *GetCloudFrontOriginAccessIdentityConfigInput) (req *request.Request, output *GetCloudFrontOriginAccessIdentityConfigOutput) {
	op := &request.Operation{
		Name:       opGetCloudFrontOriginAccessIdentityConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2016-01-28/origin-access-identity/cloudfront/{Id}/config",
	}

	if input == nil {
		input = &GetCloudFrontOriginAccessIdentityConfigInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetCloudFrontOriginAccessIdentityConfigOutput{}
	req.Data = output
	return
}

// Get the configuration information about an origin access identity.
func (c *CloudFront) GetCloudFrontOriginAccessIdentityConfig(input *GetCloudFrontOriginAccessIdentityConfigInput) (*GetCloudFrontOriginAccessIdentityConfigOutput, error) {
	req, out := c.GetCloudFrontOriginAccessIdentityConfigRequest(input)
	err := req.Send()
	return out, err
}

const opGetDistribution = "GetDistribution2016_01_28"

// GetDistributionRequest generates a request for the GetDistribution operation.
func (c *CloudFront) GetDistributionRequest(input *GetDistributionInput) (req *request.Request, output *GetDistributionOutput) {
	op := &request.Operation{
		Name:       opGetDistribution,
		HTTPMethod: "GET",
		HTTPPath:   "/2016-01-28/distribution/{Id}",
	}

	if input == nil {
		input = &GetDistributionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDistributionOutput{}
	req.Data = output
	return
}

// Get the information about a distribution.
func (c *CloudFront) GetDistribution(input *GetDistributionInput) (*GetDistributionOutput, error) {
	req, out := c.GetDistributionRequest(input)
	err := req.Send()
	return out, err
}

const opGetDistributionConfig = "GetDistributionConfig2016_01_28"

// GetDistributionConfigRequest generates a request for the GetDistributionConfig operation.
func (c *CloudFront) GetDistributionConfigRequest(input *GetDistributionConfigInput) (req *request.Request, output *GetDistributionConfigOutput) {
	op := &request.Operation{
		Name:       opGetDistributionConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2016-01-28/distribution/{Id}/config",
	}

	if input == nil {
		input = &GetDistributionConfigInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDistributionConfigOutput{}
	req.Data = output
	return
}

// Get the configuration information about a distribution.
func (c *CloudFront) GetDistributionConfig(input *GetDistributionConfigInput) (*GetDistributionConfigOutput, error) {
	req, out := c.GetDistributionConfigRequest(input)
	err := req.Send()
	return out, err
}

const opGetInvalidation = "GetInvalidation2016_01_28"

// GetInvalidationRequest generates a request for the GetInvalidation operation.
func (c *CloudFront) GetInvalidationRequest(input *GetInvalidationInput) (req *request.Request, output *GetInvalidationOutput) {
	op := &request.Operation{
		Name:       opGetInvalidation,
		HTTPMethod: "GET",
		HTTPPath:   "/2016-01-28/distribution/{DistributionId}/invalidation/{Id}",
	}

	if input == nil {
		input = &GetInvalidationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetInvalidationOutput{}
	req.Data = output
	return
}

// Get the information about an invalidation.
func (c *CloudFront) GetInvalidation(input *GetInvalidationInput) (*GetInvalidationOutput, error) {
	req, out := c.GetInvalidationRequest(input)
	err := req.Send()
	return out, err
}

const opGetStreamingDistribution = "GetStreamingDistribution2016_01_28"

// GetStreamingDistributionRequest generates a request for the GetStreamingDistribution operation.
func (c *CloudFront) GetStreamingDistributionRequest(input *GetStreamingDistributionInput) (req *request.Request, output *GetStreamingDistributionOutput) {
	op := &request.Operation{
		Name:       opGetStreamingDistribution,
		HTTPMethod: "GET",
		HTTPPath:   "/2016-01-28/streaming-distribution/{Id}",
	}

	if input == nil {
		input = &GetStreamingDistributionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetStreamingDistributionOutput{}
	req.Data = output
	return
}

// Get the information about a streaming distribution.
func (c *CloudFront) GetStreamingDistribution(input *GetStreamingDistributionInput) (*GetStreamingDistributionOutput, error) {
	req, out := c.GetStreamingDistributionRequest(input)
	err := req.Send()
	return out, err
}

const opGetStreamingDistributionConfig = "GetStreamingDistributionConfig2016_01_28"

// GetStreamingDistributionConfigRequest generates a request for the GetStreamingDistributionConfig operation.
func (c *CloudFront) GetStreamingDistributionConfigRequest(input *GetStreamingDistributionConfigInput) (req *request.Request, output *GetStreamingDistributionConfigOutput) {
	op := &request.Operation{
		Name:       opGetStreamingDistributionConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2016-01-28/streaming-distribution/{Id}/config",
	}

	if input == nil {
		input = &GetStreamingDistributionConfigInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetStreamingDistributionConfigOutput{}
	req.Data = output
	return
}

// Get the configuration information about a streaming distribution.
func (c *CloudFront) GetStreamingDistributionConfig(input *GetStreamingDistributionConfigInput) (*GetStreamingDistributionConfigOutput, error) {
	req, out := c.GetStreamingDistributionConfigRequest(input)
	err := req.Send()
	return out, err
}

const opListCloudFrontOriginAccessIdentities = "ListCloudFrontOriginAccessIdentities2016_01_28"

// ListCloudFrontOriginAccessIdentitiesRequest generates a request for the ListCloudFrontOriginAccessIdentities operation.
func (c *CloudFront) ListCloudFrontOriginAccessIdentitiesRequest(input *ListCloudFrontOriginAccessIdentitiesInput) (req *request.Request, output *ListCloudFrontOriginAccessIdentitiesOutput) {
	op := &request.Operation{
		Name:       opListCloudFrontOriginAccessIdentities,
		HTTPMethod: "GET",
		HTTPPath:   "/2016-01-28/origin-access-identity/cloudfront",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"CloudFrontOriginAccessIdentityList.NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "CloudFrontOriginAccessIdentityList.IsTruncated",
		},
	}

	if input == nil {
		input = &ListCloudFrontOriginAccessIdentitiesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListCloudFrontOriginAccessIdentitiesOutput{}
	req.Data = output
	return
}

// List origin access identities.
func (c *CloudFront) ListCloudFrontOriginAccessIdentities(input *ListCloudFrontOriginAccessIdentitiesInput) (*ListCloudFrontOriginAccessIdentitiesOutput, error) {
	req, out := c.ListCloudFrontOriginAccessIdentitiesRequest(input)
	err := req.Send()
	return out, err
}

func (c *CloudFront) ListCloudFrontOriginAccessIdentitiesPages(input *ListCloudFrontOriginAccessIdentitiesInput, fn func(p *ListCloudFrontOriginAccessIdentitiesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListCloudFrontOriginAccessIdentitiesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListCloudFrontOriginAccessIdentitiesOutput), lastPage)
	})
}

const opListDistributions = "ListDistributions2016_01_28"

// ListDistributionsRequest generates a request for the ListDistributions operation.
func (c *CloudFront) ListDistributionsRequest(input *ListDistributionsInput) (req *request.Request, output *ListDistributionsOutput) {
	op := &request.Operation{
		Name:       opListDistributions,
		HTTPMethod: "GET",
		HTTPPath:   "/2016-01-28/distribution",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"DistributionList.NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "DistributionList.IsTruncated",
		},
	}

	if input == nil {
		input = &ListDistributionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDistributionsOutput{}
	req.Data = output
	return
}

// List distributions.
func (c *CloudFront) ListDistributions(input *ListDistributionsInput) (*ListDistributionsOutput, error) {
	req, out := c.ListDistributionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *CloudFront) ListDistributionsPages(input *ListDistributionsInput, fn func(p *ListDistributionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDistributionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDistributionsOutput), lastPage)
	})
}

const opListDistributionsByWebACLId = "ListDistributionsByWebACLId2016_01_28"

// ListDistributionsByWebACLIdRequest generates a request for the ListDistributionsByWebACLId operation.
func (c *CloudFront) ListDistributionsByWebACLIdRequest(input *ListDistributionsByWebACLIdInput) (req *request.Request, output *ListDistributionsByWebACLIdOutput) {
	op := &request.Operation{
		Name:       opListDistributionsByWebACLId,
		HTTPMethod: "GET",
		HTTPPath:   "/2016-01-28/distributionsByWebACLId/{WebACLId}",
	}

	if input == nil {
		input = &ListDistributionsByWebACLIdInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDistributionsByWebACLIdOutput{}
	req.Data = output
	return
}

// List the distributions that are associated with a specified AWS WAF web ACL.
func (c *CloudFront) ListDistributionsByWebACLId(input *ListDistributionsByWebACLIdInput) (*ListDistributionsByWebACLIdOutput, error) {
	req, out := c.ListDistributionsByWebACLIdRequest(input)
	err := req.Send()
	return out, err
}

const opListInvalidations = "ListInvalidations2016_01_28"

// ListInvalidationsRequest generates a request for the ListInvalidations operation.
func (c *CloudFront) ListInvalidationsRequest(input *ListInvalidationsInput) (req *request.Request, output *ListInvalidationsOutput) {
	op := &request.Operation{
		Name:       opListInvalidations,
		HTTPMethod: "GET",
		HTTPPath:   "/2016-01-28/distribution/{DistributionId}/invalidation",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"InvalidationList.NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "InvalidationList.IsTruncated",
		},
	}

	if input == nil {
		input = &ListInvalidationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListInvalidationsOutput{}
	req.Data = output
	return
}

// List invalidation batches.
func (c *CloudFront) ListInvalidations(input *ListInvalidationsInput) (*ListInvalidationsOutput, error) {
	req, out := c.ListInvalidationsRequest(input)
	err := req.Send()
	return out, err
}

func (c *CloudFront) ListInvalidationsPages(input *ListInvalidationsInput, fn func(p *ListInvalidationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListInvalidationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListInvalidationsOutput), lastPage)
	})
}

const opListStreamingDistributions = "ListStreamingDistributions2016_01_28"

// ListStreamingDistributionsRequest generates a request for the ListStreamingDistributions operation.
func (c *CloudFront) ListStreamingDistributionsRequest(input *ListStreamingDistributionsInput) (req *request.Request, output *ListStreamingDistributionsOutput) {
	op := &request.Operation{
		Name:       opListStreamingDistributions,
		HTTPMethod: "GET",
		HTTPPath:   "/2016-01-28/streaming-distribution",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"StreamingDistributionList.NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "StreamingDistributionList.IsTruncated",
		},
	}

	if input == nil {
		input = &ListStreamingDistributionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListStreamingDistributionsOutput{}
	req.Data = output
	return
}

// List streaming distributions.
func (c *CloudFront) ListStreamingDistributions(input *ListStreamingDistributionsInput) (*ListStreamingDistributionsOutput, error) {
	req, out := c.ListStreamingDistributionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *CloudFront) ListStreamingDistributionsPages(input *ListStreamingDistributionsInput, fn func(p *ListStreamingDistributionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListStreamingDistributionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListStreamingDistributionsOutput), lastPage)
	})
}

const opUpdateCloudFrontOriginAccessIdentity = "UpdateCloudFrontOriginAccessIdentity2016_01_28"

// UpdateCloudFrontOriginAccessIdentityRequest generates a request for the UpdateCloudFrontOriginAccessIdentity operation.
func (c *CloudFront) UpdateCloudFrontOriginAccessIdentityRequest(input *UpdateCloudFrontOriginAccessIdentityInput) (req *request.Request, output *UpdateCloudFrontOriginAccessIdentityOutput) {
	op := &request.Operation{
		Name:       opUpdateCloudFrontOriginAccessIdentity,
		HTTPMethod: "PUT",
		HTTPPath:   "/2016-01-28/origin-access-identity/cloudfront/{Id}/config",
	}

	if input == nil {
		input = &UpdateCloudFrontOriginAccessIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateCloudFrontOriginAccessIdentityOutput{}
	req.Data = output
	return
}

// Update an origin access identity.
func (c *CloudFront) UpdateCloudFrontOriginAccessIdentity(input *UpdateCloudFrontOriginAccessIdentityInput) (*UpdateCloudFrontOriginAccessIdentityOutput, error) {
	req, out := c.UpdateCloudFrontOriginAccessIdentityRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateDistribution = "UpdateDistribution2016_01_28"

// UpdateDistributionRequest generates a request for the UpdateDistribution operation.
func (c *CloudFront) UpdateDistributionRequest(input *UpdateDistributionInput) (req *request.Request, output *UpdateDistributionOutput) {
	op := &request.Operation{
		Name:       opUpdateDistribution,
		HTTPMethod: "PUT",
		HTTPPath:   "/2016-01-28/distribution/{Id}/config",
	}

	if input == nil {
		input = &UpdateDistributionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateDistributionOutput{}
	req.Data = output
	return
}

// Update a distribution.
func (c *CloudFront) UpdateDistribution(input *UpdateDistributionInput) (*UpdateDistributionOutput, error) {
	req, out := c.UpdateDistributionRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateStreamingDistribution = "UpdateStreamingDistribution2016_01_28"

// UpdateStreamingDistributionRequest generates a request for the UpdateStreamingDistribution operation.
func (c *CloudFront) UpdateStreamingDistributionRequest(input *UpdateStreamingDistributionInput) (req *request.Request, output *UpdateStreamingDistributionOutput) {
	op := &request.Operation{
		Name:       opUpdateStreamingDistribution,
		HTTPMethod: "PUT",
		HTTPPath:   "/2016-01-28/streaming-distribution/{Id}/config",
	}

	if input == nil {
		input = &UpdateStreamingDistributionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateStreamingDistributionOutput{}
	req.Data = output
	return
}

// Update a streaming distribution.
func (c *CloudFront) UpdateStreamingDistribution(input *UpdateStreamingDistributionInput) (*UpdateStreamingDistributionOutput, error) {
	req, out := c.UpdateStreamingDistributionRequest(input)
	err := req.Send()
	return out, err
}

// A complex type that lists the AWS accounts, if any, that you included in
// the TrustedSigners complex type for the default cache behavior or for any
// of the other cache behaviors for this distribution. These are accounts that
// you want to allow to create signed URLs for private content.
type ActiveTrustedSigners struct {
	_ struct{} `type:"structure"`

	// Each active trusted signer.
	Enabled *bool `type:"boolean" required:"true"`

	// A complex type that contains one Signer complex type for each unique trusted
	// signer that is specified in the TrustedSigners complex type, including trusted
	// signers in the default cache behavior and in all of the other cache behaviors.
	Items []*Signer `locationNameList:"Signer" type:"list"`

	// The number of unique trusted signers included in all cache behaviors. For
	// example, if three cache behaviors all list the same three AWS accounts, the
	// value of Quantity for ActiveTrustedSigners will be 3.
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s ActiveTrustedSigners) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActiveTrustedSigners) GoString() string {
	return s.String()
}

// A complex type that contains information about CNAMEs (alternate domain names),
// if any, for this distribution.
type Aliases struct {
	_ struct{} `type:"structure"`

	// Optional: A complex type that contains CNAME elements, if any, for this distribution.
	// If Quantity is 0, you can omit Items.
	Items []*string `locationNameList:"CNAME" type:"list"`

	// The number of CNAMEs, if any, for this distribution.
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Aliases) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Aliases) GoString() string {
	return s.String()
}

// A complex type that controls which HTTP methods CloudFront processes and
// forwards to your Amazon S3 bucket or your custom origin. There are three
// choices: - CloudFront forwards only GET and HEAD requests. - CloudFront forwards
// only GET, HEAD and OPTIONS requests. - CloudFront forwards GET, HEAD, OPTIONS,
// PUT, PATCH, POST, and DELETE requests. If you pick the third choice, you
// may need to restrict access to your Amazon S3 bucket or to your custom origin
// so users can't perform operations that you don't want them to. For example,
// you may not want users to have permission to delete objects from your origin.
type AllowedMethods struct {
	_ struct{} `type:"structure"`

	// A complex type that controls whether CloudFront caches the response to requests
	// using the specified HTTP methods. There are two choices: - CloudFront caches
	// responses to GET and HEAD requests. - CloudFront caches responses to GET,
	// HEAD, and OPTIONS requests. If you pick the second choice for your S3 Origin,
	// you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers
	// and Origin headers for the responses to be cached correctly.
	CachedMethods *CachedMethods `type:"structure"`

	// A complex type that contains the HTTP methods that you want CloudFront to
	// process and forward to your origin.
	Items []*string `locationNameList:"Method" type:"list" required:"true"`

	// The number of HTTP methods that you want CloudFront to forward to your origin.
	// Valid values are 2 (for GET and HEAD requests), 3 (for GET, HEAD and OPTIONS
	// requests) and 7 (for GET, HEAD, OPTIONS, PUT, PATCH, POST, and DELETE requests).
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s AllowedMethods) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllowedMethods) GoString() string {
	return s.String()
}

// A complex type that describes how CloudFront processes requests. You can
// create up to 10 cache behaviors.You must create at least as many cache behaviors
// (including the default cache behavior) as you have origins if you want CloudFront
// to distribute objects from all of the origins. Each cache behavior specifies
// the one origin from which you want CloudFront to get objects. If you have
// two origins and only the default cache behavior, the default cache behavior
// will cause CloudFront to get objects from one of the origins, but the other
// origin will never be used. If you don't want to specify any cache behaviors,
// include only an empty CacheBehaviors element. Don't include an empty CacheBehavior
// element, or CloudFront returns a MalformedXML error. To delete all cache
// behaviors in an existing distribution, update the distribution configuration
// and include only an empty CacheBehaviors element. To add, change, or remove
// one or more cache behaviors, update the distribution configuration and specify
// all of the cache behaviors that you want to include in the updated distribution.
type CacheBehavior struct {
	_ struct{} `type:"structure"`

	// A complex type that controls which HTTP methods CloudFront processes and
	// forwards to your Amazon S3 bucket or your custom origin. There are three
	// choices: - CloudFront forwards only GET and HEAD requests. - CloudFront forwards
	// only GET, HEAD and OPTIONS requests. - CloudFront forwards GET, HEAD, OPTIONS,
	// PUT, PATCH, POST, and DELETE requests. If you pick the third choice, you
	// may need to restrict access to your Amazon S3 bucket or to your custom origin
	// so users can't perform operations that you don't want them to. For example,
	// you may not want users to have permission to delete objects from your origin.
	AllowedMethods *AllowedMethods `type:"structure"`

	// Whether you want CloudFront to automatically compress content for web requests
	// that include Accept-Encoding: gzip in the request header. If so, specify
	// true; if not, specify false. CloudFront compresses files larger than 1000
	// bytes and less than 1 megabyte for both Amazon S3 and custom origins. When
	// a CloudFront edge location is unusually busy, some files might not be compressed.
	// The value of the Content-Type header must be on the list of file types that
	// CloudFront will compress. For the current list, see Serving Compressed Content
	// (http://docs.aws.amazon.com/console/cloudfront/compressed-content) in the
	// Amazon CloudFront Developer Guide. If you configure CloudFront to compress
	// content, CloudFront removes the ETag response header from the objects that
	// it compresses. The ETag header indicates that the version in a CloudFront
	// edge cache is identical to the version on the origin server, but after compression
	// the two versions are no longer identical. As a result, for compressed objects,
	// CloudFront can't use the ETag header to determine whether an expired object
	// in the CloudFront edge cache is still the latest version.
	Compress *bool `type:"boolean"`

	// If you don't configure your origin to add a Cache-Control max-age directive
	// or an Expires header, DefaultTTL is the default amount of time (in seconds)
	// that an object is in a CloudFront cache before CloudFront forwards another
	// request to your origin to determine whether the object has been updated.
	// The value that you specify applies only when your origin does not add HTTP
	// headers such as Cache-Control max-age, Cache-Control s-maxage, and Expires
	// to objects. You can specify a value from 0 to 3,153,600,000 seconds (100
	// years).
	DefaultTTL *int64 `type:"long"`

	// A complex type that specifies how CloudFront handles query strings, cookies
	// and headers.
	ForwardedValues *ForwardedValues `type:"structure" required:"true"`

	// The maximum amount of time (in seconds) that an object is in a CloudFront
	// cache before CloudFront forwards another request to your origin to determine
	// whether the object has been updated. The value that you specify applies only
	// when your origin adds HTTP headers such as Cache-Control max-age, Cache-Control
	// s-maxage, and Expires to objects. You can specify a value from 0 to 3,153,600,000
	// seconds (100 years).
	MaxTTL *int64 `type:"long"`

	// The minimum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront queries your origin to see whether the object has been
	// updated.You can specify a value from 0 to 3,153,600,000 seconds (100 years).
	MinTTL *int64 `type:"long" required:"true"`

	// The pattern (for example, images/*.jpg) that specifies which requests you
	// want this cache behavior to apply to. When CloudFront receives an end-user
	// request, the requested path is compared with path patterns in the order in
	// which cache behaviors are listed in the distribution. The path pattern for
	// the default cache behavior is * and cannot be changed. If the request for
	// an object does not match the path pattern for any cache behaviors, CloudFront
	// applies the behavior in the default cache behavior.
	PathPattern *string `type:"string" required:"true"`

	// Indicates whether you want to distribute media files in Microsoft Smooth
	// Streaming format using the origin that is associated with this cache behavior.
	// If so, specify true; if not, specify false.
	SmoothStreaming *bool `type:"boolean"`

	// The value of ID for the origin that you want CloudFront to route requests
	// to when a request matches the path pattern either for a cache behavior or
	// for the default cache behavior.
	TargetOriginId *string `type:"string" required:"true"`

	// A complex type that specifies the AWS accounts, if any, that you want to
	// allow to create signed URLs for private content. If you want to require signed
	// URLs in requests for objects in the target origin that match the PathPattern
	// for this cache behavior, specify true for Enabled, and specify the applicable
	// values for Quantity and Items. For more information, go to Using a Signed
	// URL to Serve Private Content in the Amazon CloudFront Developer Guide. If
	// you don't want to require signed URLs in requests for objects that match
	// PathPattern, specify false for Enabled and 0 for Quantity. Omit Items. To
	// add, change, or remove one or more trusted signers, change Enabled to true
	// (if it's currently false), change Quantity as applicable, and specify all
	// of the trusted signers that you want to include in the updated distribution.
	TrustedSigners *TrustedSigners `type:"structure" required:"true"`

	// Use this element to specify the protocol that users can use to access the
	// files in the origin specified by TargetOriginId when a request matches the
	// path pattern in PathPattern. If you want CloudFront to allow end users to
	// use any available protocol, specify allow-all. If you want CloudFront to
	// require HTTPS, specify https. If you want CloudFront to respond to an HTTP
	// request with an HTTP status code of 301 (Moved Permanently) and the HTTPS
	// URL, specify redirect-to-https. The viewer then resubmits the request using
	// the HTTPS URL.
	ViewerProtocolPolicy *string `type:"string" required:"true" enum:"ViewerProtocolPolicy"`
}

// String returns the string representation
func (s CacheBehavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheBehavior) GoString() string {
	return s.String()
}

// A complex type that contains zero or more CacheBehavior elements.
type CacheBehaviors struct {
	_ struct{} `type:"structure"`

	// Optional: A complex type that contains cache behaviors for this distribution.
	// If Quantity is 0, you can omit Items.
	Items []*CacheBehavior `locationNameList:"CacheBehavior" type:"list"`

	// The number of cache behaviors for this distribution.
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CacheBehaviors) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheBehaviors) GoString() string {
	return s.String()
}

// A complex type that controls whether CloudFront caches the response to requests
// using the specified HTTP methods. There are two choices: - CloudFront caches
// responses to GET and HEAD requests. - CloudFront caches responses to GET,
// HEAD, and OPTIONS requests. If you pick the second choice for your S3 Origin,
// you may need to forward Access-Control-Request-Method, Access-Control-Request-Headers
// and Origin headers for the responses to be cached correctly.
type CachedMethods struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the HTTP methods that you want CloudFront to
	// cache responses to.
	Items []*string `locationNameList:"Method" type:"list" required:"true"`

	// The number of HTTP methods for which you want CloudFront to cache responses.
	// Valid values are 2 (for caching responses to GET and HEAD requests) and 3
	// (for caching responses to GET, HEAD, and OPTIONS requests).
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CachedMethods) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CachedMethods) GoString() string {
	return s.String()
}

// A complex type that specifies the whitelisted cookies, if any, that you want
// CloudFront to forward to your origin that is associated with this cache behavior.
type CookieNames struct {
	_ struct{} `type:"structure"`

	// Optional: A complex type that contains whitelisted cookies for this cache
	// behavior. If Quantity is 0, you can omit Items.
	Items []*string `locationNameList:"Name" type:"list"`

	// The number of whitelisted cookies for this cache behavior.
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CookieNames) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CookieNames) GoString() string {
	return s.String()
}

// A complex type that specifies the cookie preferences associated with this
// cache behavior.
type CookiePreference struct {
	_ struct{} `type:"structure"`

	// Use this element to specify whether you want CloudFront to forward cookies
	// to the origin that is associated with this cache behavior. You can specify
	// all, none or whitelist. If you choose All, CloudFront forwards all cookies
	// regardless of how many your application uses.
	Forward *string `type:"string" required:"true" enum:"ItemSelection"`

	// A complex type that specifies the whitelisted cookies, if any, that you want
	// CloudFront to forward to your origin that is associated with this cache behavior.
	WhitelistedNames *CookieNames `type:"structure"`
}

// String returns the string representation
func (s CookiePreference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CookiePreference) GoString() string {
	return s.String()
}

// The request to create a new origin access identity.
type CreateCloudFrontOriginAccessIdentityInput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentityConfig"`

	// The origin access identity's configuration information.
	CloudFrontOriginAccessIdentityConfig *OriginAccessIdentityConfig `locationName:"CloudFrontOriginAccessIdentityConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateCloudFrontOriginAccessIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCloudFrontOriginAccessIdentityInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type CreateCloudFrontOriginAccessIdentityOutput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentity"`

	// The origin access identity's information.
	CloudFrontOriginAccessIdentity *OriginAccessIdentity `type:"structure"`

	// The current version of the origin access identity created.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the new origin access identity just created. For
	// example: https://cloudfront.amazonaws.com/2010-11-01/origin-access-identity/cloudfront/E74FTE3AJFJ256A.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateCloudFrontOriginAccessIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCloudFrontOriginAccessIdentityOutput) GoString() string {
	return s.String()
}

// The request to create a new distribution.
type CreateDistributionInput struct {
	_ struct{} `type:"structure" payload:"DistributionConfig"`

	// The distribution's configuration information.
	DistributionConfig *DistributionConfig `locationName:"DistributionConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDistributionInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type CreateDistributionOutput struct {
	_ struct{} `type:"structure" payload:"Distribution"`

	// The distribution's information.
	Distribution *Distribution `type:"structure"`

	// The current version of the distribution created.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the new distribution resource just created. For
	// example: https://cloudfront.amazonaws.com/2010-11-01/distribution/EDFDVBD632BHDS5.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDistributionOutput) GoString() string {
	return s.String()
}

// The request to create an invalidation.
type CreateInvalidationInput struct {
	_ struct{} `type:"structure" payload:"InvalidationBatch"`

	// The distribution's id.
	DistributionId *string `location:"uri" locationName:"DistributionId" type:"string" required:"true"`

	// The batch information for the invalidation.
	InvalidationBatch *InvalidationBatch `locationName:"InvalidationBatch" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateInvalidationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInvalidationInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type CreateInvalidationOutput struct {
	_ struct{} `type:"structure" payload:"Invalidation"`

	// The invalidation's information.
	Invalidation *Invalidation `type:"structure"`

	// The fully qualified URI of the distribution and invalidation batch request,
	// including the Invalidation ID.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CreateInvalidationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInvalidationOutput) GoString() string {
	return s.String()
}

// The request to create a new streaming distribution.
type CreateStreamingDistributionInput struct {
	_ struct{} `type:"structure" payload:"StreamingDistributionConfig"`

	// The streaming distribution's configuration information.
	StreamingDistributionConfig *StreamingDistributionConfig `locationName:"StreamingDistributionConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateStreamingDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamingDistributionInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type CreateStreamingDistributionOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistribution"`

	// The current version of the streaming distribution created.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The fully qualified URI of the new streaming distribution resource just created.
	// For example: https://cloudfront.amazonaws.com/2010-11-01/streaming-distribution/EGTXBD79H29TRA8.
	Location *string `location:"header" locationName:"Location" type:"string"`

	// The streaming distribution's information.
	StreamingDistribution *StreamingDistribution `type:"structure"`
}

// String returns the string representation
func (s CreateStreamingDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamingDistributionOutput) GoString() string {
	return s.String()
}

// A complex type that describes how you'd prefer CloudFront to respond to requests
// that result in either a 4xx or 5xx response. You can control whether a custom
// error page should be displayed, what the desired response code should be
// for this error page and how long should the error response be cached by CloudFront.
// If you don't want to specify any custom error responses, include only an
// empty CustomErrorResponses element. To delete all custom error responses
// in an existing distribution, update the distribution configuration and include
// only an empty CustomErrorResponses element. To add, change, or remove one
// or more custom error responses, update the distribution configuration and
// specify all of the custom error responses that you want to include in the
// updated distribution.
type CustomErrorResponse struct {
	_ struct{} `type:"structure"`

	// The minimum amount of time you want HTTP error codes to stay in CloudFront
	// caches before CloudFront queries your origin to see whether the object has
	// been updated. You can specify a value from 0 to 31,536,000.
	ErrorCachingMinTTL *int64 `type:"long"`

	// The 4xx or 5xx HTTP status code that you want to customize. For a list of
	// HTTP status codes that you can customize, see CloudFront documentation.
	ErrorCode *int64 `type:"integer" required:"true"`

	// The HTTP status code that you want CloudFront to return with the custom error
	// page to the viewer. For a list of HTTP status codes that you can replace,
	// see CloudFront Documentation.
	ResponseCode *string `type:"string"`

	// The path of the custom error page (for example, /custom_404.html). The path
	// is relative to the distribution and must begin with a slash (/). If the path
	// includes any non-ASCII characters or unsafe characters as defined in RFC
	// 1783 (http://www.ietf.org/rfc/rfc1738.txt), URL encode those characters.
	// Do not URL encode any other characters in the path, or CloudFront will not
	// return the custom error page to the viewer.
	ResponsePagePath *string `type:"string"`
}

// String returns the string representation
func (s CustomErrorResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomErrorResponse) GoString() string {
	return s.String()
}

// A complex type that contains zero or more CustomErrorResponse elements.
type CustomErrorResponses struct {
	_ struct{} `type:"structure"`

	// Optional: A complex type that contains custom error responses for this distribution.
	// If Quantity is 0, you can omit Items.
	Items []*CustomErrorResponse `locationNameList:"CustomErrorResponse" type:"list"`

	// The number of custom error responses for this distribution.
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CustomErrorResponses) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomErrorResponses) GoString() string {
	return s.String()
}

// A complex type that contains the list of Custom Headers for each origin.
type CustomHeaders struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the custom headers for this Origin.
	Items []*OriginCustomHeader `locationNameList:"OriginCustomHeader" type:"list"`

	// The number of custom headers for this origin.
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s CustomHeaders) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomHeaders) GoString() string {
	return s.String()
}

// A customer origin.
type CustomOriginConfig struct {
	_ struct{} `type:"structure"`

	// The HTTP port the custom origin listens on.
	HTTPPort *int64 `type:"integer" required:"true"`

	// The HTTPS port the custom origin listens on.
	HTTPSPort *int64 `type:"integer" required:"true"`

	// The origin protocol policy to apply to your origin.
	OriginProtocolPolicy *string `type:"string" required:"true" enum:"OriginProtocolPolicy"`

	// The SSL/TLS protocols that you want CloudFront to use when communicating
	// with your origin over HTTPS.
	OriginSslProtocols *OriginSslProtocols `type:"structure"`
}

// String returns the string representation
func (s CustomOriginConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomOriginConfig) GoString() string {
	return s.String()
}

// A complex type that describes the default cache behavior if you do not specify
// a CacheBehavior element or if files don't match any of the values of PathPattern
// in CacheBehavior elements.You must create exactly one default cache behavior.
type DefaultCacheBehavior struct {
	_ struct{} `type:"structure"`

	// A complex type that controls which HTTP methods CloudFront processes and
	// forwards to your Amazon S3 bucket or your custom origin. There are three
	// choices: - CloudFront forwards only GET and HEAD requests. - CloudFront forwards
	// only GET, HEAD and OPTIONS requests. - CloudFront forwards GET, HEAD, OPTIONS,
	// PUT, PATCH, POST, and DELETE requests. If you pick the third choice, you
	// may need to restrict access to your Amazon S3 bucket or to your custom origin
	// so users can't perform operations that you don't want them to. For example,
	// you may not want users to have permission to delete objects from your origin.
	AllowedMethods *AllowedMethods `type:"structure"`

	// Whether you want CloudFront to automatically compress content for web requests
	// that include Accept-Encoding: gzip in the request header. If so, specify
	// true; if not, specify false. CloudFront compresses files larger than 1000
	// bytes and less than 1 megabyte for both Amazon S3 and custom origins. When
	// a CloudFront edge location is unusually busy, some files might not be compressed.
	// The value of the Content-Type header must be on the list of file types that
	// CloudFront will compress. For the current list, see Serving Compressed Content
	// (http://docs.aws.amazon.com/console/cloudfront/compressed-content) in the
	// Amazon CloudFront Developer Guide. If you configure CloudFront to compress
	// content, CloudFront removes the ETag response header from the objects that
	// it compresses. The ETag header indicates that the version in a CloudFront
	// edge cache is identical to the version on the origin server, but after compression
	// the two versions are no longer identical. As a result, for compressed objects,
	// CloudFront can't use the ETag header to determine whether an expired object
	// in the CloudFront edge cache is still the latest version.
	Compress *bool `type:"boolean"`

	// If you don't configure your origin to add a Cache-Control max-age directive
	// or an Expires header, DefaultTTL is the default amount of time (in seconds)
	// that an object is in a CloudFront cache before CloudFront forwards another
	// request to your origin to determine whether the object has been updated.
	// The value that you specify applies only when your origin does not add HTTP
	// headers such as Cache-Control max-age, Cache-Control s-maxage, and Expires
	// to objects. You can specify a value from 0 to 3,153,600,000 seconds (100
	// years).
	DefaultTTL *int64 `type:"long"`

	// A complex type that specifies how CloudFront handles query strings, cookies
	// and headers.
	ForwardedValues *ForwardedValues `type:"structure" required:"true"`

	// The maximum amount of time (in seconds) that an object is in a CloudFront
	// cache before CloudFront forwards another request to your origin to determine
	// whether the object has been updated. The value that you specify applies only
	// when your origin adds HTTP headers such as Cache-Control max-age, Cache-Control
	// s-maxage, and Expires to objects. You can specify a value from 0 to 3,153,600,000
	// seconds (100 years).
	MaxTTL *int64 `type:"long"`

	// The minimum amount of time that you want objects to stay in CloudFront caches
	// before CloudFront queries your origin to see whether the object has been
	// updated.You can specify a value from 0 to 3,153,600,000 seconds (100 years).
	MinTTL *int64 `type:"long" required:"true"`

	// Indicates whether you want to distribute media files in Microsoft Smooth
	// Streaming format using the origin that is associated with this cache behavior.
	// If so, specify true; if not, specify false.
	SmoothStreaming *bool `type:"boolean"`

	// The value of ID for the origin that you want CloudFront to route requests
	// to when a request matches the path pattern either for a cache behavior or
	// for the default cache behavior.
	TargetOriginId *string `type:"string" required:"true"`

	// A complex type that specifies the AWS accounts, if any, that you want to
	// allow to create signed URLs for private content. If you want to require signed
	// URLs in requests for objects in the target origin that match the PathPattern
	// for this cache behavior, specify true for Enabled, and specify the applicable
	// values for Quantity and Items. For more information, go to Using a Signed
	// URL to Serve Private Content in the Amazon CloudFront Developer Guide. If
	// you don't want to require signed URLs in requests for objects that match
	// PathPattern, specify false for Enabled and 0 for Quantity. Omit Items. To
	// add, change, or remove one or more trusted signers, change Enabled to true
	// (if it's currently false), change Quantity as applicable, and specify all
	// of the trusted signers that you want to include in the updated distribution.
	TrustedSigners *TrustedSigners `type:"structure" required:"true"`

	// Use this element to specify the protocol that users can use to access the
	// files in the origin specified by TargetOriginId when a request matches the
	// path pattern in PathPattern. If you want CloudFront to allow end users to
	// use any available protocol, specify allow-all. If you want CloudFront to
	// require HTTPS, specify https. If you want CloudFront to respond to an HTTP
	// request with an HTTP status code of 301 (Moved Permanently) and the HTTPS
	// URL, specify redirect-to-https. The viewer then resubmits the request using
	// the HTTPS URL.
	ViewerProtocolPolicy *string `type:"string" required:"true" enum:"ViewerProtocolPolicy"`
}

// String returns the string representation
func (s DefaultCacheBehavior) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultCacheBehavior) GoString() string {
	return s.String()
}

// The request to delete a origin access identity.
type DeleteCloudFrontOriginAccessIdentityInput struct {
	_ struct{} `type:"structure"`

	// The origin access identity's id.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header you received from a previous GET or PUT request.
	// For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteCloudFrontOriginAccessIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCloudFrontOriginAccessIdentityInput) GoString() string {
	return s.String()
}

type DeleteCloudFrontOriginAccessIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCloudFrontOriginAccessIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCloudFrontOriginAccessIdentityOutput) GoString() string {
	return s.String()
}

// The request to delete a distribution.
type DeleteDistributionInput struct {
	_ struct{} `type:"structure"`

	// The distribution id.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header you received when you disabled the distribution.
	// For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDistributionInput) GoString() string {
	return s.String()
}

type DeleteDistributionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDistributionOutput) GoString() string {
	return s.String()
}

// The request to delete a streaming distribution.
type DeleteStreamingDistributionInput struct {
	_ struct{} `type:"structure"`

	// The distribution id.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header you received when you disabled the streaming
	// distribution. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s DeleteStreamingDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStreamingDistributionInput) GoString() string {
	return s.String()
}

type DeleteStreamingDistributionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStreamingDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStreamingDistributionOutput) GoString() string {
	return s.String()
}

// A distribution.
type Distribution struct {
	_ struct{} `type:"structure"`

	// CloudFront automatically adds this element to the response only if you've
	// set up the distribution to serve private content with signed URLs. The element
	// lists the key pair IDs that CloudFront is aware of for each trusted signer.
	// The Signer child element lists the AWS account number of the trusted signer
	// (or an empty Self element if the signer is you). The Signer element also
	// includes the IDs of any active key pairs associated with the trusted signer's
	// AWS account. If no KeyPairId element appears for a Signer, that signer can't
	// create working signed URLs.
	ActiveTrustedSigners *ActiveTrustedSigners `type:"structure" required:"true"`

	// The current configuration information for the distribution.
	DistributionConfig *DistributionConfig `type:"structure" required:"true"`

	// The domain name corresponding to the distribution. For example: d604721fxaaqy9.cloudfront.net.
	DomainName *string `type:"string" required:"true"`

	// The identifier for the distribution. For example: EDFDVBD632BHDS5.
	Id *string `type:"string" required:"true"`

	// The number of invalidation batches currently in progress.
	InProgressInvalidationBatches *int64 `type:"integer" required:"true"`

	// The date and time the distribution was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// This response element indicates the current status of the distribution. When
	// the status is Deployed, the distribution's information is fully propagated
	// throughout the Amazon CloudFront system.
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Distribution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Distribution) GoString() string {
	return s.String()
}

// A distribution Configuration.
type DistributionConfig struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this distribution.
	Aliases *Aliases `type:"structure"`

	// A complex type that contains zero or more CacheBehavior elements.
	CacheBehaviors *CacheBehaviors `type:"structure"`

	// A unique number that ensures the request can't be replayed. If the CallerReference
	// is new (no matter the content of the DistributionConfig object), a new distribution
	// is created. If the CallerReference is a value you already sent in a previous
	// request to create a distribution, and the content of the DistributionConfig
	// is identical to the original request (ignoring white space), the response
	// includes the same information returned to the original request. If the CallerReference
	// is a value you already sent in a previous request to create a distribution
	// but the content of the DistributionConfig is different from the original
	// request, CloudFront returns a DistributionAlreadyExists error.
	CallerReference *string `type:"string" required:"true"`

	// Any comments you want to include about the distribution.
	Comment *string `type:"string" required:"true"`

	// A complex type that contains zero or more CustomErrorResponse elements.
	CustomErrorResponses *CustomErrorResponses `type:"structure"`

	// A complex type that describes the default cache behavior if you do not specify
	// a CacheBehavior element or if files don't match any of the values of PathPattern
	// in CacheBehavior elements.You must create exactly one default cache behavior.
	DefaultCacheBehavior *DefaultCacheBehavior `type:"structure" required:"true"`

	// The object that you want CloudFront to return (for example, index.html) when
	// an end user requests the root URL for your distribution (http://www.example.com)
	// instead of an object in your distribution (http://www.example.com/index.html).
	// Specifying a default root object avoids exposing the contents of your distribution.
	// If you don't want to specify a default root object when you create a distribution,
	// include an empty DefaultRootObject element. To delete the default root object
	// from an existing distribution, update the distribution configuration and
	// include an empty DefaultRootObject element. To replace the default root object,
	// update the distribution configuration and specify the new object.
	DefaultRootObject *string `type:"string"`

	// Whether the distribution is enabled to accept end user requests for content.
	Enabled *bool `type:"boolean" required:"true"`

	// A complex type that controls whether access logs are written for the distribution.
	Logging *LoggingConfig `type:"structure"`

	// A complex type that contains information about origins for this distribution.
	Origins *Origins `type:"structure" required:"true"`

	// A complex type that contains information about price class for this distribution.
	PriceClass *string `type:"string" enum:"PriceClass"`

	// A complex type that identifies ways in which you want to restrict distribution
	// of your content.
	Restrictions *Restrictions `type:"structure"`

	// A complex type that contains information about viewer certificates for this
	// distribution.
	ViewerCertificate *ViewerCertificate `type:"structure"`

	// (Optional) If you're using AWS WAF to filter CloudFront requests, the Id
	// of the AWS WAF web ACL that is associated with the distribution.
	WebACLId *string `type:"string"`
}

// String returns the string representation
func (s DistributionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DistributionConfig) GoString() string {
	return s.String()
}

// A distribution list.
type DistributionList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more distributions remain to be listed. If
	// your results were truncated, you can make a follow-up pagination request
	// using the Marker request parameter to retrieve more distributions in the
	// list.
	IsTruncated *bool `type:"boolean" required:"true"`

	// A complex type that contains one DistributionSummary element for each distribution
	// that was created by the current AWS account.
	Items []*DistributionSummary `locationNameList:"DistributionSummary" type:"list"`

	// The value you provided for the Marker request parameter.
	Marker *string `type:"string" required:"true"`

	// The value you provided for the MaxItems request parameter.
	MaxItems *int64 `type:"integer" required:"true"`

	// If IsTruncated is true, this element is present and contains the value you
	// can use for the Marker request parameter to continue listing your distributions
	// where they left off.
	NextMarker *string `type:"string"`

	// The number of distributions that were created by the current AWS account.
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s DistributionList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DistributionList) GoString() string {
	return s.String()
}

// A summary of the information for an Amazon CloudFront distribution.
type DistributionSummary struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this distribution.
	Aliases *Aliases `type:"structure" required:"true"`

	// A complex type that contains zero or more CacheBehavior elements.
	CacheBehaviors *CacheBehaviors `type:"structure" required:"true"`

	// The comment originally specified when this distribution was created.
	Comment *string `type:"string" required:"true"`

	// A complex type that contains zero or more CustomErrorResponses elements.
	CustomErrorResponses *CustomErrorResponses `type:"structure" required:"true"`

	// A complex type that describes the default cache behavior if you do not specify
	// a CacheBehavior element or if files don't match any of the values of PathPattern
	// in CacheBehavior elements.You must create exactly one default cache behavior.
	DefaultCacheBehavior *DefaultCacheBehavior `type:"structure" required:"true"`

	// The domain name corresponding to the distribution. For example: d604721fxaaqy9.cloudfront.net.
	DomainName *string `type:"string" required:"true"`

	// Whether the distribution is enabled to accept end user requests for content.
	Enabled *bool `type:"boolean" required:"true"`

	// The identifier for the distribution. For example: EDFDVBD632BHDS5.
	Id *string `type:"string" required:"true"`

	// The date and time the distribution was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A complex type that contains information about origins for this distribution.
	Origins *Origins `type:"structure" required:"true"`

	PriceClass *string `type:"string" required:"true" enum:"PriceClass"`

	// A complex type that identifies ways in which you want to restrict distribution
	// of your content.
	Restrictions *Restrictions `type:"structure" required:"true"`

	// This response element indicates the current status of the distribution. When
	// the status is Deployed, the distribution's information is fully propagated
	// throughout the Amazon CloudFront system.
	Status *string `type:"string" required:"true"`

	// A complex type that contains information about viewer certificates for this
	// distribution.
	ViewerCertificate *ViewerCertificate `type:"structure" required:"true"`

	// The Web ACL Id (if any) associated with the distribution.
	WebACLId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DistributionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DistributionSummary) GoString() string {
	return s.String()
}

// A complex type that specifies how CloudFront handles query strings, cookies
// and headers.
type ForwardedValues struct {
	_ struct{} `type:"structure"`

	// A complex type that specifies how CloudFront handles cookies.
	Cookies *CookiePreference `type:"structure" required:"true"`

	// A complex type that specifies the Headers, if any, that you want CloudFront
	// to vary upon for this cache behavior.
	Headers *Headers `type:"structure"`

	// Indicates whether you want CloudFront to forward query strings to the origin
	// that is associated with this cache behavior. If so, specify true; if not,
	// specify false.
	QueryString *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s ForwardedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForwardedValues) GoString() string {
	return s.String()
}

// A complex type that controls the countries in which your content is distributed.
// For more information about geo restriction, go to Customizing Error Responses
// in the Amazon CloudFront Developer Guide. CloudFront determines the location
// of your users using MaxMind GeoIP databases. For information about the accuracy
// of these databases, see How accurate are your GeoIP databases? on the MaxMind
// website.
type GeoRestriction struct {
	_ struct{} `type:"structure"`

	// A complex type that contains a Location element for each country in which
	// you want CloudFront either to distribute your content (whitelist) or not
	// distribute your content (blacklist). The Location element is a two-letter,
	// uppercase country code for a country that you want to include in your blacklist
	// or whitelist. Include one Location element for each country. CloudFront and
	// MaxMind both use ISO 3166 country codes. For the current list of countries
	// and the corresponding codes, see ISO 3166-1-alpha-2 code on the International
	// Organization for Standardization website. You can also refer to the country
	// list in the CloudFront console, which includes both country names and codes.
	Items []*string `locationNameList:"Location" type:"list"`

	// When geo restriction is enabled, this is the number of countries in your
	// whitelist or blacklist. Otherwise, when it is not enabled, Quantity is 0,
	// and you can omit Items.
	Quantity *int64 `type:"integer" required:"true"`

	// The method that you want to use to restrict distribution of your content
	// by country: - none: No geo restriction is enabled, meaning access to content
	// is not restricted by client geo location. - blacklist: The Location elements
	// specify the countries in which you do not want CloudFront to distribute your
	// content. - whitelist: The Location elements specify the countries in which
	// you want CloudFront to distribute your content.
	RestrictionType *string `type:"string" required:"true" enum:"GeoRestrictionType"`
}

// String returns the string representation
func (s GeoRestriction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoRestriction) GoString() string {
	return s.String()
}

// The request to get an origin access identity's configuration.
type GetCloudFrontOriginAccessIdentityConfigInput struct {
	_ struct{} `type:"structure"`

	// The identity's id.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCloudFrontOriginAccessIdentityConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCloudFrontOriginAccessIdentityConfigInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type GetCloudFrontOriginAccessIdentityConfigOutput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentityConfig"`

	// The origin access identity's configuration information.
	CloudFrontOriginAccessIdentityConfig *OriginAccessIdentityConfig `type:"structure"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetCloudFrontOriginAccessIdentityConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCloudFrontOriginAccessIdentityConfigOutput) GoString() string {
	return s.String()
}

// The request to get an origin access identity's information.
type GetCloudFrontOriginAccessIdentityInput struct {
	_ struct{} `type:"structure"`

	// The identity's id.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCloudFrontOriginAccessIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCloudFrontOriginAccessIdentityInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type GetCloudFrontOriginAccessIdentityOutput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentity"`

	// The origin access identity's information.
	CloudFrontOriginAccessIdentity *OriginAccessIdentity `type:"structure"`

	// The current version of the origin access identity's information. For example:
	// E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetCloudFrontOriginAccessIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCloudFrontOriginAccessIdentityOutput) GoString() string {
	return s.String()
}

// The request to get a distribution configuration.
type GetDistributionConfigInput struct {
	_ struct{} `type:"structure"`

	// The distribution's id.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDistributionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDistributionConfigInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type GetDistributionConfigOutput struct {
	_ struct{} `type:"structure" payload:"DistributionConfig"`

	// The distribution's configuration information.
	DistributionConfig *DistributionConfig `type:"structure"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetDistributionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDistributionConfigOutput) GoString() string {
	return s.String()
}

// The request to get a distribution's information.
type GetDistributionInput struct {
	_ struct{} `type:"structure"`

	// The distribution's id.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDistributionInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type GetDistributionOutput struct {
	_ struct{} `type:"structure" payload:"Distribution"`

	// The distribution's information.
	Distribution *Distribution `type:"structure"`

	// The current version of the distribution's information. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s GetDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDistributionOutput) GoString() string {
	return s.String()
}

// The request to get an invalidation's information.
type GetInvalidationInput struct {
	_ struct{} `type:"structure"`

	// The distribution's id.
	DistributionId *string `location:"uri" locationName:"DistributionId" type:"string" required:"true"`

	// The invalidation's id.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInvalidationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvalidationInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type GetInvalidationOutput struct {
	_ struct{} `type:"structure" payload:"Invalidation"`

	// The invalidation's information.
	Invalidation *Invalidation `type:"structure"`
}

// String returns the string representation
func (s GetInvalidationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInvalidationOutput) GoString() string {
	return s.String()
}

// To request to get a streaming distribution configuration.
type GetStreamingDistributionConfigInput struct {
	_ struct{} `type:"structure"`

	// The streaming distribution's id.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStreamingDistributionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamingDistributionConfigInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type GetStreamingDistributionConfigOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistributionConfig"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The streaming distribution's configuration information.
	StreamingDistributionConfig *StreamingDistributionConfig `type:"structure"`
}

// String returns the string representation
func (s GetStreamingDistributionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamingDistributionConfigOutput) GoString() string {
	return s.String()
}

// The request to get a streaming distribution's information.
type GetStreamingDistributionInput struct {
	_ struct{} `type:"structure"`

	// The streaming distribution's id.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStreamingDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamingDistributionInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type GetStreamingDistributionOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistribution"`

	// The current version of the streaming distribution's information. For example:
	// E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The streaming distribution's information.
	StreamingDistribution *StreamingDistribution `type:"structure"`
}

// String returns the string representation
func (s GetStreamingDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStreamingDistributionOutput) GoString() string {
	return s.String()
}

// A complex type that specifies the headers that you want CloudFront to forward
// to the origin for this cache behavior. For the headers that you specify,
// CloudFront also caches separate versions of a given object based on the header
// values in viewer requests; this is known as varying on headers. For example,
// suppose viewer requests for logo.jpg contain a custom Product header that
// has a value of either Acme or Apex, and you configure CloudFront to vary
// on the Product header. CloudFront forwards the Product header to the origin
// and caches the response from the origin once for each header value.
type Headers struct {
	_ struct{} `type:"structure"`

	// Optional: A complex type that contains a Name element for each header that
	// you want CloudFront to forward to the origin and to vary on for this cache
	// behavior. If Quantity is 0, omit Items.
	Items []*string `locationNameList:"Name" type:"list"`

	// The number of different headers that you want CloudFront to forward to the
	// origin and to vary on for this cache behavior. The maximum number of headers
	// that you can specify by name is 10. If you want CloudFront to forward all
	// headers to the origin and vary on all of them, specify 1 for Quantity and
	// * for Name. If you don't want CloudFront to forward any additional headers
	// to the origin or to vary on any headers, specify 0 for Quantity and omit
	// Items.
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Headers) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Headers) GoString() string {
	return s.String()
}

// An invalidation.
type Invalidation struct {
	_ struct{} `type:"structure"`

	// The date and time the invalidation request was first made.
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The identifier for the invalidation request. For example: IDFDVBD632BHDS5.
	Id *string `type:"string" required:"true"`

	// The current invalidation information for the batch request.
	InvalidationBatch *InvalidationBatch `type:"structure" required:"true"`

	// The status of the invalidation request. When the invalidation batch is finished,
	// the status is Completed.
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Invalidation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Invalidation) GoString() string {
	return s.String()
}

// An invalidation batch.
type InvalidationBatch struct {
	_ struct{} `type:"structure"`

	// A unique name that ensures the request can't be replayed. If the CallerReference
	// is new (no matter the content of the Path object), a new distribution is
	// created. If the CallerReference is a value you already sent in a previous
	// request to create an invalidation batch, and the content of each Path element
	// is identical to the original request, the response includes the same information
	// returned to the original request. If the CallerReference is a value you already
	// sent in a previous request to create a distribution but the content of any
	// Path is different from the original request, CloudFront returns an InvalidationBatchAlreadyExists
	// error.
	CallerReference *string `type:"string" required:"true"`

	// The path of the object to invalidate. The path is relative to the distribution
	// and must begin with a slash (/). You must enclose each invalidation object
	// with the Path element tags. If the path includes non-ASCII characters or
	// unsafe characters as defined in RFC 1783 (http://www.ietf.org/rfc/rfc1738.txt),
	// URL encode those characters. Do not URL encode any other characters in the
	// path, or CloudFront will not invalidate the old version of the updated object.
	Paths *Paths `type:"structure" required:"true"`
}

// String returns the string representation
func (s InvalidationBatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidationBatch) GoString() string {
	return s.String()
}

// An invalidation list.
type InvalidationList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more invalidation batch requests remain to
	// be listed. If your results were truncated, you can make a follow-up pagination
	// request using the Marker request parameter to retrieve more invalidation
	// batches in the list.
	IsTruncated *bool `type:"boolean" required:"true"`

	// A complex type that contains one InvalidationSummary element for each invalidation
	// batch that was created by the current AWS account.
	Items []*InvalidationSummary `locationNameList:"InvalidationSummary" type:"list"`

	// The value you provided for the Marker request parameter.
	Marker *string `type:"string" required:"true"`

	// The value you provided for the MaxItems request parameter.
	MaxItems *int64 `type:"integer" required:"true"`

	// If IsTruncated is true, this element is present and contains the value you
	// can use for the Marker request parameter to continue listing your invalidation
	// batches where they left off.
	NextMarker *string `type:"string"`

	// The number of invalidation batches that were created by the current AWS account.
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s InvalidationList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidationList) GoString() string {
	return s.String()
}

// Summary of an invalidation request.
type InvalidationSummary struct {
	_ struct{} `type:"structure"`

	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The unique ID for an invalidation request.
	Id *string `type:"string" required:"true"`

	// The status of an invalidation request.
	Status *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InvalidationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidationSummary) GoString() string {
	return s.String()
}

// A complex type that lists the active CloudFront key pairs, if any, that are
// associated with AwsAccountNumber.
type KeyPairIds struct {
	_ struct{} `type:"structure"`

	// A complex type that lists the active CloudFront key pairs, if any, that are
	// associated with AwsAccountNumber.
	Items []*string `locationNameList:"KeyPairId" type:"list"`

	// The number of active CloudFront key pairs for AwsAccountNumber.
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s KeyPairIds) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyPairIds) GoString() string {
	return s.String()
}

// The request to list origin access identities.
type ListCloudFrontOriginAccessIdentitiesInput struct {
	_ struct{} `type:"structure"`

	// Use this when paginating results to indicate where to begin in your list
	// of origin access identities. The results include identities in the list that
	// occur after the marker. To get the next page of results, set the Marker to
	// the value of the NextMarker from the current page's response (which is also
	// the ID of the last identity on that page).
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of origin access identities you want in the response body.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListCloudFrontOriginAccessIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCloudFrontOriginAccessIdentitiesInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type ListCloudFrontOriginAccessIdentitiesOutput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentityList"`

	// The CloudFrontOriginAccessIdentityList type.
	CloudFrontOriginAccessIdentityList *OriginAccessIdentityList `type:"structure"`
}

// String returns the string representation
func (s ListCloudFrontOriginAccessIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCloudFrontOriginAccessIdentitiesOutput) GoString() string {
	return s.String()
}

// The request to list distributions that are associated with a specified AWS
// WAF web ACL.
type ListDistributionsByWebACLIdInput struct {
	_ struct{} `type:"structure"`

	// Use Marker and MaxItems to control pagination of results. If you have more
	// than MaxItems distributions that satisfy the request, the response includes
	// a NextMarker element. To get the next page of results, submit another request.
	// For the value of Marker, specify the value of NextMarker from the last response.
	// (For the first request, omit Marker.)
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of distributions that you want CloudFront to return in
	// the response body. The maximum and default values are both 100.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`

	// The Id of the AWS WAF web ACL for which you want to list the associated distributions.
	// If you specify "null" for the Id, the request returns a list of the distributions
	// that aren't associated with a web ACL.
	WebACLId *string `location:"uri" locationName:"WebACLId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListDistributionsByWebACLIdInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsByWebACLIdInput) GoString() string {
	return s.String()
}

// The response to a request to list the distributions that are associated with
// a specified AWS WAF web ACL.
type ListDistributionsByWebACLIdOutput struct {
	_ struct{} `type:"structure" payload:"DistributionList"`

	// The DistributionList type.
	DistributionList *DistributionList `type:"structure"`
}

// String returns the string representation
func (s ListDistributionsByWebACLIdOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsByWebACLIdOutput) GoString() string {
	return s.String()
}

// The request to list your distributions.
type ListDistributionsInput struct {
	_ struct{} `type:"structure"`

	// Use Marker and MaxItems to control pagination of results. If you have more
	// than MaxItems distributions that satisfy the request, the response includes
	// a NextMarker element. To get the next page of results, submit another request.
	// For the value of Marker, specify the value of NextMarker from the last response.
	// (For the first request, omit Marker.)
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of distributions that you want CloudFront to return in
	// the response body. The maximum and default values are both 100.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListDistributionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type ListDistributionsOutput struct {
	_ struct{} `type:"structure" payload:"DistributionList"`

	// The DistributionList type.
	DistributionList *DistributionList `type:"structure"`
}

// String returns the string representation
func (s ListDistributionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDistributionsOutput) GoString() string {
	return s.String()
}

// The request to list invalidations.
type ListInvalidationsInput struct {
	_ struct{} `type:"structure"`

	// The distribution's id.
	DistributionId *string `location:"uri" locationName:"DistributionId" type:"string" required:"true"`

	// Use this parameter when paginating results to indicate where to begin in
	// your list of invalidation batches. Because the results are returned in decreasing
	// order from most recent to oldest, the most recent results are on the first
	// page, the second page will contain earlier results, and so on. To get the
	// next page of results, set the Marker to the value of the NextMarker from
	// the current page's response. This value is the same as the ID of the last
	// invalidation batch on that page.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of invalidation batches you want in the response body.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListInvalidationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvalidationsInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type ListInvalidationsOutput struct {
	_ struct{} `type:"structure" payload:"InvalidationList"`

	// Information about invalidation batches.
	InvalidationList *InvalidationList `type:"structure"`
}

// String returns the string representation
func (s ListInvalidationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInvalidationsOutput) GoString() string {
	return s.String()
}

// The request to list your streaming distributions.
type ListStreamingDistributionsInput struct {
	_ struct{} `type:"structure"`

	// Use this when paginating results to indicate where to begin in your list
	// of streaming distributions. The results include distributions in the list
	// that occur after the marker. To get the next page of results, set the Marker
	// to the value of the NextMarker from the current page's response (which is
	// also the ID of the last distribution on that page).
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of streaming distributions you want in the response body.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" type:"integer"`
}

// String returns the string representation
func (s ListStreamingDistributionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamingDistributionsInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type ListStreamingDistributionsOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistributionList"`

	// The StreamingDistributionList type.
	StreamingDistributionList *StreamingDistributionList `type:"structure"`
}

// String returns the string representation
func (s ListStreamingDistributionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamingDistributionsOutput) GoString() string {
	return s.String()
}

// A complex type that controls whether access logs are written for the distribution.
type LoggingConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket to store the access logs in, for example, myawslogbucket.s3.amazonaws.com.
	Bucket *string `type:"string" required:"true"`

	// Specifies whether you want CloudFront to save access logs to an Amazon S3
	// bucket. If you do not want to enable logging when you create a distribution
	// or if you want to disable logging for an existing distribution, specify false
	// for Enabled, and specify empty Bucket and Prefix elements. If you specify
	// false for Enabled but you specify values for Bucket, prefix and IncludeCookies,
	// the values are automatically deleted.
	Enabled *bool `type:"boolean" required:"true"`

	// Specifies whether you want CloudFront to include cookies in access logs,
	// specify true for IncludeCookies. If you choose to include cookies in logs,
	// CloudFront logs all cookies regardless of how you configure the cache behaviors
	// for this distribution. If you do not want to include cookies when you create
	// a distribution or if you want to disable include cookies for an existing
	// distribution, specify false for IncludeCookies.
	IncludeCookies *bool `type:"boolean" required:"true"`

	// An optional string that you want CloudFront to prefix to the access log filenames
	// for this distribution, for example, myprefix/. If you want to enable logging,
	// but you do not want to specify a prefix, you still must include an empty
	// Prefix element in the Logging element.
	Prefix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingConfig) GoString() string {
	return s.String()
}

// A complex type that describes the Amazon S3 bucket or the HTTP server (for
// example, a web server) from which CloudFront gets your files.You must create
// at least one origin.
type Origin struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the custom headers associated
	// with this Origin.
	CustomHeaders *CustomHeaders `type:"structure"`

	// A complex type that contains information about a custom origin. If the origin
	// is an Amazon S3 bucket, use the S3OriginConfig element instead.
	CustomOriginConfig *CustomOriginConfig `type:"structure"`

	// Amazon S3 origins: The DNS name of the Amazon S3 bucket from which you want
	// CloudFront to get objects for this origin, for example, myawsbucket.s3.amazonaws.com.
	// Custom origins: The DNS domain name for the HTTP server from which you want
	// CloudFront to get objects for this origin, for example, www.example.com.
	DomainName *string `type:"string" required:"true"`

	// A unique identifier for the origin. The value of Id must be unique within
	// the distribution. You use the value of Id when you create a cache behavior.
	// The Id identifies the origin that CloudFront routes a request to when the
	// request matches the path pattern for that cache behavior.
	Id *string `type:"string" required:"true"`

	// An optional element that causes CloudFront to request your content from a
	// directory in your Amazon S3 bucket or your custom origin. When you include
	// the OriginPath element, specify the directory name, beginning with a /. CloudFront
	// appends the directory name to the value of DomainName.
	OriginPath *string `type:"string"`

	// A complex type that contains information about the Amazon S3 origin. If the
	// origin is a custom origin, use the CustomOriginConfig element instead.
	S3OriginConfig *S3OriginConfig `type:"structure"`
}

// String returns the string representation
func (s Origin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Origin) GoString() string {
	return s.String()
}

// CloudFront origin access identity.
type OriginAccessIdentity struct {
	_ struct{} `type:"structure"`

	// The current configuration information for the identity.
	CloudFrontOriginAccessIdentityConfig *OriginAccessIdentityConfig `type:"structure"`

	// The ID for the origin access identity. For example: E74FTE3AJFJ256A.
	Id *string `type:"string" required:"true"`

	// The Amazon S3 canonical user ID for the origin access identity, which you
	// use when giving the origin access identity read permission to an object in
	// Amazon S3.
	S3CanonicalUserId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginAccessIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginAccessIdentity) GoString() string {
	return s.String()
}

// Origin access identity configuration.
type OriginAccessIdentityConfig struct {
	_ struct{} `type:"structure"`

	// A unique number that ensures the request can't be replayed. If the CallerReference
	// is new (no matter the content of the CloudFrontOriginAccessIdentityConfig
	// object), a new origin access identity is created. If the CallerReference
	// is a value you already sent in a previous request to create an identity,
	// and the content of the CloudFrontOriginAccessIdentityConfig is identical
	// to the original request (ignoring white space), the response includes the
	// same information returned to the original request. If the CallerReference
	// is a value you already sent in a previous request to create an identity but
	// the content of the CloudFrontOriginAccessIdentityConfig is different from
	// the original request, CloudFront returns a CloudFrontOriginAccessIdentityAlreadyExists
	// error.
	CallerReference *string `type:"string" required:"true"`

	// Any comments you want to include about the origin access identity.
	Comment *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginAccessIdentityConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginAccessIdentityConfig) GoString() string {
	return s.String()
}

// The CloudFrontOriginAccessIdentityList type.
type OriginAccessIdentityList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more origin access identities remain to be
	// listed. If your results were truncated, you can make a follow-up pagination
	// request using the Marker request parameter to retrieve more items in the
	// list.
	IsTruncated *bool `type:"boolean" required:"true"`

	// A complex type that contains one CloudFrontOriginAccessIdentitySummary element
	// for each origin access identity that was created by the current AWS account.
	Items []*OriginAccessIdentitySummary `locationNameList:"CloudFrontOriginAccessIdentitySummary" type:"list"`

	// The value you provided for the Marker request parameter.
	Marker *string `type:"string" required:"true"`

	// The value you provided for the MaxItems request parameter.
	MaxItems *int64 `type:"integer" required:"true"`

	// If IsTruncated is true, this element is present and contains the value you
	// can use for the Marker request parameter to continue listing your origin
	// access identities where they left off.
	NextMarker *string `type:"string"`

	// The number of CloudFront origin access identities that were created by the
	// current AWS account.
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s OriginAccessIdentityList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginAccessIdentityList) GoString() string {
	return s.String()
}

// Summary of the information about a CloudFront origin access identity.
type OriginAccessIdentitySummary struct {
	_ struct{} `type:"structure"`

	// The comment for this origin access identity, as originally specified when
	// created.
	Comment *string `type:"string" required:"true"`

	// The ID for the origin access identity. For example: E74FTE3AJFJ256A.
	Id *string `type:"string" required:"true"`

	// The Amazon S3 canonical user ID for the origin access identity, which you
	// use when giving the origin access identity read permission to an object in
	// Amazon S3.
	S3CanonicalUserId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginAccessIdentitySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginAccessIdentitySummary) GoString() string {
	return s.String()
}

// A complex type that contains information related to a Header
type OriginCustomHeader struct {
	_ struct{} `type:"structure"`

	// The header's name.
	HeaderName *string `type:"string" required:"true"`

	// The header's value.
	HeaderValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OriginCustomHeader) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginCustomHeader) GoString() string {
	return s.String()
}

// A complex type that contains the list of SSL/TLS protocols that you want
// CloudFront to use when communicating with your origin over HTTPS.
type OriginSslProtocols struct {
	_ struct{} `type:"structure"`

	// A complex type that contains one SslProtocol element for each SSL/TLS protocol
	// that you want to allow CloudFront to use when establishing an HTTPS connection
	// with this origin.
	Items []*string `locationNameList:"SslProtocol" type:"list" required:"true"`

	// The number of SSL/TLS protocols that you want to allow CloudFront to use
	// when establishing an HTTPS connection with this origin.
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s OriginSslProtocols) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginSslProtocols) GoString() string {
	return s.String()
}

// A complex type that contains information about origins for this distribution.
type Origins struct {
	_ struct{} `type:"structure"`

	// A complex type that contains origins for this distribution.
	Items []*Origin `locationNameList:"Origin" min:"1" type:"list"`

	// The number of origins for this distribution.
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Origins) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Origins) GoString() string {
	return s.String()
}

// A complex type that contains information about the objects that you want
// to invalidate.
type Paths struct {
	_ struct{} `type:"structure"`

	// A complex type that contains a list of the objects that you want to invalidate.
	Items []*string `locationNameList:"Path" type:"list"`

	// The number of objects that you want to invalidate.
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Paths) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Paths) GoString() string {
	return s.String()
}

// A complex type that identifies ways in which you want to restrict distribution
// of your content.
type Restrictions struct {
	_ struct{} `type:"structure"`

	// A complex type that controls the countries in which your content is distributed.
	// For more information about geo restriction, go to Customizing Error Responses
	// in the Amazon CloudFront Developer Guide. CloudFront determines the location
	// of your users using MaxMind GeoIP databases. For information about the accuracy
	// of these databases, see How accurate are your GeoIP databases? on the MaxMind
	// website.
	GeoRestriction *GeoRestriction `type:"structure" required:"true"`
}

// String returns the string representation
func (s Restrictions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Restrictions) GoString() string {
	return s.String()
}

// A complex type that contains information about the Amazon S3 bucket from
// which you want CloudFront to get your media files for distribution.
type S3Origin struct {
	_ struct{} `type:"structure"`

	// The DNS name of the S3 origin.
	DomainName *string `type:"string" required:"true"`

	// Your S3 origin's origin access identity.
	OriginAccessIdentity *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3Origin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Origin) GoString() string {
	return s.String()
}

// A complex type that contains information about the Amazon S3 origin. If the
// origin is a custom origin, use the CustomOriginConfig element instead.
type S3OriginConfig struct {
	_ struct{} `type:"structure"`

	// The CloudFront origin access identity to associate with the origin. Use an
	// origin access identity to configure the origin so that end users can only
	// access objects in an Amazon S3 bucket through CloudFront. If you want end
	// users to be able to access objects using either the CloudFront URL or the
	// Amazon S3 URL, specify an empty OriginAccessIdentity element. To delete the
	// origin access identity from an existing distribution, update the distribution
	// configuration and include an empty OriginAccessIdentity element. To replace
	// the origin access identity, update the distribution configuration and specify
	// the new origin access identity. Use the format origin-access-identity/cloudfront/Id
	// where Id is the value that CloudFront returned in the Id element when you
	// created the origin access identity.
	OriginAccessIdentity *string `type:"string" required:"true"`
}

// String returns the string representation
func (s S3OriginConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3OriginConfig) GoString() string {
	return s.String()
}

// A complex type that lists the AWS accounts that were included in the TrustedSigners
// complex type, as well as their active CloudFront key pair IDs, if any.
type Signer struct {
	_ struct{} `type:"structure"`

	// Specifies an AWS account that can create signed URLs. Values: self, which
	// indicates that the AWS account that was used to create the distribution can
	// created signed URLs, or an AWS account number. Omit the dashes in the account
	// number.
	AwsAccountNumber *string `type:"string"`

	// A complex type that lists the active CloudFront key pairs, if any, that are
	// associated with AwsAccountNumber.
	KeyPairIds *KeyPairIds `type:"structure"`
}

// String returns the string representation
func (s Signer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Signer) GoString() string {
	return s.String()
}

// A streaming distribution.
type StreamingDistribution struct {
	_ struct{} `type:"structure"`

	// CloudFront automatically adds this element to the response only if you've
	// set up the distribution to serve private content with signed URLs. The element
	// lists the key pair IDs that CloudFront is aware of for each trusted signer.
	// The Signer child element lists the AWS account number of the trusted signer
	// (or an empty Self element if the signer is you). The Signer element also
	// includes the IDs of any active key pairs associated with the trusted signer's
	// AWS account. If no KeyPairId element appears for a Signer, that signer can't
	// create working signed URLs.
	ActiveTrustedSigners *ActiveTrustedSigners `type:"structure" required:"true"`

	// The domain name corresponding to the streaming distribution. For example:
	// s5c39gqb8ow64r.cloudfront.net.
	DomainName *string `type:"string" required:"true"`

	// The identifier for the streaming distribution. For example: EGTXBD79H29TRA8.
	Id *string `type:"string" required:"true"`

	// The date and time the distribution was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The current status of the streaming distribution. When the status is Deployed,
	// the distribution's information is fully propagated throughout the Amazon
	// CloudFront system.
	Status *string `type:"string" required:"true"`

	// The current configuration information for the streaming distribution.
	StreamingDistributionConfig *StreamingDistributionConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s StreamingDistribution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingDistribution) GoString() string {
	return s.String()
}

// The configuration for the streaming distribution.
type StreamingDistributionConfig struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this streaming distribution.
	Aliases *Aliases `type:"structure"`

	// A unique number that ensures the request can't be replayed. If the CallerReference
	// is new (no matter the content of the StreamingDistributionConfig object),
	// a new streaming distribution is created. If the CallerReference is a value
	// you already sent in a previous request to create a streaming distribution,
	// and the content of the StreamingDistributionConfig is identical to the original
	// request (ignoring white space), the response includes the same information
	// returned to the original request. If the CallerReference is a value you already
	// sent in a previous request to create a streaming distribution but the content
	// of the StreamingDistributionConfig is different from the original request,
	// CloudFront returns a DistributionAlreadyExists error.
	CallerReference *string `type:"string" required:"true"`

	// Any comments you want to include about the streaming distribution.
	Comment *string `type:"string" required:"true"`

	// Whether the streaming distribution is enabled to accept end user requests
	// for content.
	Enabled *bool `type:"boolean" required:"true"`

	// A complex type that controls whether access logs are written for the streaming
	// distribution.
	Logging *StreamingLoggingConfig `type:"structure"`

	// A complex type that contains information about price class for this streaming
	// distribution.
	PriceClass *string `type:"string" enum:"PriceClass"`

	// A complex type that contains information about the Amazon S3 bucket from
	// which you want CloudFront to get your media files for distribution.
	S3Origin *S3Origin `type:"structure" required:"true"`

	// A complex type that specifies the AWS accounts, if any, that you want to
	// allow to create signed URLs for private content. If you want to require signed
	// URLs in requests for objects in the target origin that match the PathPattern
	// for this cache behavior, specify true for Enabled, and specify the applicable
	// values for Quantity and Items. For more information, go to Using a Signed
	// URL to Serve Private Content in the Amazon CloudFront Developer Guide. If
	// you don't want to require signed URLs in requests for objects that match
	// PathPattern, specify false for Enabled and 0 for Quantity. Omit Items. To
	// add, change, or remove one or more trusted signers, change Enabled to true
	// (if it's currently false), change Quantity as applicable, and specify all
	// of the trusted signers that you want to include in the updated distribution.
	TrustedSigners *TrustedSigners `type:"structure" required:"true"`
}

// String returns the string representation
func (s StreamingDistributionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingDistributionConfig) GoString() string {
	return s.String()
}

// A streaming distribution list.
type StreamingDistributionList struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether more streaming distributions remain to be listed.
	// If your results were truncated, you can make a follow-up pagination request
	// using the Marker request parameter to retrieve more distributions in the
	// list.
	IsTruncated *bool `type:"boolean" required:"true"`

	// A complex type that contains one StreamingDistributionSummary element for
	// each distribution that was created by the current AWS account.
	Items []*StreamingDistributionSummary `locationNameList:"StreamingDistributionSummary" type:"list"`

	// The value you provided for the Marker request parameter.
	Marker *string `type:"string" required:"true"`

	// The value you provided for the MaxItems request parameter.
	MaxItems *int64 `type:"integer" required:"true"`

	// If IsTruncated is true, this element is present and contains the value you
	// can use for the Marker request parameter to continue listing your streaming
	// distributions where they left off.
	NextMarker *string `type:"string"`

	// The number of streaming distributions that were created by the current AWS
	// account.
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s StreamingDistributionList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingDistributionList) GoString() string {
	return s.String()
}

// A summary of the information for an Amazon CloudFront streaming distribution.
type StreamingDistributionSummary struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about CNAMEs (alternate domain names),
	// if any, for this streaming distribution.
	Aliases *Aliases `type:"structure" required:"true"`

	// The comment originally specified when this distribution was created.
	Comment *string `type:"string" required:"true"`

	// The domain name corresponding to the distribution. For example: d604721fxaaqy9.cloudfront.net.
	DomainName *string `type:"string" required:"true"`

	// Whether the distribution is enabled to accept end user requests for content.
	Enabled *bool `type:"boolean" required:"true"`

	// The identifier for the distribution. For example: EDFDVBD632BHDS5.
	Id *string `type:"string" required:"true"`

	// The date and time the distribution was last modified.
	LastModifiedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	PriceClass *string `type:"string" required:"true" enum:"PriceClass"`

	// A complex type that contains information about the Amazon S3 bucket from
	// which you want CloudFront to get your media files for distribution.
	S3Origin *S3Origin `type:"structure" required:"true"`

	// Indicates the current status of the distribution. When the status is Deployed,
	// the distribution's information is fully propagated throughout the Amazon
	// CloudFront system.
	Status *string `type:"string" required:"true"`

	// A complex type that specifies the AWS accounts, if any, that you want to
	// allow to create signed URLs for private content. If you want to require signed
	// URLs in requests for objects in the target origin that match the PathPattern
	// for this cache behavior, specify true for Enabled, and specify the applicable
	// values for Quantity and Items. For more information, go to Using a Signed
	// URL to Serve Private Content in the Amazon CloudFront Developer Guide. If
	// you don't want to require signed URLs in requests for objects that match
	// PathPattern, specify false for Enabled and 0 for Quantity. Omit Items. To
	// add, change, or remove one or more trusted signers, change Enabled to true
	// (if it's currently false), change Quantity as applicable, and specify all
	// of the trusted signers that you want to include in the updated distribution.
	TrustedSigners *TrustedSigners `type:"structure" required:"true"`
}

// String returns the string representation
func (s StreamingDistributionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingDistributionSummary) GoString() string {
	return s.String()
}

// A complex type that controls whether access logs are written for this streaming
// distribution.
type StreamingLoggingConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket to store the access logs in, for example, myawslogbucket.s3.amazonaws.com.
	Bucket *string `type:"string" required:"true"`

	// Specifies whether you want CloudFront to save access logs to an Amazon S3
	// bucket. If you do not want to enable logging when you create a streaming
	// distribution or if you want to disable logging for an existing streaming
	// distribution, specify false for Enabled, and specify empty Bucket and Prefix
	// elements. If you specify false for Enabled but you specify values for Bucket
	// and Prefix, the values are automatically deleted.
	Enabled *bool `type:"boolean" required:"true"`

	// An optional string that you want CloudFront to prefix to the access log filenames
	// for this streaming distribution, for example, myprefix/. If you want to enable
	// logging, but you do not want to specify a prefix, you still must include
	// an empty Prefix element in the Logging element.
	Prefix *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StreamingLoggingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingLoggingConfig) GoString() string {
	return s.String()
}

// A complex type that specifies the AWS accounts, if any, that you want to
// allow to create signed URLs for private content. If you want to require signed
// URLs in requests for objects in the target origin that match the PathPattern
// for this cache behavior, specify true for Enabled, and specify the applicable
// values for Quantity and Items. For more information, go to Using a Signed
// URL to Serve Private Content in the Amazon CloudFront Developer Guide. If
// you don't want to require signed URLs in requests for objects that match
// PathPattern, specify false for Enabled and 0 for Quantity. Omit Items. To
// add, change, or remove one or more trusted signers, change Enabled to true
// (if it's currently false), change Quantity as applicable, and specify all
// of the trusted signers that you want to include in the updated distribution.
type TrustedSigners struct {
	_ struct{} `type:"structure"`

	// Specifies whether you want to require end users to use signed URLs to access
	// the files specified by PathPattern and TargetOriginId.
	Enabled *bool `type:"boolean" required:"true"`

	// Optional: A complex type that contains trusted signers for this cache behavior.
	// If Quantity is 0, you can omit Items.
	Items []*string `locationNameList:"AwsAccountNumber" type:"list"`

	// The number of trusted signers for this cache behavior.
	Quantity *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s TrustedSigners) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedSigners) GoString() string {
	return s.String()
}

// The request to update an origin access identity.
type UpdateCloudFrontOriginAccessIdentityInput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentityConfig"`

	// The identity's configuration information.
	CloudFrontOriginAccessIdentityConfig *OriginAccessIdentityConfig `locationName:"CloudFrontOriginAccessIdentityConfig" type:"structure" required:"true"`

	// The identity's id.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header you received when retrieving the identity's
	// configuration. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s UpdateCloudFrontOriginAccessIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCloudFrontOriginAccessIdentityInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type UpdateCloudFrontOriginAccessIdentityOutput struct {
	_ struct{} `type:"structure" payload:"CloudFrontOriginAccessIdentity"`

	// The origin access identity's information.
	CloudFrontOriginAccessIdentity *OriginAccessIdentity `type:"structure"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s UpdateCloudFrontOriginAccessIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCloudFrontOriginAccessIdentityOutput) GoString() string {
	return s.String()
}

// The request to update a distribution.
type UpdateDistributionInput struct {
	_ struct{} `type:"structure" payload:"DistributionConfig"`

	// The distribution's configuration information.
	DistributionConfig *DistributionConfig `locationName:"DistributionConfig" type:"structure" required:"true"`

	// The distribution's id.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header you received when retrieving the distribution's
	// configuration. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`
}

// String returns the string representation
func (s UpdateDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDistributionInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type UpdateDistributionOutput struct {
	_ struct{} `type:"structure" payload:"Distribution"`

	// The distribution's information.
	Distribution *Distribution `type:"structure"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`
}

// String returns the string representation
func (s UpdateDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDistributionOutput) GoString() string {
	return s.String()
}

// The request to update a streaming distribution.
type UpdateStreamingDistributionInput struct {
	_ struct{} `type:"structure" payload:"StreamingDistributionConfig"`

	// The streaming distribution's id.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header you received when retrieving the streaming distribution's
	// configuration. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// The streaming distribution's configuration information.
	StreamingDistributionConfig *StreamingDistributionConfig `locationName:"StreamingDistributionConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateStreamingDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStreamingDistributionInput) GoString() string {
	return s.String()
}

// The returned result of the corresponding request.
type UpdateStreamingDistributionOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistribution"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The streaming distribution's information.
	StreamingDistribution *StreamingDistribution `type:"structure"`
}

// String returns the string representation
func (s UpdateStreamingDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStreamingDistributionOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about viewer certificates for this
// distribution.
type ViewerCertificate struct {
	_ struct{} `type:"structure"`

	// If you want viewers to use HTTPS to request your objects and you're using
	// an alternate domain name in your object URLs (for example, https://example.com/logo.jpg),
	// specify the ACM certificate ARN of the custom viewer certificate for this
	// distribution. Specify either this value, IAMCertificateId, or CloudFrontDefaultCertificate.
	ACMCertificateArn *string `type:"string"`

	// Note: this field is deprecated. Please use one of [ACMCertificateArn, IAMCertificateId,
	// CloudFrontDefaultCertificate].
	Certificate *string `deprecated:"true" type:"string"`

	// Note: this field is deprecated. Please use one of [ACMCertificateArn, IAMCertificateId,
	// CloudFrontDefaultCertificate].
	CertificateSource *string `deprecated:"true" type:"string" enum:"CertificateSource"`

	// If you want viewers to use HTTPS to request your objects and you're using
	// the CloudFront domain name of your distribution in your object URLs (for
	// example, https://d111111abcdef8.cloudfront.net/logo.jpg), set to true. Omit
	// this value if you are setting an ACMCertificateArn or IAMCertificateId.
	CloudFrontDefaultCertificate *bool `type:"boolean"`

	// If you want viewers to use HTTPS to request your objects and you're using
	// an alternate domain name in your object URLs (for example, https://example.com/logo.jpg),
	// specify the IAM certificate identifier of the custom viewer certificate for
	// this distribution. Specify either this value, ACMCertificateArn, or CloudFrontDefaultCertificate.
	IAMCertificateId *string `type:"string"`

	// Specify the minimum version of the SSL protocol that you want CloudFront
	// to use, SSLv3 or TLSv1, for HTTPS connections. CloudFront will serve your
	// objects only to browsers or devices that support at least the SSL version
	// that you specify. The TLSv1 protocol is more secure, so we recommend that
	// you specify SSLv3 only if your users are using browsers or devices that don't
	// support TLSv1. If you're using a custom certificate (if you specify a value
	// for IAMCertificateId) and if you're using dedicated IP (if you specify vip
	// for SSLSupportMethod), you can choose SSLv3 or TLSv1 as the MinimumProtocolVersion.
	// If you're using a custom certificate (if you specify a value for IAMCertificateId)
	// and if you're using SNI (if you specify sni-only for SSLSupportMethod), you
	// must specify TLSv1 for MinimumProtocolVersion.
	MinimumProtocolVersion *string `type:"string" enum:"MinimumProtocolVersion"`

	// If you specify a value for IAMCertificateId, you must also specify how you
	// want CloudFront to serve HTTPS requests. Valid values are vip and sni-only.
	// If you specify vip, CloudFront uses dedicated IP addresses for your content
	// and can respond to HTTPS requests from any viewer. However, you must request
	// permission to use this feature, and you incur additional monthly charges.
	// If you specify sni-only, CloudFront can only respond to HTTPS requests from
	// viewers that support Server Name Indication (SNI). All modern browsers support
	// SNI, but some browsers still in use don't support SNI. Do not specify a value
	// for SSLSupportMethod if you specified true for CloudFrontDefaultCertificate.
	SSLSupportMethod *string `type:"string" enum:"SSLSupportMethod"`
}

// String returns the string representation
func (s ViewerCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ViewerCertificate) GoString() string {
	return s.String()
}

const (
	// @enum CertificateSource
	CertificateSourceCloudfront = "cloudfront"
	// @enum CertificateSource
	CertificateSourceIam = "iam"
	// @enum CertificateSource
	CertificateSourceAcm = "acm"
)

const (
	// @enum GeoRestrictionType
	GeoRestrictionTypeBlacklist = "blacklist"
	// @enum GeoRestrictionType
	GeoRestrictionTypeWhitelist = "whitelist"
	// @enum GeoRestrictionType
	GeoRestrictionTypeNone = "none"
)

const (
	// @enum ItemSelection
	ItemSelectionNone = "none"
	// @enum ItemSelection
	ItemSelectionWhitelist = "whitelist"
	// @enum ItemSelection
	ItemSelectionAll = "all"
)

const (
	// @enum Method
	MethodGet = "GET"
	// @enum Method
	MethodHead = "HEAD"
	// @enum Method
	MethodPost = "POST"
	// @enum Method
	MethodPut = "PUT"
	// @enum Method
	MethodPatch = "PATCH"
	// @enum Method
	MethodOptions = "OPTIONS"
	// @enum Method
	MethodDelete = "DELETE"
)

const (
	// @enum MinimumProtocolVersion
	MinimumProtocolVersionSslv3 = "SSLv3"
	// @enum MinimumProtocolVersion
	MinimumProtocolVersionTlsv1 = "TLSv1"
)

const (
	// @enum OriginProtocolPolicy
	OriginProtocolPolicyHttpOnly = "http-only"
	// @enum OriginProtocolPolicy
	OriginProtocolPolicyMatchViewer = "match-viewer"
	// @enum OriginProtocolPolicy
	OriginProtocolPolicyHttpsOnly = "https-only"
)

const (
	// @enum PriceClass
	PriceClassPriceClass100 = "PriceClass_100"
	// @enum PriceClass
	PriceClassPriceClass200 = "PriceClass_200"
	// @enum PriceClass
	PriceClassPriceClassAll = "PriceClass_All"
)

const (
	// @enum SSLSupportMethod
	SSLSupportMethodSniOnly = "sni-only"
	// @enum SSLSupportMethod
	SSLSupportMethodVip = "vip"
)

const (
	// @enum SslProtocol
	SslProtocolSslv3 = "SSLv3"
	// @enum SslProtocol
	SslProtocolTlsv1 = "TLSv1"
	// @enum SslProtocol
	SslProtocolTlsv11 = "TLSv1.1"
	// @enum SslProtocol
	SslProtocolTlsv12 = "TLSv1.2"
)

const (
	// @enum ViewerProtocolPolicy
	ViewerProtocolPolicyAllowAll = "allow-all"
	// @enum ViewerProtocolPolicy
	ViewerProtocolPolicyHttpsOnly = "https-only"
	// @enum ViewerProtocolPolicy
	ViewerProtocolPolicyRedirectToHttps = "redirect-to-https"
)
